/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.hporbs;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.hporbs.DoubleHpBarComponent;
import com.duckblade.osrs.toa.features.hporbs.HpOrbMode;
import com.google.common.base.Strings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ProgressBarComponent;

public class HealthBarsOverlay
extends OverlayPanel {
    @Inject
    private Client client;
    @Inject
    private TombsOfAmascutConfig config;

    @Inject
    public HealthBarsOverlay(Client client, TombsOfAmascutConfig config) {
        this.client = client;
        this.config = config;
        this.panelComponent.setGap(new Point(0, 3));
        if (this.getPreferredPosition() == null) {
            this.setPreferredPosition(OverlayPosition.TOP_LEFT);
        }
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.config.hpOrbsMode() != HpOrbMode.HEALTH_BARS) {
            return null;
        }
        if (Strings.isNullOrEmpty(this.client.getVarcStrValue(1100))) {
            String playerName = this.client.getVarcStrValue(1099);
            double hpFactor = HealthBarsOverlay.hpFactor(this.client.getVarbitValue(14346) - 1);
            this.panelComponent.getChildren().add(this.buildHpBar(playerName, hpFactor));
            return super.render(graphics);
        }
        DoubleHpBarComponent current = new DoubleHpBarComponent();
        for (int i = 0; i < 8; ++i) {
            String playerName = this.client.getVarcStrValue(1099 + i);
            double hpFactor = HealthBarsOverlay.hpFactor(this.client.getVarbitValue(14346 + i) - 1);
            if (Strings.isNullOrEmpty(playerName)) continue;
            if (i % 2 == 0) {
                current.setCenterLabel1(playerName);
                current.setValue1(hpFactor);
                this.panelComponent.getChildren().add(current);
                continue;
            }
            current.setCenterLabel2(playerName);
            current.setValue2(hpFactor);
            current = new DoubleHpBarComponent();
        }
        return super.render(graphics);
    }

    private static double hpFactor(int hpVarb) {
        return (double)Math.max(hpVarb, 0) / 26.0;
    }

    private ProgressBarComponent buildHpBar(String name, double hpFactor) {
        ProgressBarComponent hpBar = new ProgressBarComponent();
        hpBar.setBackgroundColor(new Color(102, 15, 16, 230));
        hpBar.setForegroundColor(new Color(0, 146, 54, 230));
        hpBar.setLabelDisplayMode(ProgressBarComponent.LabelDisplayMode.TEXT_ONLY);
        hpBar.setCenterLabel(name);
        hpBar.setValue(hpFactor);
        hpBar.setMinimum(0L);
        hpBar.setMaximum(1L);
        hpBar.setPreferredSize(new Dimension(60, 20));
        return hpBar;
    }
}

