/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.timetracking;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidState;
import com.duckblade.osrs.toa.util.RaidStateChanged;
import com.duckblade.osrs.toa.util.TimerMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatLineBuffer;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MessageNode;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetUtil;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;

@Singleton
public class TargetTimeManager
implements PluginLifecycleComponent {
    private static final int SCRIPT_TOA_TIME_UPDATE_TIMER = 6581;
    static final int WIDGET_TIMER = WidgetUtil.packComponentId(481, 46);
    private static final String NO_TARGET_TIME_PREFIX = "You enter the Tombs of Amascut";
    private static final String TARGET_TIME_PREFIX = "Overall time to beat:";
    private static final Pattern TARGET_TIME_PATTERN = Pattern.compile("Overall time to beat: (\\d\\d):\\d\\d(?:\\.\\d\\d)?");
    private final EventBus eventBus;
    private final Client client;
    private int mins;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState currentState) {
        return config.targetTimeDisplay();
    }

    @Override
    public void startUp() {
        this.eventBus.register(this);
        ChatLineBuffer gameMessages = this.client.getChatLineMap().get(ChatMessageType.GAMEMESSAGE.getType());
        if (gameMessages != null) {
            for (int i = 0; i < gameMessages.getLength(); ++i) {
                MessageNode line = gameMessages.getLines()[i];
                if (NO_TARGET_TIME_PREFIX.equals(Text.removeTags(line.getValue()))) {
                    return;
                }
                if (!this.checkMessage(Text.removeTags(line.getValue()))) continue;
                return;
            }
        }
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (e.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        this.checkMessage(Text.removeTags(e.getMessage()));
    }

    @Subscribe
    public void onRaidStateChanged(RaidStateChanged e) {
        if (!e.getNewState().isInRaid()) {
            this.mins = -1;
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired e) {
        if (e.getScriptId() == 6581 && this.getTargetTime() != null) {
            Widget timer = this.client.getWidget(WIDGET_TIMER);
            if (timer == null || timer.getText().contains("/")) {
                return;
            }
            timer.setText(timer.getText() + " / " + this.getTargetTime());
            Widget resize1 = timer.getParent().getParent().getParent();
            Widget resize2 = resize1.getParent();
            resize1.setSize(200, resize1.getHeight());
            resize2.setSize(200, resize2.getHeight());
            timer.getParent().getParent().getParent().getParent().revalidate();
            timer.getParent().getParent().getParent().revalidate();
            timer.getParent().getParent().revalidate();
            timer.getParent().revalidate();
            timer.revalidate();
        }
    }

    private boolean checkMessage(String msg) {
        if (!msg.startsWith(TARGET_TIME_PREFIX)) {
            return false;
        }
        Matcher m3 = TARGET_TIME_PATTERN.matcher(msg);
        if (!m3.find()) {
            return false;
        }
        this.mins = Integer.parseInt(m3.group(1));
        return true;
    }

    public String getTargetTime() {
        return this.mins != -1 ? TargetTimeManager.formatTargetTime(TimerMode.fromClient(this.client), this.mins) : null;
    }

    private static String formatTargetTime(TimerMode timerMode, int mins) {
        return timerMode == TimerMode.PRECISE ? String.format("%02d:00.00", mins) : String.format("%02d:00", mins);
    }

    @Inject
    public TargetTimeManager(EventBus eventBus, Client client) {
        this.eventBus = eventBus;
        this.client = client;
    }
}

