/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxrelay3;

import com.jakewharton.rxrelay3.Relay;
import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ReplayRelay<T>
extends Relay<T> {
    final ReplayBuffer<T> buffer;
    final AtomicReference<ReplayDisposable<T>[]> observers;
    static final ReplayDisposable[] EMPTY = new ReplayDisposable[0];
    private static final Object[] EMPTY_ARRAY = new Object[0];

    @CheckReturnValue
    @NonNull
    public static <T> ReplayRelay<T> create() {
        return new ReplayRelay(new UnboundedReplayBuffer(16));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayRelay<T> create(int capacityHint) {
        return new ReplayRelay(new UnboundedReplayBuffer(capacityHint));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayRelay<T> createWithSize(int maxSize) {
        return new ReplayRelay(new SizeBoundReplayBuffer(maxSize));
    }

    static <T> ReplayRelay<T> createUnbounded() {
        return new ReplayRelay(new SizeBoundReplayBuffer(Integer.MAX_VALUE));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayRelay<T> createWithTime(long maxAge, TimeUnit unit, Scheduler scheduler) {
        return new ReplayRelay(new SizeAndTimeBoundReplayBuffer(Integer.MAX_VALUE, maxAge, unit, scheduler));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayRelay<T> createWithTimeAndSize(long maxAge, TimeUnit unit, Scheduler scheduler, int maxSize) {
        return new ReplayRelay(new SizeAndTimeBoundReplayBuffer(maxSize, maxAge, unit, scheduler));
    }

    ReplayRelay(ReplayBuffer<T> buffer) {
        this.buffer = buffer;
        this.observers = new AtomicReference<ReplayDisposable[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        ReplayDisposable<? super T> rs = new ReplayDisposable<T>(observer, this);
        observer.onSubscribe(rs);
        if (!rs.cancelled) {
            if (this.add(rs) && rs.cancelled) {
                this.remove(rs);
                return;
            }
            this.buffer.replay(rs);
        }
    }

    @Override
    public void accept(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        ReplayBuffer<T> b = this.buffer;
        b.add(value);
        for (ReplayDisposable<T> rs : this.observers.get()) {
            b.replay(rs);
        }
    }

    @Override
    public boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    int observerCount() {
        return this.observers.get().length;
    }

    @Nullable
    public T getValue() {
        return this.buffer.getValue();
    }

    public void cleanupBuffer() {
        this.buffer.trimHead();
    }

    public Object[] getValues() {
        Object[] a = EMPTY_ARRAY;
        Object[] b = this.getValues(a);
        if (b == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b;
    }

    public T[] getValues(T[] array) {
        return this.buffer.getValues(array);
    }

    public boolean hasValue() {
        return this.buffer.size() != 0;
    }

    int size() {
        return this.buffer.size();
    }

    boolean add(ReplayDisposable<T> rs) {
        ReplayDisposable[] b;
        ReplayDisposable<T>[] a;
        do {
            a = this.observers.get();
            int len = a.length;
            b = new ReplayDisposable[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = rs;
        } while (!this.observers.compareAndSet(a, b));
        return true;
    }

    void remove(ReplayDisposable<T> rs) {
        ReplayDisposable[] b;
        ReplayDisposable<T>[] a;
        do {
            if ((a = this.observers.get()) == EMPTY) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != rs) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                b = EMPTY;
                continue;
            }
            b = new ReplayDisposable[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
        } while (!this.observers.compareAndSet(a, b));
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    extends AtomicReference<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = -8056260896137901749L;
        final int maxSize;
        final long maxAge;
        final TimeUnit unit;
        final Scheduler scheduler;
        int size;
        volatile TimedNode<T> head;
        TimedNode<T> tail;

        SizeAndTimeBoundReplayBuffer(int maxSize, long maxAge, TimeUnit unit, Scheduler scheduler) {
            if (maxSize <= 0) {
                throw new IllegalArgumentException("maxSize > 0 required but it was " + maxSize);
            }
            if (maxAge <= 0L) {
                throw new IllegalArgumentException("maxAge > 0 required but it was " + maxAge);
            }
            if (unit == null) {
                throw new NullPointerException("unit == null");
            }
            if (scheduler == null) {
                throw new NullPointerException("scheduler == null");
            }
            this.maxSize = maxSize;
            this.maxAge = maxAge;
            this.unit = unit;
            this.scheduler = scheduler;
            TimedNode<Object> h2 = new TimedNode<Object>(null, 0L);
            this.tail = h2;
            this.head = h2;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                TimedNode<T> h2 = this.head;
                this.head = (TimedNode)h2.get();
            }
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h3 = this.head;
            while (true) {
                if (this.size <= 1) {
                    this.head = h3;
                    break;
                }
                TimedNode next = (TimedNode)h3.get();
                if (next == null) {
                    this.head = h3;
                    break;
                }
                if (next.time > limit) {
                    this.head = h3;
                    break;
                }
                h3 = next;
                --this.size;
            }
        }

        @Override
        public void add(T value) {
            TimedNode<T> n = new TimedNode<T>(value, this.scheduler.now(this.unit));
            TimedNode<T> t = this.tail;
            this.tail = n;
            ++this.size;
            t.set(n);
            this.trim();
        }

        @Override
        public void trimHead() {
            TimedNode<T> h2 = this.head;
            if (h2.value != null) {
                TimedNode<Object> n = new TimedNode<Object>(null, 0L);
                n.lazySet((TimedNode)h2.get());
                this.head = n;
            }
        }

        @Override
        @Nullable
        public T getValue() {
            TimedNode next;
            TimedNode h2 = this.head;
            while ((next = (TimedNode)h2.get()) != null) {
                h2 = next;
            }
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            if (h2.time < limit) {
                return null;
            }
            return h2.value;
        }

        TimedNode<T> getHead() {
            long ts;
            TimedNode index = this.head;
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode next = (TimedNode)index.get();
            while (next != null && (ts = next.time) <= limit) {
                index = next;
                next = (TimedNode)index.get();
            }
            return index;
        }

        @Override
        public T[] getValues(T[] array) {
            TimedNode h2 = this.getHead();
            int s2 = this.size(h2);
            if (s2 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s2) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
                }
                for (int i = 0; i != s2; ++i) {
                    TimedNode next = (TimedNode)h2.get();
                    array[i] = next.value;
                    h2 = next;
                }
                if (array.length > s2) {
                    array[s2] = null;
                }
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer a = rs.downstream;
            TimedNode index = (TimedNode)rs.index;
            if (index == null) {
                index = this.getHead();
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                while (true) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    TimedNode n = (TimedNode)index.get();
                    if (n == null) break;
                    Object o = n.value;
                    a.onNext(o);
                    index = n;
                }
                if (index.get() != null) continue;
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            return this.size(this.getHead());
        }

        int size(TimedNode<T> h2) {
            TimedNode next;
            int s2;
            for (s2 = 0; s2 != Integer.MAX_VALUE && (next = (TimedNode)h2.get()) != null; ++s2) {
                h2 = next;
            }
            return s2;
        }
    }

    static final class SizeBoundReplayBuffer<T>
    extends AtomicReference<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 1107649250281456395L;
        final int maxSize;
        int size;
        volatile Node<T> head;
        Node<T> tail;

        SizeBoundReplayBuffer(int maxSize) {
            if (maxSize <= 0) {
                throw new IllegalArgumentException("maxSize > 0 required but it was " + maxSize);
            }
            this.maxSize = maxSize;
            Node<Object> h2 = new Node<Object>(null);
            this.tail = h2;
            this.head = h2;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                Node<T> h2 = this.head;
                this.head = (Node)h2.get();
            }
        }

        @Override
        public void add(T value) {
            Node<T> n = new Node<T>(value);
            Node<T> t = this.tail;
            this.tail = n;
            ++this.size;
            t.set(n);
            this.trim();
        }

        @Override
        public void trimHead() {
            Node<T> h2 = this.head;
            if (h2.value != null) {
                Node<Object> n = new Node<Object>(null);
                n.lazySet((Node)h2.get());
                this.head = n;
            }
        }

        @Override
        @Nullable
        public T getValue() {
            Node next;
            Node h2 = this.head;
            while ((next = (Node)h2.get()) != null) {
                h2 = next;
            }
            return h2.value;
        }

        @Override
        public T[] getValues(T[] array) {
            Node h2 = this.head;
            int s2 = this.size();
            if (s2 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s2) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
                }
                for (int i = 0; i != s2; ++i) {
                    Node next = (Node)h2.get();
                    array[i] = next.value;
                    h2 = next;
                }
                if (array.length > s2) {
                    array[s2] = null;
                }
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer a = rs.downstream;
            Node index = (Node)rs.index;
            if (index == null) {
                index = this.head;
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                Node n = (Node)index.get();
                if (n != null) {
                    a.onNext(n.value);
                    index = n;
                    continue;
                }
                if (index.get() != null) continue;
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            Node next;
            int s2;
            Node h2 = this.head;
            for (s2 = 0; s2 != Integer.MAX_VALUE && (next = (Node)h2.get()) != null; ++s2) {
                h2 = next;
            }
            return s2;
        }
    }

    static final class TimedNode<T>
    extends AtomicReference<TimedNode<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;
        final long time;

        TimedNode(T value, long time) {
            this.value = value;
            this.time = time;
        }
    }

    static final class Node<T>
    extends AtomicReference<Node<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;

        Node(T value) {
            this.value = value;
        }
    }

    static final class UnboundedReplayBuffer<T>
    extends AtomicReference<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = -733876083048047795L;
        final List<T> buffer;
        volatile int size;

        UnboundedReplayBuffer(int capacityHint) {
            if (capacityHint <= 0) {
                throw new IllegalArgumentException("capacityHint > 0 required but it was " + capacityHint);
            }
            this.buffer = new ArrayList<T>(capacityHint);
        }

        @Override
        public void add(T value) {
            this.buffer.add(value);
            ++this.size;
        }

        @Override
        public void trimHead() {
        }

        @Override
        @Nullable
        public T getValue() {
            int s2 = this.size;
            if (s2 != 0) {
                return this.buffer.get(s2 - 1);
            }
            return null;
        }

        @Override
        public T[] getValues(T[] array) {
            int s2 = this.size;
            if (s2 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            if (array.length < s2) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
            }
            List<T> b = this.buffer;
            for (int i = 0; i < s2; ++i) {
                array[i] = b.get(i);
            }
            if (array.length > s2) {
                array[s2] = null;
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs) {
            int index;
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            List<T> b = this.buffer;
            Observer<T> a = rs.downstream;
            Integer indexObject = (Integer)rs.index;
            if (indexObject != null) {
                index = indexObject;
            } else {
                index = 0;
                rs.index = 0;
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                int s2 = this.size;
                while (s2 != index) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    T o = b.get(index);
                    a.onNext(o);
                    ++index;
                }
                if (index != this.size) continue;
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    static final class ReplayDisposable<T>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = 466549804534799122L;
        final Observer<? super T> downstream;
        final ReplayRelay<T> state;
        Object index;
        volatile boolean cancelled;

        ReplayDisposable(Observer<? super T> actual, ReplayRelay<T> state) {
            this.downstream = actual;
            this.state = state;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }
    }

    static interface ReplayBuffer<T> {
        public void add(T var1);

        public void replay(ReplayDisposable<T> var1);

        public int size();

        @Nullable
        public T getValue();

        public T[] getValues(T[] var1);

        public void trimHead();
    }
}

