/*
 * Decompiled with CFR 0.152.
 */
package com.zulrahhelper.ui;

import com.zulrahhelper.Phase;
import com.zulrahhelper.State;
import com.zulrahhelper.ZulrahHelperPlugin;
import com.zulrahhelper.ui.ZulrahHelperPhasePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ZulrahHelperPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(ZulrahHelperPanel.class);
    private final ZulrahHelperPlugin plugin;
    private final JPanel phasesView = new JPanel(new GridBagLayout());
    private static final ImageIcon RESET_ICON;
    private static final ImageIcon RESET_HOVER_ICON;
    private final JLabel title = new JLabel();
    private final JButton reset = new JButton(RESET_ICON);

    public ZulrahHelperPanel(ZulrahHelperPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(new EmptyBorder(1, 0, 10, 0));
        this.title.setText("Zulrah Helper");
        this.title.setForeground(Color.WHITE);
        northPanel.add((Component)this.title, "West");
        northPanel.add((Component)this.reset, "East");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.phasesView.setBackground(ColorScheme.DARK_GRAY_COLOR);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.reset.setToolTipText("Reset Zulrah rotation");
        this.reset.setRolloverIcon(RESET_HOVER_ICON);
        this.reset.addActionListener(l -> plugin.reset());
        centerPanel.add((Component)this.phasesView, "Center");
        this.add((Component)northPanel, "North");
        this.add((Component)centerPanel, "Center");
    }

    public void update(State state) {
        SwingUtilities.invokeLater(() -> this.updatePanel(state));
    }

    private void updatePanel(State state) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.phasesView.removeAll();
        JPanel ip = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 3;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        for (List<Phase> phases : state.buildTree()) {
            if (ip.getComponentCount() >= 2 || phases.size() >= 2) {
                this.phasesView.add((Component)ip, constraints);
                ++constraints.gridy;
                ip = new JPanel(new GridBagLayout());
                c = new GridBagConstraints();
                c.fill = 3;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 0;
            }
            if (phases.size() >= 2) {
                this.phasesView.add(Box.createRigidArea(new Dimension(0, 12)), constraints);
                ++constraints.gridy;
                this.phasesView.add((Component)new JLabel(String.format("Select Phase...", new Object[0])), constraints);
                ++constraints.gridy;
            }
            for (Phase p : phases) {
                ip.add((Component)new ZulrahHelperPhasePanel(this.plugin, p, phases.size()), c);
                ++c.gridx;
                if (!p.isCurrent()) continue;
                this.phasesView.add(Box.createRigidArea(new Dimension(0, 12)), constraints);
                ++constraints.gridy;
                this.phasesView.add((Component)new JLabel(String.format("Current Phase: %s #%d", new Object[]{p.getRotation(), p.getNumber()})), constraints);
                ++constraints.gridy;
            }
            this.phasesView.add((Component)ip, constraints);
            ++constraints.gridy;
        }
        this.repaint();
        this.revalidate();
    }

    static {
        BufferedImage addIcon = ImageUtil.getResourceStreamFromClass(ZulrahHelperPlugin.class, "/ui/reset_icon.png");
        RESET_ICON = new ImageIcon(addIcon);
        RESET_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addIcon, 0.53f));
    }
}

