/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableOperator;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;

public final class FlowableLift<R, T>
extends AbstractFlowableWithUpstream<T, R> {
    final FlowableOperator<? extends R, ? super T> operator;

    public FlowableLift(Flowable<T> source2, FlowableOperator<? extends R, ? super T> operator) {
        super(source2);
        this.operator = operator;
    }

    @Override
    public void subscribeActual(Subscriber<? super R> s2) {
        try {
            Subscriber<? super T> st = this.operator.apply(s2);
            if (st == null) {
                throw new NullPointerException("Operator " + this.operator + " returned a null Subscriber");
            }
            this.source.subscribe(st);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
            NullPointerException npe = new NullPointerException("Actually not, but can't throw other exceptions due to RS");
            npe.initCause(e);
            throw npe;
        }
    }
}

