/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableOnErrorNext<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier;

    public FlowableOnErrorNext(Flowable<T> source2, Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier) {
        super(source2);
        this.nextSupplier = nextSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        OnErrorNextSubscriber<? super T> parent = new OnErrorNextSubscriber<T>(s2, this.nextSupplier);
        s2.onSubscribe(parent);
        this.source.subscribe(parent);
    }

    static final class OnErrorNextSubscriber<T>
    extends SubscriptionArbiter
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = 4063763155303814625L;
        final Subscriber<? super T> downstream;
        final Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier;
        boolean once;
        boolean done;
        long produced;

        OnErrorNextSubscriber(Subscriber<? super T> actual, Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier) {
            super(false);
            this.downstream = actual;
            this.nextSupplier = nextSupplier;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            this.setSubscription(s2);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (!this.once) {
                ++this.produced;
            }
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            Publisher<T> p;
            if (this.once) {
                if (this.done) {
                    RxJavaPlugins.onError(t);
                    return;
                }
                this.downstream.onError(t);
                return;
            }
            this.once = true;
            try {
                p = Objects.requireNonNull(this.nextSupplier.apply(t), "The nextSupplier returned a null Publisher");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(new CompositeException(t, e));
                return;
            }
            long mainProduced = this.produced;
            if (mainProduced != 0L) {
                this.produced(mainProduced);
            }
            p.subscribe(this);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.once = true;
            this.downstream.onComplete();
        }
    }
}

