/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.experiencedrop;

import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Actor;
import net.runelite.api.Point;
import net.runelite.client.plugins.experiencedrop.XpDropConfig;
import net.runelite.client.plugins.experiencedrop.XpDropPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

@Singleton
class XpDropOverlay
extends Overlay {
    private final XpDropPlugin plugin;
    private final XpDropConfig config;

    @Inject
    private XpDropOverlay(XpDropPlugin plugin, XpDropConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.MED);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        Actor opponent;
        if (this.config.showdamagedrops() != XpDropConfig.DamageMode.ABOVE_OPPONENT) {
            return null;
        }
        if (this.plugin.getTickShow() > 0 && (opponent = this.plugin.getLastOpponent()) != null) {
            int offset = opponent.getLogicalHeight() + 50;
            String damageStr = String.valueOf(this.plugin.getDamage());
            Point textLocation = opponent.getCanvasTextLocation(graphics, damageStr, offset);
            if (textLocation != null && this.plugin.getDamage() != 0) {
                OverlayUtil.renderTextLocation(graphics, textLocation, damageStr, this.config.getDamageColor());
            }
        }
        return null;
    }
}

