/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlNode;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

public class XmlConfigurator
implements ProtocolStackConfigurator {
    private final List<ProtocolConfiguration> configuration = new ArrayList<ProtocolConfiguration>();
    protected static final Log log = LogFactory.getLog(XmlConfigurator.class);

    protected XmlConfigurator(List<ProtocolConfiguration> protocols) {
        this.configuration.addAll(protocols);
    }

    public static XmlConfigurator getInstance(InputStream stream) throws IOException {
        return XmlConfigurator.parse(stream);
    }

    public String getProtocolStackString(boolean convert) {
        StringBuilder buf = new StringBuilder();
        Iterator<ProtocolConfiguration> it = this.configuration.iterator();
        if (convert) {
            buf.append("<config>\n");
        }
        while (it.hasNext()) {
            ProtocolConfiguration d = it.next();
            if (convert) {
                buf.append("    <");
            }
            buf.append(d.getProtocolString(convert));
            if (convert) {
                buf.append("/>");
            }
            if (!it.hasNext()) continue;
            if (convert) {
                buf.append('\n');
                continue;
            }
            buf.append(':');
        }
        if (convert) {
            buf.append("\n</config>");
        }
        return buf.toString();
    }

    @Override
    public String getProtocolStackString() {
        return this.getProtocolStackString(false);
    }

    @Override
    public List<ProtocolConfiguration> getProtocolStack() {
        return this.configuration;
    }

    protected static XmlConfigurator parse(InputStream stream) throws IOException {
        try {
            XmlNode root = XmlConfigurator.parseXmlDocument(stream);
            return XmlConfigurator.parse(root);
        }
        catch (Exception x) {
            throw new IOException(String.format(Util.getMessage("ParseError"), x.getLocalizedMessage()));
        }
    }

    private static InputStream getAsInputStreamFromClassLoader(String filename) {
        InputStream is;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream inputStream2 = is = cl == null ? null : cl.getResourceAsStream(filename);
        if (is == null) {
            is = XmlConfigurator.class.getClassLoader().getResourceAsStream(filename);
        }
        return is;
    }

    protected static XmlConfigurator parse(XmlNode root) throws Exception {
        return new XmlConfigurator(XmlConfigurator.parseProtocols(root));
    }

    public static List<ProtocolConfiguration> parseProtocols(XmlNode root) throws Exception {
        String root_name = root.getName().trim().toLowerCase();
        if (!"config".equals(root_name)) {
            throw new IOException("the configuration does not start with a <config> element: " + root_name);
        }
        ArrayList<ProtocolConfiguration> prot_data = new ArrayList<ProtocolConfiguration>();
        for (XmlNode node : root.getChildren()) {
            String protocol = node.getName();
            Map<String, String> attrs = node.getAttributes();
            ProtocolConfiguration cfg = new ProtocolConfiguration(protocol, attrs);
            prot_data.add(cfg);
            List<XmlNode> subnodes = node.getChildren();
            if (subnodes == null) continue;
            for (XmlNode subnode : subnodes) {
                cfg.addSubtree(subnode);
            }
        }
        return prot_data;
    }

    public static XmlNode parseXmlDocument(InputStream in) throws IOException {
        String s2;
        ArrayDeque<XmlNode> stack = new ArrayDeque<XmlNode>();
        XmlNode current = null;
        while ((s2 = XmlConfigurator.readNode(in)) != null) {
            Tuple<String, String> tuple;
            ElementType type = XmlConfigurator.getType(s2 = XmlConfigurator.sanitize(s2));
            if (type == ElementType.COMMENT) continue;
            s2 = s2.replace("<", "").replace("/>", "").replace(">", "").trim();
            ByteArrayInputStream input = new ByteArrayInputStream(s2.getBytes());
            String name = Util.readToken(input);
            XmlNode n = new XmlNode(name);
            while ((tuple = XmlConfigurator.readAttribute(input)) != null) {
                n.addAttribute(tuple.getVal1(), tuple.getVal2());
            }
            current = (XmlNode)stack.peekFirst();
            switch (type) {
                case COMPLETE: {
                    current.addChild(n);
                    break;
                }
                case START: {
                    if (current != null) {
                        current.addChild(n);
                    }
                    stack.push(n);
                    break;
                }
                case END: {
                    stack.pop();
                }
            }
        }
        return current;
    }

    protected static String readNode(InputStream in) throws IOException {
        String tmp = Util.readTillMatchingCharacter(in, '<');
        if (tmp == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<");
        tmp = Util.readTillMatchingCharacter(in, '>');
        if (tmp == null) {
            return null;
        }
        sb.append(tmp);
        return sb.toString();
    }

    protected static String sanitize(String s2) {
        return s2.replaceAll("/\\s*>", "/>");
    }

    protected static Tuple<String, String> readAttribute(InputStream in) throws IOException {
        String attr_name = Util.readTillMatchingCharacter(in, '=');
        if (attr_name == null) {
            return null;
        }
        attr_name = attr_name.replace("=", "").trim();
        String val = XmlConfigurator.readQuotedString(in);
        if (val == null) {
            return null;
        }
        return new Tuple<String, String>(attr_name, val);
    }

    protected static String readQuotedString(InputStream in) throws IOException {
        int ch;
        String s2 = Util.readTillMatchingCharacter(in, '\"');
        if (s2 == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        while ((ch = in.read()) != -1) {
            if (ch == 92) {
                escaped = true;
                continue;
            }
            if (escaped) {
                escaped = false;
            } else if (ch == 34) break;
            sb.append((char)ch);
        }
        return sb.toString();
    }

    protected static ElementType getType(String s2) {
        if ((s2 = s2.trim()).startsWith("<!--")) {
            return ElementType.COMMENT;
        }
        if (s2.startsWith("</")) {
            return ElementType.END;
        }
        if (s2.endsWith("/>")) {
            return ElementType.COMPLETE;
        }
        if (s2.endsWith(">")) {
            return ElementType.START;
        }
        return ElementType.UNDEFINED;
    }

    protected static boolean isClosed(String s2) {
        return (s2 = s2.trim()).startsWith("</") || s2.endsWith("/>");
    }

    protected static boolean isComment(String s2) {
        return s2.trim().startsWith("<!--");
    }

    public static void main(String[] args2) throws Exception {
        InputStream input;
        String input_file = null;
        for (int i = 0; i < args2.length; ++i) {
            if (!args2[i].equals("-file")) {
                XmlConfigurator.help();
                return;
            }
            input_file = args2[++i];
        }
        if (input_file != null) {
            input = null;
            try {
                input = new FileInputStream(input_file);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (input == null) {
                input = Thread.currentThread().getContextClassLoader().getResourceAsStream(input_file);
            }
        } else {
            throw new Exception("no input file given");
        }
        XmlConfigurator conf = XmlConfigurator.getInstance(input);
        String tmp = conf.getProtocolStackString();
        System.out.println("\n" + tmp);
    }

    private static String dump(Collection<ProtocolConfiguration> configs) {
        StringBuilder sb = new StringBuilder();
        String indent = "  ";
        sb.append("<config>\n");
        for (ProtocolConfiguration cfg : configs) {
            sb.append(indent).append("<").append(cfg.getProtocolName());
            Map<String, String> props = cfg.getProperties();
            if (!props.isEmpty()) {
                sb.append("\n").append(indent).append(indent);
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    String key = entry.getKey();
                    String val = entry.getValue();
                    key = XmlConfigurator.trim(key);
                    val = XmlConfigurator.trim(val);
                    sb.append(key).append("=\"").append(val).append("\" ");
                }
            }
            sb.append(" />\n");
        }
        sb.append("</config>\n");
        return sb.toString();
    }

    private static String trim(String val) {
        StringBuilder retval = new StringBuilder();
        val = val.trim();
        while (true) {
            int index;
            if ((index = val.indexOf(10)) == -1) break;
            retval.append(val, 0, index);
            val = val.substring(index + 1);
        }
        retval.append(val);
        return retval.toString();
    }

    private static String inputAsString(InputStream input) throws IOException {
        int len = input.available();
        byte[] buf = new byte[len];
        input.read(buf, 0, len);
        return new String(buf);
    }

    public static String replace(String input, String expr, String replacement) {
        StringBuilder sb = new StringBuilder();
        int new_index = 0;
        int index = 0;
        int len = expr.length();
        int input_len = input.length();
        while (true) {
            if ((new_index = input.indexOf(expr, index)) == -1) break;
            sb.append(input, index, new_index);
            sb.append(replacement);
            index = new_index + len;
        }
        sb.append(input, index, input_len);
        return sb.toString();
    }

    static void help() {
        System.out.println("XmlConfigurator -file <input XML file>");
    }

    protected static enum ElementType {
        START,
        COMPLETE,
        END,
        COMMENT,
        UNDEFINED;

    }
}

