/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.model;

import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Model;
import rs117.hd.scene.model_overrides.ModelOverride;

@Singleton
public class ModelHasher {
    private Model model;
    private int faceColorsOneHash;
    private int faceColorsTwoHash;
    private int faceColorsThreeHash;
    private int faceTransparenciesHash;
    private int faceTexturesHash;
    private int faceTexturesUvHash;
    private int xVerticesHash;
    private int yVerticesHash;
    private int zVerticesHash;
    private int faceIndicesOneHash;
    private int faceIndicesTwoHash;
    private int faceIndicesThreeHash;

    public void setModel(Model model) {
        this.model = model;
        this.faceColorsOneHash = ModelHasher.fastIntHash(model.getFaceColors1(), -1);
        this.faceColorsTwoHash = ModelHasher.fastIntHash(model.getFaceColors2(), -1);
        this.faceColorsThreeHash = ModelHasher.fastIntHash(model.getFaceColors3(), -1);
        this.faceTransparenciesHash = ModelHasher.fastByteHash(model.getFaceTransparencies());
        this.faceTexturesHash = ModelHasher.fastShortHash(model.getFaceTextures());
        this.faceTexturesUvHash = ModelHasher.fastFloatHash(model.getFaceTextureUVCoordinates());
        this.xVerticesHash = ModelHasher.fastIntHash(model.getVerticesX(), model.getVerticesCount());
        this.yVerticesHash = ModelHasher.fastIntHash(model.getVerticesY(), model.getVerticesCount());
        this.zVerticesHash = ModelHasher.fastIntHash(model.getVerticesZ(), model.getVerticesCount());
        this.faceIndicesOneHash = ModelHasher.fastIntHash(model.getFaceIndices1(), -1);
        this.faceIndicesTwoHash = ModelHasher.fastIntHash(model.getFaceIndices2(), -1);
        this.faceIndicesThreeHash = ModelHasher.fastIntHash(model.getFaceIndices3(), -1);
    }

    public int calculateVertexCacheHash() {
        return ModelHasher.fastIntHash(new int[]{this.faceColorsOneHash, this.faceColorsTwoHash, this.faceColorsThreeHash, this.faceTransparenciesHash, this.faceTexturesHash, this.faceTexturesUvHash, this.model.getOverrideAmount(), this.model.getOverrideHue(), this.model.getOverrideSaturation(), this.model.getOverrideLuminance(), this.faceIndicesOneHash, this.faceIndicesTwoHash, this.faceIndicesThreeHash, this.xVerticesHash, this.yVerticesHash, this.zVerticesHash}, -1);
    }

    public int calculateNormalCacheHash() {
        return ModelHasher.fastIntHash(new int[]{this.faceIndicesOneHash, this.faceIndicesTwoHash, this.faceIndicesThreeHash, ModelHasher.fastIntHash(this.model.getVertexNormalsX(), -1), ModelHasher.fastIntHash(this.model.getVertexNormalsY(), -1), ModelHasher.fastIntHash(this.model.getVertexNormalsZ(), -1)}, -1);
    }

    public int calculateUvCacheHash(@NonNull ModelOverride modelOverride) {
        if (modelOverride == null) {
            throw new NullPointerException("modelOverride is marked non-null but is null");
        }
        return ModelHasher.fastIntHash(new int[]{this.faceTexturesHash, this.faceTexturesUvHash, modelOverride.hashCode()}, -1);
    }

    public int calculateColorCacheHash() {
        return ModelHasher.fastIntHash(new int[]{this.faceColorsOneHash, this.faceColorsTwoHash, this.faceColorsThreeHash, this.faceTransparenciesHash, this.faceTexturesHash, this.faceTexturesUvHash, this.model.getOverrideAmount(), this.model.getOverrideHue(), this.model.getOverrideSaturation(), this.model.getOverrideLuminance()}, -1);
    }

    public int calculateBatchHash() {
        return this.calculateVertexCacheHash();
    }

    public static int fastIntHash(int[] a, int actualLength) {
        if (a == null) {
            return 0;
        }
        int i = 0;
        int r = 1;
        int length = a.length;
        if (actualLength != -1) {
            length = actualLength;
        }
        while (i + 5 < length) {
            r = 887503681 * r + 28629151 * a[i] + 923521 * a[i + 1] + 29791 * a[i + 2] + 961 * a[i + 3] + 31 * a[i + 4] + a[i + 5];
            i += 6;
        }
        while (i < length) {
            r = 31 * r + a[i];
            ++i;
        }
        return r;
    }

    public static int fastByteHash(byte[] a) {
        if (a == null) {
            return 0;
        }
        int i = 0;
        int r = 1;
        while (i + 5 < a.length) {
            r = 887503681 * r + 28629151 * a[i] + 923521 * a[i + 1] + 29791 * a[i + 2] + 961 * a[i + 3] + 31 * a[i + 4] + a[i + 5];
            i += 6;
        }
        while (i < a.length) {
            r = 31 * r + a[i];
            ++i;
        }
        return r;
    }

    public static int fastShortHash(short[] a) {
        if (a == null) {
            return 0;
        }
        int i = 0;
        int r = 1;
        while (i + 5 < a.length) {
            r = 887503681 * r + 28629151 * a[i] + 923521 * a[i + 1] + 29791 * a[i + 2] + 961 * a[i + 3] + 31 * a[i + 4] + a[i + 5];
            i += 6;
        }
        while (i < a.length) {
            r = 31 * r + a[i];
            ++i;
        }
        return r;
    }

    public static int fastFloatHash(float[] a) {
        if (a == null) {
            return 0;
        }
        int i = 0;
        int r = 1;
        while (i + 5 < a.length) {
            r = 887503681 * r + 28629151 * Float.floatToIntBits(a[i]) + 923521 * Float.floatToIntBits(a[i + 1]) + 29791 * Float.floatToIntBits(a[i + 2]) + 961 * Float.floatToIntBits(a[i + 3]) + 31 * Float.floatToIntBits(a[i + 4]) + Float.floatToIntBits(a[i + 5]);
            i += 6;
        }
        while (i < a.length) {
            r = 31 * r + Float.floatToIntBits(a[i]);
            ++i;
        }
        return r;
    }
}

