/*
 * Decompiled with CFR 0.152.
 */
package org.launch.download;

import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.launch.Settings;
import org.launch.download.DownloadType;
import org.launch.download.os.OperatingSystem;
import org.launch.frame.Frame;

public class DownloadManager {
    @Inject
    private Settings settings;
    @Inject
    private Frame frame;
    public static boolean NEEDS_REDOWNLOAD = false;
    private static int numberOfUpdates = 0;
    private static int currentlyUpdated = 0;

    public void init() throws IOException {
        System.out.println("DownloadManager#init for OS " + (Object)((Object)this.settings.getOperatingSystem()));
        this.loadAllData();
        for (DownloadType cacheDownloadType : DownloadType.values()) {
            if (cacheDownloadType.getOperatingSystem() != this.settings.getOperatingSystem() && cacheDownloadType.getOperatingSystem() != OperatingSystem.ANY) continue;
            System.out.println("Name: " + cacheDownloadType.getFileName());
            this.download(cacheDownloadType);
        }
        this.frame.setTask("Verifying files..");
        for (DownloadType cacheDownloadType : DownloadType.values()) {
            if (cacheDownloadType.getOperatingSystem() != this.settings.getOperatingSystem() && cacheDownloadType.getOperatingSystem() != OperatingSystem.ANY) continue;
            System.out.println("Name: " + cacheDownloadType.getFileName());
            this.download(cacheDownloadType);
        }
    }

    public void loadAllData() throws MalformedURLException {
        this.loadSizes();
        for (DownloadType cacheDownloadType : DownloadType.values()) {
            cacheDownloadType.remoteSize = this.getFileSize(new URL(cacheDownloadType.getUrl()));
            cacheDownloadType.remoteLastModified = this.getLastModified(new URL(cacheDownloadType.getUrl()));
            if (!this.needsUpdate(cacheDownloadType)) continue;
            ++numberOfUpdates;
        }
    }

    public void download(DownloadType type) {
        if (!this.needsUpdate(type)) {
            return;
        }
        try {
            this.download(type.getFileName(), type.getUrl());
            type.personalSize = type.remoteSize;
            type.personalLastModified = type.remoteLastModified;
            NEEDS_REDOWNLOAD = false;
            this.saveSizes();
            ++currentlyUpdated;
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public boolean needsUpdate(DownloadType type) {
        if (NEEDS_REDOWNLOAD) {
            return true;
        }
        if (!new File(this.settings.getGameDirectory() + type.getFileName()).exists() && !type.getFileName().contains("zip")) {
            return true;
        }
        return type.remoteSize != type.personalSize || type.remoteLastModified != type.personalLastModified;
    }

    public double calculatePercentage(double currentlyDownloaded, double totalUpdates) {
        return currentlyDownloaded * 100.0 / totalUpdates;
    }

    public void download(String fileName, String downloadUrl) throws IOException {
        URL url = new URL(downloadUrl);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.addRequestProperty("User-Agent", "Mozilla/4.76");
        int responseCode = httpConn.getResponseCode();
        if (responseCode == 200) {
            InputStream inputStream = httpConn.getInputStream();
            String saveFilePath = this.settings.getGameDirectory() + File.separator + fileName;
            FileOutputStream outputStream = new FileOutputStream(saveFilePath);
            int bytesRead = -1;
            byte[] buffer = new byte[4096];
            long startTime = System.currentTimeMillis();
            int downloaded = 0;
            long numWritten = 0L;
            int length = httpConn.getContentLength();
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                int percentage = (int)((double)(numWritten += (long)bytesRead) / (double)length * 100.0);
                int downloadSpeed = (int)((long)((downloaded += bytesRead) / 1024) / (1L + (System.currentTimeMillis() - startTime) / 1000L));
                this.frame.getProgressBar().setValue(percentage);
                this.frame.setTask("Downloading " + DownloadType.getTypeFromFileName(fileName.toLowerCase()).getFileDescription() + " (" + downloadSpeed + "kb/s): " + percentage + "%");
            }
            outputStream.close();
            inputStream.close();
        } else {
            System.out.println(downloadUrl + " returned code + " + responseCode);
        }
        httpConn.disconnect();
        if (fileName.contains("zip")) {
            this.unZip(fileName);
        }
    }

    public void unZip(String fileName) {
        String osFolder;
        File zipFile = new File(this.settings.getGameDirectory(), fileName);
        switch (this.settings.getOperatingSystem()) {
            case WINDOWS: {
                osFolder = "windows";
                break;
            }
            case MAC: {
                osFolder = "mac";
                break;
            }
            case LINUX: {
                osFolder = "linux";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported OS: " + (Object)((Object)this.settings.getOperatingSystem()));
            }
        }
        File destDir = new File(this.settings.getGameDirectory(), osFolder);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File newFile = new File(destDir, entry.getName());
                if (entry.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    newFile.getParentFile().mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                }
                zis.closeEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void unzip(ZipInputStream zin, String s2) throws IOException {
        FileOutputStream out = new FileOutputStream(s2);
        byte[] b = new byte[1024];
        int len = 0;
        while ((len = zin.read(b)) != -1) {
            out.write(b, 0, len);
        }
        out.close();
    }

    public long getFileSize(URL url) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            long l = conn.getContentLengthLong();
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public long getLastModified(URL url) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            long l = conn.getLastModified();
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public void saveSizes() {
        try {
            PrintWriter writer = new PrintWriter(this.settings.getGameDirectory() + "versions", "UTF-8");
            for (DownloadType cacheDownloadType : DownloadType.values()) {
                writer.println(cacheDownloadType.toString() + ":" + cacheDownloadType.personalSize + ":size");
                writer.println(cacheDownloadType.toString() + ":" + cacheDownloadType.personalLastModified + ":modified");
            }
            writer.println(DownloadType.MAIN_FILE.toString() + ":redownload:" + NEEDS_REDOWNLOAD + "");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadSizes() {
        File file = new File(this.settings.getGameDirectory() + "versions");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            return;
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] args = line.split(":");
                if (args.length <= 1) continue;
                String token = args[0];
                String value = args[1];
                String type = args[2];
                if (token.contains("USER_OPTION")) continue;
                DownloadType cacheType = DownloadType.valueOf(token);
                switch (type) {
                    case "size": {
                        long size;
                        cacheType.personalSize = size = Long.parseLong(value);
                        break;
                    }
                    case "modified": {
                        long modified;
                        cacheType.personalLastModified = modified = Long.parseLong(value);
                        break;
                    }
                    case "redownload": {
                        NEEDS_REDOWNLOAD = Boolean.parseBoolean(value);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

