/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa;

import com.duckblade.osrs.toa.features.QuickProceedSwaps;
import com.duckblade.osrs.toa.features.het.pickaxe.DepositPickaxeMode;
import com.duckblade.osrs.toa.features.hporbs.HpOrbMode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.config.ConfigManager;

@Singleton
public class ConfigMigrationService {
    @Inject
    private ConfigManager configManager;

    void migrate() {
        this.migrateQuickProceedEnable();
        this.migrateHideHpOrbs();
        this.migratePickaxeReminder();
    }

    @VisibleForTesting
    void migrateQuickProceedEnable() {
        this.migrate("leftClickProceedEnable", "quickProceedEnableMode", Boolean.class, enabled -> enabled != false ? QuickProceedSwaps.QuickProceedEnableMode.ALL : QuickProceedSwaps.QuickProceedEnableMode.NONE);
    }

    @VisibleForTesting
    void migrateHideHpOrbs() {
        this.migrate("hideHpOrbs", "hpOrbsMode", Boolean.class, enabled -> enabled != false ? HpOrbMode.HIDDEN : HpOrbMode.ORBS);
    }

    @VisibleForTesting
    void migratePickaxeReminder() {
        this.migrateMany("depositPickaxeMode", DepositPickaxeMode.class, mode -> ImmutableMap.of("hetPickaxeMenuSwap", mode.isSwapStatue(), "hetPickaxePreventExit", mode.isSwapExit()));
    }

    private <Source, Dest> void migrate(String oldKey, String newKey, Class<Source> sourceType, Function<Source, Dest> migration) {
        this.migrateMany(oldKey, sourceType, s2 -> Collections.singletonMap(newKey, migration.apply(s2)));
    }

    private <Source> void migrateMany(String oldKey, Class<Source> sourceType, Function<Source, Map<String, Object>> migration) {
        Object previousEntry = this.configManager.getConfiguration("tombsofamascut", oldKey, sourceType);
        if (previousEntry != null) {
            this.configManager.unsetConfiguration("tombsofamascut", oldKey);
            Map<String, Object> newEntries = migration.apply(previousEntry);
            newEntries.forEach((k, v) -> this.configManager.setConfiguration("tombsofamascut", (String)k, v));
        }
    }
}

