/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.apmeken;

import com.duckblade.osrs.toa.features.apmeken.Baboon;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;

@Singleton
public class ApmekenWavePanel
extends PluginPanel {
    private static final List<Map<Baboon, Integer>> WAVES = ImmutableList.of(ImmutableMap.of(Baboon.BRAWLER, 2), ImmutableMap.of(Baboon.THROWER, 1, Baboon.MAGE, 1), ImmutableMap.of(Baboon.SHAMAN, 1, Baboon.BRAWLER, 2), ImmutableMap.of(Baboon.THROWER, 2, Baboon.VOLATILE, 1), ImmutableMap.of(Baboon.MAGE, 2, Baboon.CURSED, 1), ImmutableMap.of(Baboon.THROWER, 2, Baboon.SHAMAN, 1, Baboon.VOLATILE, 1, Baboon.CURSED, 1), ImmutableMap.of(Baboon.MAGE, 1, Baboon.SHAMAN, 2, Baboon.VOLATILE, 1), ImmutableMap.of(Baboon.BRAWLER, 2, Baboon.SHAMAN, 2, Baboon.CURSED, 1), ImmutableMap.of(Baboon.BRAWLER, 1, Baboon.THROWER, 1, Baboon.SHAMAN, 1, Baboon.CURSED, 2), ImmutableMap.of(Baboon.SHAMAN, 2, Baboon.VOLATILE, 3));

    public ApmekenWavePanel() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.5f);
        JLabel headerLabel = new JLabel("Apmeken Waves");
        headerLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        headerLabel.setHorizontalAlignment(0);
        headerLabel.setAlignmentX(0.5f);
        headerLabel.setFont(FontManager.getRunescapeFont().deriveFont(24.0f));
        this.add(headerLabel);
        int waveNum = 1;
        for (Map<Baboon, Integer> wave : WAVES) {
            JPanel rowPanel = new JPanel();
            rowPanel.setLayout(new BoxLayout(rowPanel, 1));
            rowPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            rowPanel.setAlignmentX(0.5f);
            this.add(rowPanel);
            rowPanel.add(new JLabel("Wave " + waveNum++));
            wave.forEach((baboon, count) -> {
                JLabel spawnLabel = new JLabel(count + "x " + baboon.getDisplayName());
                spawnLabel.setHorizontalAlignment(2);
                spawnLabel.setFont(FontManager.getRunescapeFont());
                spawnLabel.setForeground(baboon.getColor());
                rowPanel.add(spawnLabel);
            });
        }
    }
}

