/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.het.solver;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.het.solver.HetSolution;
import com.duckblade.osrs.toa.features.het.solver.HetSolutionResult;
import com.duckblade.osrs.toa.features.het.solver.HetTileState;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import java.util.Arrays;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Point;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HetSolver
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(HetSolver.class);
    private static final int STATUE_SHIELDED = 45485;
    private final EventBus eventBus;
    private final ClientThread clientThread;
    private final HetTileState[][] roomStates = new HetTileState[21][21];
    private final GameObject[][] roomObjects = new GameObject[21][21];
    private Point puzzleBase = null;
    private HetSolutionResult result;
    private HetSolution solution;
    private boolean solveQueued = false;
    private boolean puzzleChurned = false;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return config.hetSolverEnable() && raidState.getCurrentRoom() == RaidRoom.HET;
    }

    @Override
    public void startUp() {
        this.clearSolve();
        this.puzzleBase = null;
        this.eventBus.register(this);
    }

    @Override
    public void shutDown() {
        this.clearSolve();
        this.eventBus.unregister(this);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged e) {
        if (e.getGameState() != GameState.LOGGED_IN) {
            this.clearSolve();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (e.getMessage().startsWith("Your party failed to complete the challenge")) {
            this.clearSolve();
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        this.onGameObjectSpawned(e, true);
    }

    private void onGameObjectSpawned(GameObjectSpawned e, boolean canLoop) {
        HetTileState hts;
        Point p = e.getGameObject().getSceneMinLocation();
        if (e.getGameObject().getId() == 45485) {
            this.puzzleBase = new Point(p.getX() - 12, p.getY() - 9);
            log.debug("Found puzzle base at {}", (Object)this.puzzleBase);
            return;
        }
        if (!HetTileState.OBJECT_ID_TO_STATE.containsKey(e.getGameObject().getId())) {
            return;
        }
        if (this.puzzleBase == null) {
            if (canLoop) {
                this.clientThread.invokeLater(() -> this.onGameObjectSpawned(e, false));
            }
            return;
        }
        if ((p = this.normalize(p)).getX() < 0 || p.getY() < 0 || p.getX() >= this.roomStates.length || p.getY() >= this.roomStates[0].length) {
            return;
        }
        this.roomStates[p.getX()][p.getY()] = hts = HetTileState.fromGameObject(e.getGameObject(), this.puzzleBase);
        this.roomObjects[p.getX()][p.getY()] = e.getGameObject();
        if (hts.stateResetsSolution()) {
            this.puzzleChurned = true;
        }
        if (!this.solveQueued) {
            this.solveQueued = true;
            this.clientThread.invokeLater(this::solve);
        }
    }

    private void solve() {
        this.solveQueued = false;
        if (this.puzzleChurned) {
            this.puzzleChurned = false;
            this.result = null;
            this.solution = null;
        }
        HetSolutionResult minResult = this.result != null ? this.result : new HetSolutionResult(false, 0, 0, 0, Collections.emptyList());
        HetSolution minSolution = this.solution != null ? this.solution : null;
        for (HetSolution solution : HetSolution.values()) {
            HetSolutionResult score = solution.getScore(this.roomStates);
            if (score.compareTo(minResult) >= 0) continue;
            minResult = score;
            minSolution = solution;
        }
        if (!minResult.isCompletable()) {
            log.debug("All solutions were eliminated");
            this.clearSolve();
            return;
        }
        this.result = minResult;
        this.solution = minSolution;
    }

    private void clearSolve() {
        this.solveQueued = false;
        this.result = null;
        this.solution = null;
        for (Object[] objectArray : this.roomStates) {
            Arrays.fill(objectArray, null);
        }
        for (Object[] objectArray : this.roomObjects) {
            Arrays.fill(objectArray, null);
        }
    }

    private Point normalize(Point p) {
        return new Point(p.getX() - this.puzzleBase.getX(), p.getY() - this.puzzleBase.getY());
    }

    @Inject
    public HetSolver(EventBus eventBus, ClientThread clientThread) {
        this.eventBus = eventBus;
        this.clientThread = clientThread;
    }

    public HetTileState[][] getRoomStates() {
        return this.roomStates;
    }

    public GameObject[][] getRoomObjects() {
        return this.roomObjects;
    }

    public Point getPuzzleBase() {
        return this.puzzleBase;
    }

    public HetSolutionResult getResult() {
        return this.result;
    }

    public HetSolution getSolution() {
        return this.solution;
    }
}

