/*
 * Decompiled with CFR 0.152.
 */
package com.radiusmarkers;

import com.google.inject.Inject;
import com.radiusmarkers.AttackType;
import com.radiusmarkers.ColourRadiusMarker;
import com.radiusmarkers.RadiusMarkerConfig;
import com.radiusmarkers.RadiusMarkerPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

class RadiusMarkerSceneOverlay
extends Overlay {
    private static final int MAX_DRAW_DISTANCE = 32;
    private static final int LOCAL_TILE_SIZE = 128;
    private final Client client;
    private final RadiusMarkerConfig config;
    private final RadiusMarkerPlugin plugin;
    private int x;
    private int y;

    @Inject
    private RadiusMarkerSceneOverlay(Client client, RadiusMarkerConfig config, RadiusMarkerPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        List<ColourRadiusMarker> markers = this.plugin.getMarkers();
        List<NPC> npcs = this.client.getNpcs();
        if (markers.isEmpty()) {
            return null;
        }
        BasicStroke stroke = new BasicStroke(this.config.borderWidth());
        for (ColourRadiusMarker marker : markers) {
            if (!marker.isVisible()) continue;
            boolean excludeCorner = AttackType.MELEE.equals((Object)marker.getAttackType());
            Collection<WorldPoint> worldPoints = this.plugin.getInstanceWorldPoints(marker.getWorldPoint());
            for (WorldPoint worldPoint : worldPoints) {
                if (worldPoint.getPlane() != this.client.getPlane()) continue;
                if (this.config.includeRetreatInteractionRange() && marker.isRetreatInteractionVisible()) {
                    this.drawBox(graphics, worldPoint, marker.getRetreatInteractionRadius(), marker.getRetreatInteractionColour(), stroke, 1, false);
                }
                if (this.config.includeAggressionRange() && marker.isAggressionVisible()) {
                    this.drawBox(graphics, worldPoint, marker.getAggressionRadius(), marker.getAggressionColour(), stroke, this.client.getNpcDefinition(marker.getNpcId()).getSize(), excludeCorner);
                }
                if (this.config.includeMaxRange() && marker.isMaxVisible()) {
                    this.drawBox(graphics, worldPoint, marker.getMaxRadius(), marker.getMaxColour(), stroke, 1, false);
                }
                if (this.config.includeWanderRange() && marker.isWanderVisible()) {
                    this.drawBox(graphics, worldPoint, marker.getWanderRadius(), marker.getWanderColour(), stroke, 1, false);
                }
                if (!marker.isSpawnVisible()) continue;
                this.drawBox(graphics, worldPoint, 0, marker.getSpawnColour(), stroke, 1, false);
            }
            for (NPC npc : npcs) {
                if (npc.getId() != marker.getNpcId() || this.plugin.exclude(npc)) continue;
                WorldPoint npcLocation = npc.getWorldLocation();
                int size = npc.getComposition().getSize();
                if (this.config.includeInteractionRange() && marker.isInteractionVisible()) {
                    this.drawBox(graphics, npcLocation, marker.getInteractionRadius(), marker.getInteractionColour(), stroke, size, false);
                }
                if (this.config.includeHuntRange() && marker.isHuntVisible()) {
                    this.drawBox(graphics, npcLocation, marker.getHuntRadius(), marker.getHuntColour(), stroke, 1, false);
                }
                if (!this.config.includeAttackRange() || !marker.isAttackVisible()) continue;
                this.drawBox(graphics, npcLocation, marker.getAttackRadius(), marker.getAttackColour(), stroke, size, excludeCorner);
            }
        }
        return null;
    }

    private void drawBox(Graphics2D graphics, WorldPoint worldPoint, int radius, Color borderColour, Stroke borderStroke, int size, boolean excludeCorner) {
        graphics.setStroke(borderStroke);
        graphics.setColor(borderColour);
        graphics.draw(this.getSquare(worldPoint, radius, size, excludeCorner));
    }

    private GeneralPath getSquare(WorldPoint worldPoint, int radius, int size, boolean excludeCorner) {
        GeneralPath path = new GeneralPath();
        if (this.client.getLocalPlayer() == null) {
            return path;
        }
        int startX = worldPoint.getX() - radius;
        int startY = worldPoint.getY() - radius;
        int z = worldPoint.getPlane();
        int diameter = 2 * radius + size;
        excludeCorner = excludeCorner && radius > 0;
        this.x = startX;
        this.y = startY;
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        int[] xs = new int[4 * diameter + 1];
        int[] ys = new int[xs.length];
        for (int i = 0; i < xs.length; ++i) {
            if (i < diameter) {
                xs[0 * diameter + i] = startX + i;
                xs[1 * diameter + i] = startX + diameter;
                xs[2 * diameter + i] = startX + diameter - i;
                xs[3 * diameter + i] = startX;
                ys[0 * diameter + i] = startY;
                ys[1 * diameter + i] = startY + i;
                ys[2 * diameter + i] = startY + diameter;
                ys[3 * diameter + i] = startY + diameter - i;
            } else if (i == diameter) {
                xs[xs.length - 1] = xs[0];
                ys[ys.length - 1] = ys[0];
            }
            if (excludeCorner && i == 0) {
                int n = 0 * diameter + i;
                xs[n] = xs[n] + 1;
                int n2 = 1 * diameter + i;
                xs[n2] = xs[n2] - 1;
                int n3 = 2 * diameter + i;
                xs[n3] = xs[n3] - 1;
                int n4 = 3 * diameter + i;
                xs[n4] = xs[n4] + 1;
                int n5 = 0 * diameter + i;
                ys[n5] = ys[n5] + 1;
                int n6 = 1 * diameter + i;
                ys[n6] = ys[n6] + 1;
                int n7 = 2 * diameter + i;
                ys[n7] = ys[n7] - 1;
                int n8 = 3 * diameter + i;
                ys[n8] = ys[n8] - 1;
                this.x = xs[i];
                this.y = ys[i];
            }
            boolean hasFirst = false;
            if (playerLocation.distanceTo(new WorldPoint(this.x, this.y, z)) < 32) {
                hasFirst = this.moveTo(path, this.x, this.y, z);
            }
            this.x = xs[i];
            this.y = ys[i];
            if (!hasFirst || playerLocation.distanceTo(new WorldPoint(this.x, this.y, z)) >= 32) continue;
            this.lineTo(path, this.x, this.y, z);
        }
        return path;
    }

    private boolean moveTo(GeneralPath path, int x, int y, int z) {
        Point point = this.XYToPoint(x, y, z);
        if (point != null) {
            path.moveTo(point.getX(), point.getY());
            return true;
        }
        return false;
    }

    private void lineTo(GeneralPath path, int x, int y, int z) {
        Point point = this.XYToPoint(x, y, z);
        if (point != null) {
            path.lineTo(point.getX(), point.getY());
        }
    }

    private Point XYToPoint(int x, int y, int z) {
        LocalPoint localPoint = LocalPoint.fromWorld(this.client, x, y);
        if (localPoint == null) {
            return null;
        }
        return Perspective.localToCanvas(this.client, new LocalPoint(localPoint.getX() - 64, localPoint.getY() - 64), z);
    }
}

