/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableMergeWithMaybe<T>
extends AbstractFlowableWithUpstream<T, T> {
    final MaybeSource<? extends T> other;

    public FlowableMergeWithMaybe(Flowable<T> source2, MaybeSource<? extends T> other) {
        super(source2);
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> subscriber) {
        MergeWithObserver<? super T> parent = new MergeWithObserver<T>(subscriber);
        subscriber.onSubscribe(parent);
        this.source.subscribe(parent);
        this.other.subscribe(parent.otherObserver);
    }

    static final class MergeWithObserver<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -4592979584110982903L;
        final Subscriber<? super T> downstream;
        final AtomicReference<Subscription> mainSubscription;
        final OtherObserver<T> otherObserver;
        final AtomicThrowable errors;
        final AtomicLong requested;
        final int prefetch;
        final int limit;
        volatile SimplePlainQueue<T> queue;
        T singleItem;
        volatile boolean cancelled;
        volatile boolean mainDone;
        volatile int otherState;
        long emitted;
        int consumed;
        static final int OTHER_STATE_HAS_VALUE = 1;
        static final int OTHER_STATE_CONSUMED_OR_EMPTY = 2;

        MergeWithObserver(Subscriber<? super T> downstream) {
            this.downstream = downstream;
            this.mainSubscription = new AtomicReference();
            this.otherObserver = new OtherObserver(this);
            this.errors = new AtomicThrowable();
            this.requested = new AtomicLong();
            this.prefetch = Flowable.bufferSize();
            this.limit = this.prefetch - (this.prefetch >> 2);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            SubscriptionHelper.setOnce(this.mainSubscription, s2, this.prefetch);
        }

        @Override
        public void onNext(T t) {
            if (this.compareAndSet(0, 1)) {
                long e = this.emitted;
                if (this.requested.get() != e) {
                    SimplePlainQueue<T> q = this.queue;
                    if (q == null || q.isEmpty()) {
                        this.emitted = e + 1L;
                        this.downstream.onNext(t);
                        int c = this.consumed + 1;
                        if (c == this.limit) {
                            this.consumed = 0;
                            this.mainSubscription.get().request(c);
                        } else {
                            this.consumed = c;
                        }
                    } else {
                        q.offer(t);
                    }
                } else {
                    SimplePlainQueue<T> q = this.getOrCreateQueue();
                    q.offer(t);
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimplePlainQueue<T> q = this.getOrCreateQueue();
                q.offer(t);
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                DisposableHelper.dispose(this.otherObserver);
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.mainDone = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            BackpressureHelper.add(this.requested, n);
            this.drain();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            SubscriptionHelper.cancel(this.mainSubscription);
            DisposableHelper.dispose(this.otherObserver);
            this.errors.tryTerminateAndReport();
            if (this.getAndIncrement() == 0) {
                this.queue = null;
                this.singleItem = null;
            }
        }

        void otherSuccess(T value) {
            if (this.compareAndSet(0, 1)) {
                long e = this.emitted;
                if (this.requested.get() != e) {
                    this.emitted = e + 1L;
                    this.downstream.onNext(value);
                    this.otherState = 2;
                } else {
                    this.singleItem = value;
                    this.otherState = 1;
                    if (this.decrementAndGet() == 0) {
                        return;
                    }
                }
            } else {
                this.singleItem = value;
                this.otherState = 1;
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        void otherError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                SubscriptionHelper.cancel(this.mainSubscription);
                this.drain();
            }
        }

        void otherComplete() {
            this.otherState = 2;
            this.drain();
        }

        SimplePlainQueue<T> getOrCreateQueue() {
            SimplePlainQueue<T> q = this.queue;
            if (q == null) {
                this.queue = q = new SpscArrayQueue<T>(Flowable.bufferSize());
            }
            return q;
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            Subscriber<T> actual = this.downstream;
            int missed = 1;
            long e = this.emitted;
            int c = this.consumed;
            int lim = this.limit;
            do {
                long r = this.requested.get();
                while (e != r) {
                    boolean empty;
                    if (this.cancelled) {
                        this.singleItem = null;
                        this.queue = null;
                        return;
                    }
                    if (this.errors.get() != null) {
                        this.singleItem = null;
                        this.queue = null;
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    int os = this.otherState;
                    if (os == 1) {
                        T v = this.singleItem;
                        this.singleItem = null;
                        this.otherState = 2;
                        os = 2;
                        actual.onNext(v);
                        ++e;
                        continue;
                    }
                    boolean d = this.mainDone;
                    SimplePlainQueue<T> q = this.queue;
                    Object v = q != null ? (Object)q.poll() : null;
                    boolean bl = empty = v == null;
                    if (d && empty && os == 2) {
                        this.queue = null;
                        actual.onComplete();
                        return;
                    }
                    if (empty) break;
                    actual.onNext(v);
                    ++e;
                    if (++c != lim) continue;
                    c = 0;
                    this.mainSubscription.get().request(lim);
                }
                if (e == r) {
                    boolean empty;
                    if (this.cancelled) {
                        this.singleItem = null;
                        this.queue = null;
                        return;
                    }
                    if (this.errors.get() != null) {
                        this.singleItem = null;
                        this.queue = null;
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    boolean d = this.mainDone;
                    SimplePlainQueue<T> q = this.queue;
                    boolean bl = empty = q == null || q.isEmpty();
                    if (d && empty && this.otherState == 2) {
                        this.queue = null;
                        actual.onComplete();
                        return;
                    }
                }
                this.emitted = e;
                this.consumed = c;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        static final class OtherObserver<T>
        extends AtomicReference<Disposable>
        implements MaybeObserver<T> {
            private static final long serialVersionUID = -2935427570954647017L;
            final MergeWithObserver<T> parent;

            OtherObserver(MergeWithObserver<T> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onSuccess(T t) {
                this.parent.otherSuccess(t);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.otherError(e);
            }

            @Override
            public void onComplete() {
                this.parent.otherComplete();
            }
        }
    }
}

