/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.SourcedInterruptedException;
import com.jogamp.common.util.locks.RecursiveLock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import jogamp.common.util.locks.LockDebugUtil;

public class RecursiveLockImpl01CompleteFair
implements RecursiveLock {
    private final Sync sync = new Sync();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Throwable getLockedStack() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.lockedStack;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Thread getOwner() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isOwner(Thread thread2) {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getOwner() == thread2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isLocked() {
        Sync sync = this.sync;
        synchronized (sync) {
            return null != this.sync.getOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isLockedByOtherThread() {
        Sync sync = this.sync;
        synchronized (sync) {
            Thread thread2 = this.sync.getOwner();
            return null != thread2 && Thread.currentThread() != thread2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getHoldCount() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.holdCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void validateLocked() throws RuntimeException {
        Sync sync = this.sync;
        synchronized (sync) {
            if (Thread.currentThread() != this.sync.getOwner()) {
                if (null == this.sync.getOwner()) {
                    throw new RuntimeException(this.threadName(Thread.currentThread()) + ": Not locked: " + this.toString());
                }
                if (null != this.sync.lockedStack) {
                    this.sync.lockedStack.printStackTrace();
                }
                throw new RuntimeException(Thread.currentThread() + ": Not owner: " + this.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void lock() {
        Sync sync = this.sync;
        synchronized (sync) {
            try {
                if (!this.tryLock(TIMEOUT)) {
                    if (null != this.sync.lockedStack) {
                        this.sync.lockedStack.printStackTrace();
                    }
                    throw new RuntimeException("Waited " + TIMEOUT + "ms for: " + this.toString() + " - " + this.threadName(Thread.currentThread()));
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted", interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean tryLock(long l) throws InterruptedException {
        Sync sync = this.sync;
        synchronized (sync) {
            Thread thread2 = Thread.currentThread();
            if (TRACE_LOCK) {
                System.err.println("+++ LOCK 0 " + this.toString() + ", cur " + this.threadName(thread2));
            }
            if (this.sync.getOwner() == thread2) {
                ++this.sync.holdCount;
                if (TRACE_LOCK) {
                    System.err.println("+++ LOCK XR " + this.toString() + ", cur " + this.threadName(thread2));
                }
                return true;
            }
            if (this.sync.getOwner() != null || 0L < l && 0 < this.sync.queue.size()) {
                if (0L >= l) {
                    if (TRACE_LOCK) {
                        System.err.println("+++ LOCK XY " + this.toString() + ", cur " + this.threadName(thread2) + ", left " + l + " ms");
                    }
                    return false;
                }
                WaitingThread waitingThread = new WaitingThread(thread2);
                this.sync.queue.add(0, waitingThread);
                do {
                    long l2 = System.currentTimeMillis();
                    try {
                        this.sync.wait(l);
                        l -= System.currentTimeMillis() - l2;
                    }
                    catch (InterruptedException interruptedException) {
                        if (!waitingThread.signaledByUnlock) {
                            this.sync.queue.remove(waitingThread);
                            throw SourcedInterruptedException.wrap(interruptedException);
                        }
                        if (thread2 == this.sync.getOwner()) continue;
                        l -= System.currentTimeMillis() - l2;
                        if (TRACE_LOCK) {
                            System.err.println("+++ LOCK 1 " + this.toString() + ", cur " + this.threadName(thread2) + ", left " + l + " ms, signaled: " + waitingThread.signaledByUnlock);
                        }
                        if (0L >= l) continue;
                        waitingThread.signaledByUnlock = false;
                        this.sync.queue.add(this.sync.queue.size(), waitingThread);
                    }
                } while (thread2 != this.sync.getOwner() && 0L < l);
                Thread.interrupted();
                if (0L >= l && thread2 != this.sync.getOwner()) {
                    if (!waitingThread.signaledByUnlock) {
                        this.sync.queue.remove(waitingThread);
                    }
                    if (TRACE_LOCK) {
                        System.err.println("+++ LOCK XX " + this.toString() + ", cur " + this.threadName(thread2) + ", left " + l + " ms");
                    }
                    return false;
                }
                ++this.sync.holdCount;
                if (TRACE_LOCK) {
                    System.err.println("+++ LOCK X1 " + this.toString() + ", cur " + this.threadName(thread2) + ", left " + l + " ms");
                }
            } else {
                ++this.sync.holdCount;
                if (TRACE_LOCK) {
                    System.err.println("+++ LOCK X0 " + this.toString() + ", cur " + this.threadName(thread2));
                }
            }
            this.sync.setOwner(thread2);
            if (DEBUG) {
                this.sync.setLockedStack(new Throwable("Previously locked by " + this.toString()));
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlock() {
        Sync sync = this.sync;
        synchronized (sync) {
            this.unlock(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlock(Runnable runnable2) {
        Sync sync = this.sync;
        synchronized (sync) {
            this.validateLocked();
            Thread thread2 = Thread.currentThread();
            --this.sync.holdCount;
            if (this.sync.holdCount > 0) {
                if (TRACE_LOCK) {
                    System.err.println("--- LOCK XR " + this.toString() + ", cur " + this.threadName(thread2));
                }
                return;
            }
            if (DEBUG) {
                this.sync.setLockedStack(null);
            }
            if (null != runnable2) {
                runnable2.run();
            }
            if (this.sync.queue.size() > 0) {
                WaitingThread waitingThread = this.sync.queue.remove(this.sync.queue.size() - 1);
                this.sync.setOwner(waitingThread.thread);
                if (TRACE_LOCK) {
                    System.err.println("--- LOCK X1 " + this.toString() + ", cur " + this.threadName(thread2) + ", signal: " + this.threadName(waitingThread.thread));
                }
                waitingThread.signaledByUnlock = true;
                waitingThread.thread.interrupt();
            } else {
                this.sync.setOwner(null);
                if (TRACE_LOCK) {
                    System.err.println("--- LOCK X0 " + this.toString() + ", cur " + this.threadName(thread2) + ", signal any");
                }
                this.sync.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getQueueLength() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.queue.size();
        }
    }

    public String toString() {
        return this.syncName() + "[count " + this.sync.holdCount + ", qsz " + this.sync.queue.size() + ", owner " + this.threadName(this.sync.getOwner()) + "]";
    }

    private final String syncName() {
        return "<" + Integer.toHexString(this.hashCode()) + ", " + Integer.toHexString(this.sync.hashCode()) + ">";
    }

    private final String threadName(Thread thread2) {
        return null != thread2 ? "<" + thread2.getName() + ">" : "<NULL>";
    }

    private static class Sync
    extends AbstractOwnableSynchronizer {
        private int holdCount = 0;
        final ArrayList<WaitingThread> queue = new ArrayList();
        private Throwable lockedStack = null;

        private Sync() {
        }

        private final Thread getOwner() {
            return this.getExclusiveOwnerThread();
        }

        private final void setOwner(Thread thread2) {
            this.setExclusiveOwnerThread(thread2);
        }

        private final void setLockedStack(Throwable throwable) {
            List<Throwable> list = LockDebugUtil.getRecursiveLockTrace();
            if (throwable == null) {
                list.remove(this.lockedStack);
            } else {
                list.add(throwable);
            }
            this.lockedStack = throwable;
        }
    }

    private static class WaitingThread {
        final Thread thread;
        boolean signaledByUnlock;

        WaitingThread(Thread thread2) {
            this.thread = thread2;
            this.signaledByUnlock = false;
        }
    }
}

