/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.curseprayertooltip;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.client.plugins.curseprayertooltip.CursePrayer;
import net.runelite.client.plugins.curseprayertooltip.CursePrayerTooltipConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;

public class CursePrayerTooltipOverlay
extends Overlay {
    private static final int CURSE_PRAYER_INTERFACE_ID = 1703;
    private static final int ICON_SIZE = 34;
    private static final int ICON_SPACING = 37;
    private static final int GRID_START_X = 5;
    private static final int GRID_START_Y = 5;
    private final Client client;
    private final CursePrayerTooltipConfig config;
    private final TooltipManager tooltipManager;

    @Inject
    private CursePrayerTooltipOverlay(Client client, CursePrayerTooltipConfig config, TooltipManager tooltipManager) {
        this.client = client;
        this.config = config;
        this.tooltipManager = tooltipManager;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (!this.config.showTooltips()) {
            return null;
        }
        Widget cursePrayerWidget = this.client.getWidget(1703, 0);
        if (cursePrayerWidget == null || cursePrayerWidget.isHidden()) {
            return null;
        }
        Point mousePos = this.client.getMouseCanvasPosition();
        if (mousePos == null) {
            return null;
        }
        Rectangle widgetBounds = cursePrayerWidget.getBounds();
        if (widgetBounds == null) {
            return null;
        }
        int relativeX = mousePos.getX() - (int)widgetBounds.getX();
        int relativeY = mousePos.getY() - (int)widgetBounds.getY();
        if (relativeX < 5 || relativeY < 5) {
            return null;
        }
        int gridX = (relativeX - 5) / 37;
        int gridY = (relativeY - 5) / 37;
        if (gridX < 0 || gridX >= 5 || gridY < 0) {
            return null;
        }
        int iconOffsetX = (relativeX - 5) % 37;
        int iconOffsetY = (relativeY - 5) % 37;
        if (iconOffsetX >= 34 || iconOffsetY >= 34) {
            return null;
        }
        for (CursePrayer prayer : CursePrayer.values()) {
            if (prayer.getGridX() != gridX || prayer.getGridY() != gridY) continue;
            this.tooltipManager.add(new Tooltip(prayer.getTooltipText()));
            break;
        }
        return null;
    }
}

