/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import net.runelite.client.plugins.gpu.ShaderException;
import net.runelite.client.plugins.gpu.template.Template;
import org.lwjgl.opengl.GL43C;

public class Shader {
    @VisibleForTesting
    final List<Unit> units = new ArrayList<Unit>();

    public Shader add(int type, String name) {
        this.units.add(new Unit(type, name));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(Template template) throws ShaderException {
        int program = GL43C.glCreateProgram();
        int[] shaders = new int[this.units.size()];
        int i = 0;
        boolean ok = false;
        try {
            String err;
            while (i < shaders.length) {
                Unit unit = this.units.get(i);
                int shader = GL43C.glCreateShader(unit.type);
                if (shader == 0) {
                    throw new ShaderException("Unable to create shader of type " + unit.type);
                }
                String source2 = template.load(unit.filename);
                GL43C.glShaderSource(shader, (CharSequence)source2);
                GL43C.glCompileShader(shader);
                if (GL43C.glGetShaderi(shader, 35713) != 1) {
                    String err2 = GL43C.glGetShaderInfoLog(shader);
                    GL43C.glDeleteShader(shader);
                    throw new ShaderException(err2);
                }
                GL43C.glAttachShader(program, shader);
                shaders[i++] = shader;
            }
            GL43C.glLinkProgram(program);
            if (GL43C.glGetProgrami(program, 35714) == 0) {
                err = GL43C.glGetProgramInfoLog(program);
                throw new ShaderException(err);
            }
            GL43C.glValidateProgram(program);
            if (GL43C.glGetProgrami(program, 35715) == 0) {
                err = GL43C.glGetProgramInfoLog(program);
                throw new ShaderException(err);
            }
            ok = true;
        }
        finally {
            while (i > 0) {
                int shader = shaders[--i];
                GL43C.glDetachShader(program, shader);
                GL43C.glDeleteShader(shader);
            }
            if (!ok) {
                GL43C.glDeleteProgram(program);
            }
        }
        return program;
    }

    @VisibleForTesting
    static class Unit {
        private final int type;
        private final String filename;

        public Unit(int type, String filename) {
            this.type = type;
            this.filename = filename;
        }

        public int getType() {
            return this.type;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

