/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.petmanagement;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.petmanagement.PetManagementConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Pet Management", description="Handles the pet management interface interactions", tags={"pet", "management", "interface"})
public class PetManagementPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PetManagementPlugin.class);
    private static final int PET_MANAGEMENT_INTERFACE_ID = 5105;
    private static final int PET_BAG_COMPONENT = 9;
    private static final int ACTIVE_SLOT_1_COMPONENT = 14;
    private static final int ACTIVE_SLOT_2_COMPONENT = 15;
    private static final int ACTIVE_SLOT_3_COMPONENT = 16;
    private static final int INFO_COMPONENT = 30;
    @Inject
    private Client client;

    @Override
    protected void startUp() throws Exception {
        log.info("Pet Management plugin started");
    }

    @Override
    protected void shutDown() throws Exception {
        log.info("Pet Management plugin stopped");
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 5105) {
            log.debug("Pet Management interface loaded");
            this.configureComponent(9, "Pet Bag");
            this.configureComponent(14, "Active Slot 1");
            this.configureComponent(15, "Active Slot 2");
            this.configureComponent(16, "Active Slot 3");
            Widget infoComponent = this.client.getWidget(5105, 30);
            if (infoComponent != null) {
                log.debug("Info component loaded");
            }
        }
    }

    private void configureComponent(int componentId, String name) {
        Widget component = this.client.getWidget(5105, componentId);
        if (component != null) {
            log.debug("{} component loaded successfully", (Object)name);
            component.setHasListener(true);
        } else {
            log.warn("{} component (ID: {}) not found!", (Object)name, (Object)componentId);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        int interfaceId = event.getWidgetId() >> 16;
        int componentId = event.getWidgetId() & 0xFFFF;
        if (interfaceId == 5105) {
            switch (componentId) {
                case 9: {
                    log.debug("Pet bag clicked - slot: {}, option: {}", (Object)event.getParam0(), (Object)event.getMenuOption());
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    log.debug("Active pet slot {} clicked - option: {}", (Object)componentId, (Object)event.getMenuOption());
                }
            }
        }
    }

    @Provides
    PetManagementConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(PetManagementConfig.class);
    }
}

