/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.jgroups.BytesMessage;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.demos.MyCanvas;
import org.jgroups.demos.TotOrderRequest;
import org.jgroups.util.Util;

public class TotalOrder
extends Frame {
    final Font def_font = new Font("Helvetica", 1, 12);
    final Font def_font2 = new Font("Helvetica", 0, 12);
    MyCanvas canvas;
    final MenuBar menubar = this.createMenuBar();
    final Button start = new Button("Start");
    final Button stop = new Button("Stop");
    final Button clear = new Button("Clear");
    final Button get_state = new Button("Get State");
    final Button quit = new Button("Quit");
    final Panel button_panel = new Panel();
    SenderThread sender = null;
    JChannel channel;
    long timeout = 0L;
    int field_size = 0;
    int num_fields = 0;
    static final int x_offset = 30;
    static final int y_offset = 40;
    private int num = 0;
    private int num_additions = 0;
    private int num_subtractions = 0;
    private int num_divisions = 0;
    private int num_multiplications = 0;

    static void error(String s2) {
        System.err.println(s2);
    }

    void processRequest(TotOrderRequest req) throws Exception {
        int x = req.x;
        int y = req.y;
        int val = req.val;
        if (req.type == 0) {
            this.stopSender();
            return;
        }
        switch (req.type) {
            case 1: {
                this.canvas.addValueTo(x, y, val);
                ++this.num_additions;
                break;
            }
            case 2: {
                this.canvas.subtractValueFrom(x, y, val);
                ++this.num_subtractions;
                break;
            }
            case 3: {
                this.canvas.multiplyValueWith(x, y, val);
                ++this.num_multiplications;
                break;
            }
            case 4: {
                this.canvas.divideValueBy(x, y, val);
                ++this.num_divisions;
            }
        }
        this.canvas.update();
    }

    public TotalOrder(String title, long timeout2, int num_fields, int field_size, String props, int num) {
        this.timeout = timeout2;
        this.num_fields = num_fields;
        this.field_size = field_size;
        this.num = num;
        this.setFont(this.def_font);
        this.start.addActionListener(e -> this.startSender());
        this.stop.addActionListener(e -> {
            try {
                TotOrderRequest req = new TotOrderRequest(0, 0, 0, 0);
                byte[] buf = req.toBuffer();
                this.channel.send(new BytesMessage(null, buf));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.clear.addActionListener(e -> this.canvas.clear());
        this.get_state.addActionListener(e -> {
            try {
                this.channel.getState(null, 3000L);
            }
            catch (Throwable t) {
                TotalOrder.error("exception fetching state: " + t);
            }
        });
        this.quit.addActionListener(e -> {
            this.channel.close();
            System.exit(0);
        });
        this.setTitle(title);
        this.addWindowListener(new EventHandler(this));
        this.setBackground(Color.white);
        this.setMenuBar(this.menubar);
        this.setLayout(new BorderLayout());
        this.canvas = new MyCanvas(num_fields, field_size, 30, 40);
        this.add("Center", this.canvas);
        this.button_panel.setLayout(new FlowLayout());
        this.button_panel.setFont(this.def_font2);
        this.button_panel.add(this.start);
        this.button_panel.add(this.stop);
        this.button_panel.add(this.clear);
        this.button_panel.add(this.get_state);
        this.button_panel.add(this.quit);
        this.add("South", this.button_panel);
        Dimension s2 = this.canvas.getSize();
        s2.height += 100;
        this.setSize(s2);
        try {
            this.channel = new JChannel(props);
            this.channel.setReceiver(new Receiver(){

                @Override
                public void receive(Message msg) {
                    try {
                        TotOrderRequest req = new TotOrderRequest();
                        ByteBuffer buf = ByteBuffer.wrap(msg.getArray(), msg.getOffset(), msg.getLength());
                        req.init(buf);
                        TotalOrder.this.processRequest(req);
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                }

                @Override
                public void getState(OutputStream output) throws Exception {
                    int[][] copy_of_state = TotalOrder.this.canvas.getCopyOfState();
                    Util.objectToStream(copy_of_state, new DataOutputStream(output));
                }

                @Override
                public void setState(InputStream input) throws Exception {
                    TotalOrder.this.canvas.setState(Util.objectFromStream(new DataInputStream(input)));
                }

                @Override
                public void viewAccepted(View view) {
                    System.out.println("view = " + view);
                }
            });
            this.channel.connect("TotalOrderGroup");
            this.channel.getState(null, 8000L);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(-1);
        }
    }

    void startSender() {
        if (this.sender == null || !this.sender.isAlive()) {
            this.sender = new SenderThread();
            this.sender.start();
        }
    }

    void stopSender() {
        if (this.sender != null) {
            this.sender.stopSender();
            this.sender = null;
        }
    }

    private MenuBar createMenuBar() {
        MenuBar ret = new MenuBar();
        Menu file = new Menu("File");
        MenuItem quitm = new MenuItem("Quit");
        ret.setFont(this.def_font2);
        ret.add(file);
        file.addSeparator();
        file.add(quitm);
        quitm.addActionListener(e -> System.exit(1));
        return ret;
    }

    private TotOrderRequest createRandomRequest() {
        TotOrderRequest ret = null;
        byte op_type = (byte)(Math.random() * 10.0 % 4.0 + 1.0);
        int x = (int)(Math.random() * (double)this.num_fields * 2.0 % (double)this.num_fields);
        int y = (int)(Math.random() * (double)this.num_fields * 2.0 % (double)this.num_fields);
        int val = (int)(Math.random() * (double)this.num_fields * 200.0 % 10.0);
        ret = new TotOrderRequest(op_type, x, y, val);
        return ret;
    }

    public static void main(String[] args2) {
        long timeout2 = 200L;
        int num_fields = 3;
        int field_size = 80;
        String props = null;
        int num = 0;
        props = "udp.xml";
        for (int i = 0; i < args2.length; ++i) {
            String arg = args2[i];
            if ("-timeout".equals(arg)) {
                timeout2 = Long.parseLong(args2[++i]);
                continue;
            }
            if ("-num_fields".equals(arg)) {
                num_fields = Integer.parseInt(args2[++i]);
                continue;
            }
            if ("-field_size".equals(arg)) {
                field_size = Integer.parseInt(args2[++i]);
                continue;
            }
            if ("-help".equals(arg)) {
                TotalOrder.help();
                return;
            }
            if ("-props".equals(arg)) {
                props = args2[++i];
                continue;
            }
            if ("-num".equals(arg)) {
                num = Integer.parseInt(args2[++i]);
            }
            TotalOrder.help();
            return;
        }
        try {
            TotalOrder g2 = new TotalOrder("Total Order Demo on " + InetAddress.getLocalHost().getHostName(), timeout2, num_fields, field_size, props, num);
            g2.setVisible(true);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    protected static void help() {
        System.out.println("\nTotalOrder [-timeout <value>] [-num_fields <value>] [-field_size <value>] [-props <properties (can be URL)>] [-num <num requests>]\n");
    }

    class SenderThread
    extends Thread {
        TotOrderRequest req;
        boolean running = true;

        SenderThread() {
        }

        public void stopSender() {
            this.running = false;
            this.interrupt();
            System.out.println("-- num_additions: " + TotalOrder.this.num_additions + "\n-- num_subtractions: " + TotalOrder.this.num_subtractions + "\n-- num_divisions: " + TotalOrder.this.num_divisions + "\n-- num_multiplications: " + TotalOrder.this.num_multiplications);
            TotalOrder.this.num_divisions = 0;
            TotalOrder.this.num_multiplications = 0;
            TotalOrder.this.num_subtractions = 0;
            TotalOrder.this.num_additions = 0;
        }

        @Override
        public void run() {
            this.setName("SenderThread");
            int cnt = 0;
            while (this.running) {
                try {
                    this.req = TotalOrder.this.createRandomRequest();
                    byte[] buf = this.req.toBuffer();
                    TotalOrder.this.channel.send(new BytesMessage(null, buf));
                    System.out.print("-- num requests sent: " + cnt + "\r");
                    if (TotalOrder.this.timeout > 0L) {
                        Util.sleep(TotalOrder.this.timeout);
                    }
                    if (TotalOrder.this.num <= 0 || ++cnt <= TotalOrder.this.num) continue;
                    this.running = false;
                    cnt = 0;
                }
                catch (Exception e) {
                    TotalOrder.error(e.toString());
                    return;
                }
            }
        }
    }

    static class EventHandler
    extends WindowAdapter {
        final Frame gui;

        public EventHandler(Frame g2) {
            this.gui = g2;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.gui.dispose();
            System.exit(0);
        }
    }
}

