/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.config;

import net.runelite.api.Client;
import rs117.hd.utils.HDUtils;

public enum DefaultSkyColor {
    DEFAULT("117HD (Blue)", 185, 214, 255),
    RUNELITE("RuneLite Skybox", -1, -1, -1),
    OSRS("Old School (Black)", 0, 0, 0),
    HD2008("2008 HD (Tan)", 200, 192, 169);

    private final String name;
    private final int r;
    private final int g;
    private final int b;

    public String toString() {
        return this.name;
    }

    public float[] getRgb(Client client) {
        int r = this.r;
        int g2 = this.g;
        int b = this.b;
        if (this == RUNELITE) {
            int sky = client.getSkyboxColor();
            r = sky >> 16 & 0xFF;
            g2 = sky >> 8 & 0xFF;
            b = sky & 0xFF;
        }
        return new float[]{HDUtils.srgbToLinear((float)r / 255.0f), HDUtils.srgbToLinear((float)g2 / 255.0f), HDUtils.srgbToLinear((float)b / 255.0f)};
    }

    public String getName() {
        return this.name;
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    private DefaultSkyColor(String name, int r, int g2, int b) {
        this.name = name;
        this.r = r;
        this.g = g2;
        this.b = b;
    }
}

