/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class DataUtils {
    public static void writeFile(File f, byte[] data2) {
        try (RandomAccessFile raf = new RandomAccessFile(f, "rw");){
            raf.write(data2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeFile(byte[] data2, String fileName) throws IOException {
        FileOutputStream out = new FileOutputStream(fileName);
        ((OutputStream)out).write(data2);
        ((OutputStream)out).close();
    }

    public static int readJAGHash(String string2) {
        int id = 0;
        string2 = string2.toUpperCase();
        for (int j = 0; j < string2.length(); ++j) {
            id = id * 61 + string2.charAt(j) - 32;
        }
        return id;
    }

    public static int getCRCFromData(byte[] data2) {
        CRC32 crc = new CRC32();
        crc.update(data2);
        return (int)crc.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gZipDecompress(byte[] b) throws IOException {
        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(b));
        byte[] buf = new byte[1024];
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int len;
            while ((len = gzi.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
        }
        return out.toByteArray();
    }

    public static byte[] gzDecompress(byte[] b) throws IOException {
        int len;
        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(b));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = gzi.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.close();
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] unzip(byte[] data2) throws IOException {
        InputStream in = new ByteArrayInputStream(data2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int noRead;
            in = new GZIPInputStream(in);
            byte[] buffer = new byte[65536];
            while ((noRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, noRead);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFile(String name) {
        try {
            RandomAccessFile raf = new RandomAccessFile(name, "r");
            MappedByteBuffer buf = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
            try {
                if (buf.hasArray()) {
                    byte[] byArray = buf.array();
                    return byArray;
                }
                byte[] array = new byte[buf.remaining()];
                buf.get(array);
                byte[] byArray = array;
                return byArray;
            }
            finally {
                raf.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gZipCompress(byte[] data2, int off, int len) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gzo = new GZIPOutputStream(bos);
        try {
            gzo.write(data2, off, len);
        }
        finally {
            gzo.close();
            bos.close();
        }
        return bos.toByteArray();
    }
}

