/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Buffer;
import com.client.FileArchive;
import com.client.Rasterizer2D;
import net.runelite.rs.api.RSIndexedSprite;

public final class IndexedImage
extends Rasterizer2D
implements RSIndexedSprite {
    public final int[] palette;
    public byte[] palettePixels;
    public int subWidth;
    public int subHeight;
    public int xOffset;
    public int yOffset;
    public int width;
    private int height;

    public void setTransparency(int transRed, int transGreen, int transBlue) {
        for (int index = 0; index < this.palette.length; ++index) {
            if ((this.palette[index] >> 16 & 0xFF) != transRed || (this.palette[index] >> 8 & 0xFF) != transGreen || (this.palette[index] & 0xFF) != transBlue) continue;
            this.palette[index] = 0;
        }
    }

    public IndexedImage(FileArchive archive, String s2, int i) {
        block6: {
            int type2;
            Buffer image;
            block5: {
                image = new Buffer(archive.readFile(s2 + ".dat"));
                Buffer meta = new Buffer(archive.readFile("index.dat"));
                meta.currentPosition = image.readUShort();
                this.width = meta.readUShort();
                this.height = meta.readUShort();
                int colorLength = meta.readUnsignedByte();
                this.palette = new int[colorLength];
                for (int index = 0; index < colorLength - 1; ++index) {
                    this.palette[index + 1] = meta.readTriByte();
                }
                for (int l = 0; l < i; ++l) {
                    meta.currentPosition += 2;
                    image.currentPosition += meta.readUShort() * meta.readUShort();
                    ++meta.currentPosition;
                }
                this.xOffset = meta.readUnsignedByte();
                this.yOffset = meta.readUnsignedByte();
                this.subWidth = meta.readUShort();
                this.subHeight = meta.readUShort();
                type2 = meta.readUnsignedByte();
                int pixels = this.subWidth * this.subHeight;
                this.palettePixels = new byte[pixels];
                if (type2 != 0) break block5;
                for (int index = 0; index < pixels; ++index) {
                    this.palettePixels[index] = image.readSignedByte();
                }
                break block6;
            }
            if (type2 != 1) break block6;
            for (int x = 0; x < this.subWidth; ++x) {
                for (int y = 0; y < this.subHeight; ++y) {
                    this.palettePixels[x + y * this.subWidth] = image.readSignedByte();
                }
            }
        }
    }

    public void normalize() {
        if (this.subWidth != this.width || this.subHeight != this.height) {
            byte[] pixels = new byte[this.width * this.height];
            int var2 = 0;
            for (int var3 = 0; var3 < this.subHeight; ++var3) {
                for (int var4 = 0; var4 < this.subWidth; ++var4) {
                    pixels[var4 + (var3 + this.yOffset) * this.width + this.xOffset] = this.palettePixels[var2++];
                }
            }
            this.palettePixels = pixels;
            this.subWidth = this.width;
            this.subHeight = this.height;
            this.xOffset = 0;
            this.yOffset = 0;
        }
    }

    public void resize() {
        if (this.subWidth == this.width && this.subHeight == this.height) {
            return;
        }
        byte[] raster = new byte[this.width * this.height];
        int i = 0;
        for (int y = 0; y < this.subHeight; ++y) {
            for (int x = 0; x < this.subWidth; ++x) {
                raster[x + this.xOffset + (y + this.yOffset) * this.width] = raster[i++];
            }
        }
        this.palettePixels = raster;
        this.subWidth = this.width;
        this.subHeight = this.height;
        this.xOffset = 0;
        this.yOffset = 0;
    }

    public void flipHorizontally() {
        byte[] raster = new byte[this.subWidth * this.subHeight];
        int pixel = 0;
        for (int y = 0; y < this.subHeight; ++y) {
            for (int x = this.subWidth - 1; x >= 0; --x) {
                raster[pixel++] = raster[x + y * this.subWidth];
            }
        }
        this.palettePixels = raster;
        this.xOffset = this.width - this.subWidth - this.xOffset;
    }

    public void flipVertically() {
        byte[] raster = new byte[this.subWidth * this.subHeight];
        int pixel = 0;
        for (int y = this.subHeight - 1; y >= 0; --y) {
            for (int x = 0; x < this.subWidth; ++x) {
                raster[pixel++] = raster[x + y * this.subWidth];
            }
        }
        this.palettePixels = raster;
        this.yOffset = this.height - this.subHeight - this.yOffset;
    }

    public void offsetColor(int redOffset, int greenOffset, int blueOffset) {
        for (int index = 0; index < this.palette.length; ++index) {
            int red = this.palette[index] >> 16 & 0xFF;
            if ((red += redOffset) < 0) {
                red = 0;
            } else if (red > 255) {
                red = 255;
            }
            int green = this.palette[index] >> 8 & 0xFF;
            if ((green += greenOffset) < 0) {
                green = 0;
            } else if (green > 255) {
                green = 255;
            }
            int blue = this.palette[index] & 0xFF;
            if ((blue += blueOffset) < 0) {
                blue = 0;
            } else if (blue > 255) {
                blue = 255;
            }
            this.palette[index] = (red << 16) + (green << 8) + blue;
        }
    }

    public void draw(int x, int y) {
        int destOffset = (x += this.xOffset) + (y += this.yOffset) * Rasterizer2D.width;
        int sourceOffset = 0;
        int height = this.subHeight;
        int width = this.subWidth;
        int destStep = Rasterizer2D.width - width;
        int sourceStep = 0;
        if (y < Rasterizer2D.topY) {
            int dy = Rasterizer2D.topY - y;
            height -= dy;
            y = Rasterizer2D.topY;
            sourceOffset += dy * width;
            destOffset += dy * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.leftX) {
            int k2 = Rasterizer2D.leftX - x;
            width -= k2;
            x = Rasterizer2D.leftX;
            sourceOffset += k2;
            destOffset += k2;
            sourceStep += k2;
            destStep += k2;
        }
        if (x + width > Rasterizer2D.bottomX) {
            int dx = x + width - Rasterizer2D.bottomX;
            width -= dx;
            sourceStep += dx;
            destStep += dx;
        }
        if (width > 0 && height > 0) {
            this.draw(height, Rasterizer2D.pixels, this.palettePixels, destStep, destOffset, width, sourceOffset, this.palette, sourceStep);
        }
    }

    private void draw(int i, int[] raster, byte[] image, int destStep, int destIndex, int width, int sourceIndex, int[] ai1, int sourceStep) {
        int minX = -(width >> 2);
        width = -(width & 3);
        for (int y = -i; y < 0; ++y) {
            byte pixel;
            int x;
            for (x = minX; x < 0; ++x) {
                if ((pixel = image[sourceIndex++]) != 0) {
                    raster[destIndex++] = ai1[pixel & 0xFF];
                } else {
                    ++destIndex;
                }
                pixel = image[sourceIndex++];
                if (pixel != 0) {
                    raster[destIndex++] = ai1[pixel & 0xFF];
                } else {
                    ++destIndex;
                }
                pixel = image[sourceIndex++];
                if (pixel != 0) {
                    raster[destIndex++] = ai1[pixel & 0xFF];
                } else {
                    ++destIndex;
                }
                pixel = image[sourceIndex++];
                if (pixel != 0) {
                    raster[destIndex++] = ai1[pixel & 0xFF];
                    continue;
                }
                ++destIndex;
            }
            for (x = width; x < 0; ++x) {
                if ((pixel = image[sourceIndex++]) != 0) {
                    raster[destIndex++] = ai1[pixel & 0xFF];
                    continue;
                }
                ++destIndex;
            }
            destIndex += destStep;
            sourceIndex += sourceStep;
        }
    }

    @Override
    public byte[] getPixels() {
        return this.palettePixels;
    }

    @Override
    public void setPixels(byte[] pixels) {
        this.palettePixels = pixels;
    }

    @Override
    public int[] getPalette() {
        return pixels;
    }

    @Override
    public void setPalette(int[] palette) {
        pixels = palette;
    }

    @Override
    public int getOriginalWidth() {
        return this.subWidth;
    }

    @Override
    public void setOriginalWidth(int originalWidth) {
        this.subWidth = originalWidth;
    }

    @Override
    public int getOriginalHeight() {
        return this.subHeight;
    }

    @Override
    public void setOriginalHeight(int originalHeight) {
        this.subHeight = originalHeight;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getOffsetX() {
        return this.xOffset;
    }

    @Override
    public void setOffsetX(int offsetX) {
        this.xOffset = offsetX;
    }

    @Override
    public int getOffsetY() {
        return this.yOffset;
    }

    @Override
    public void setOffsetY(int offsetY) {
        this.yOffset = offsetY;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }
}

