/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.definitions.ItemDefinition;
import com.client.sign.Signlink;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ItemStats {
    public static final int STAB = 0;
    public static final int SLASH = 1;
    public static final int CRUSH = 2;
    public static final int MAGIC = 3;
    public static final int RANGED = 4;
    public static ItemStats[] itemstats = new ItemStats[ItemDefinition.totalItems > 0 ? ItemDefinition.totalItems : 40000];
    public int itemId;
    public int[] attackBonus;
    public int[] defenceBonus;
    public int prayerBonus;
    public int rangeBonus;
    public int strengthBonus;
    public int magicBonus;
    public int healAmount;
    public int type;
    public int[][] rewards;
    public String information;
    private static int readType = 0;

    public ItemStats(int id, int typeOfStat) {
        this.itemId = id;
        this.attackBonus = new int[]{0, 0, 0, 0, 0};
        this.defenceBonus = new int[]{0, 0, 0, 0, 0};
        this.prayerBonus = 0;
        this.strengthBonus = 0;
        this.rangeBonus = 0;
        this.magicBonus = 0;
        this.healAmount = 0;
        this.type = typeOfStat;
    }

    public static void readDefinitions() {
        try {
            String line;
            File file = new File(Signlink.getCacheDirectory() + "itemstats.dat");
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                int i;
                if (line.equals("[STATS]")) {
                    readType = 1;
                    continue;
                }
                if (readType != 1) continue;
                String[] data2 = line.split(" ");
                int slot = 0;
                int id = Integer.parseInt(data2[slot++]);
                ItemStats.itemstats[id] = new ItemStats(id, readType);
                for (i = 0; i < 5; ++i) {
                    ItemStats.itemstats[id].attackBonus[i] = Integer.parseInt(data2[slot++]);
                }
                for (i = 0; i < 5; ++i) {
                    ItemStats.itemstats[id].defenceBonus[i] = Integer.parseInt(data2[slot++]);
                }
                ItemStats.itemstats[id].strengthBonus = Integer.parseInt(data2[slot++]);
                ItemStats.itemstats[id].rangeBonus = Integer.parseInt(data2[slot++]);
                ItemStats.itemstats[id].magicBonus = Integer.parseInt(data2[slot++]);
                ItemStats.itemstats[id].prayerBonus = Integer.parseInt(data2[slot++]);
            }
            fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

