/*
 * Decompiled with CFR 0.152.
 */
package com.client;

public class MathUtils {
    public static float dist(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt(MathUtils.sq(x2 - x1) + MathUtils.sq(y2 - y1));
    }

    public static final float sq(float n) {
        return n * n;
    }

    public static float smoothstep(float edge0, float edge1, float x) {
        x = MathUtils.constrain((x - edge0) / (edge1 - edge0), 0.0f, 1.0f);
        return x * x * (3.0f - 2.0f * x);
    }

    public static final float constrain(float amt, float low, float high) {
        return amt < low ? low : (amt > high ? high : amt);
    }

    public static float map(float value, float istart, float istop, float ostart, float ostop) {
        return ostart + (ostop - ostart) * ((value - istart) / (istop - istart));
    }

    public static float norm(float value, float start, float stop) {
        return (value - start) / (stop - start);
    }

    public static int lerpColor(int c1, int c2, float amt) {
        if (amt < 0.0f) {
            amt = 0.0f;
        }
        if (amt > 1.0f) {
            amt = 1.0f;
        }
        float a1 = c1 >> 24 & 0xFF;
        float a2 = c1 >> 16 & 0xFF;
        float g1 = c1 >> 8 & 0xFF;
        float ho = c1 & 0xFF;
        float so = c2 >> 24 & 0xFF;
        float bo = c2 >> 16 & 0xFF;
        float g2 = c2 >> 8 & 0xFF;
        float b2 = c2 & 0xFF;
        return Math.round(a1 + (so - a1) * amt) << 24 | Math.round(a2 + (bo - a2) * amt) << 16 | Math.round(g1 + (g2 - g1) * amt) << 8 | Math.round(ho + (b2 - ho) * amt);
    }
}

