/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.AABB;
import com.client.Buffer;
import com.client.Client;
import com.client.FaceNormal;
import com.client.ModelHeader;
import com.client.ModelLoader;
import com.client.Rasterizer2D;
import com.client.Rasterizer3D;
import com.client.Renderable;
import com.client.SceneGraph;
import com.client.VertexNormal;
import com.client.definitions.SeqBase;
import com.client.definitions.SeqDefinition;
import com.client.definitions.SeqFrame;
import com.client.definitions.anims.defs.SeqBaseDefs;
import com.client.definitions.anims.defs.SeqFrameDefs;
import com.client.definitions.skeletal.AB;
import com.client.definitions.skeletal.ABW;
import com.client.definitions.skeletal.SkaFSet;
import com.client.definitions.skeletal.TO;
import com.client.engine.impl.MouseHandler;
import com.client.util.math.Matrix4f;
import com.client.utilities.ObjectKeyUtil;
import com.displee.cache.index.Index;
import com.google.common.collect.ImmutableSet;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.runelite.api.Perspective;
import net.runelite.api.hooks.DrawCallbacks;
import net.runelite.api.model.Jarvis;
import net.runelite.api.model.Triangle;
import net.runelite.api.model.Vertex;
import net.runelite.rs.api.RSFrames;
import net.runelite.rs.api.RSModel;

public class Model
extends Renderable
implements RSModel {
    public boolean DEBUG_MODELS = false;
    public static Model[] modelCache = new Model[100000];
    public static boolean[] newmodel;
    private static Matrix4f fbm;
    private static Matrix4f sm;
    private static Matrix4f cbm;
    private static boolean mouseInViewport;
    static final Set<Integer> OBSTACLE_IDS;
    private int boundsType;
    boolean isBoundsCalculated;
    public int[][] skeletalBones;
    public int[][] skeletalScales;
    private float[] faceTextureUVCoordinates;
    private int[] vertexNormalsX;
    private int[] vertexNormalsY;
    private int[] vertexNormalsZ;
    public short[] materials;
    public byte[] textures;
    public byte[] textureTypes;
    public static int anInt1620;
    public static Model emptyModel;
    private static int[] sharedVerticesX;
    private static int[] sharedVerticesY;
    private static int[] sharedVerticesZ;
    private static byte[] sharedTriangleAlpha;
    public int verticesCount;
    public int[] verticesX;
    public int[] verticesY;
    public int[] verticesZ;
    public int trianglesCount;
    public int[] trianglesX;
    public int[] trianglesY;
    public int[] trianglesZ;
    public int[] colorsX;
    public int[] colorsY;
    public int[] colorsZ;
    public int[] drawType;
    public byte[] renderPriorities;
    public byte[] triangleAlpha;
    public short[] colors;
    public byte facePriority = 0;
    public int texturesCount;
    public int[] texturesX;
    public int[] texturesY;
    public int[] texturesZ;
    public int minX;
    public int maxX;
    public int maxZ;
    public int minZ;
    public int diagonal2DAboveOrigin;
    public int maxY;
    public int diagonal3D;
    public int diagonal3DAboveOrigin;
    public int itemDropHeight;
    public int[] vertexData;
    public int[] triangleData;
    public int[][] groupedVertexLabels;
    public int[][] groupedTriangleLabels;
    public short ambient;
    public short contrast;
    public boolean isSingleTile = false;
    public boolean singleTile;
    public VertexNormal[] vertexNormalsOffsets;
    private FaceNormal[] faceNormals;
    static ModelHeader[] modelHeaders;
    static boolean[] hasAnEdgeToRestrict;
    static boolean[] outOfReach;
    static int[] vertexScreenX;
    static int[] vertexScreenY;
    static int[] vertexScreenZ;
    static int[] vertexMovedX;
    static int[] vertexMovedY;
    static int[] vertexMovedZ;
    static int[] depth;
    static int[][] faceLists;
    static int[] anIntArray1673;
    static int[][] anIntArrayArray1674;
    static int[] anIntArray1676;
    static int[] anIntArray1675;
    static int[] anIntArray1677;
    static int[] xPosition;
    static int[] yPosition;
    static int[] zPosition;
    static int xAnimOffset;
    static int yAnimOffset;
    static int zAnimOffset;
    public static boolean objectExist;
    public static int cursorX;
    public static int cursorY;
    public static int objectsHovering;
    public static long[] hoveringObjects;
    public static int[] SINE;
    public static int[] COSINE;
    static int[] modelColors;
    static int[] modelLocations;
    HashMap<Integer, net.runelite.api.AABB> aabb = new HashMap();
    public int bufferOffset;
    public int uvBufferOffset;
    private int sceneId;
    public int lastOrientation = -1;
    private short[] originalColors;

    public static void clear() {
        modelHeaders = null;
        hasAnEdgeToRestrict = null;
        outOfReach = null;
        vertexScreenY = null;
        vertexScreenZ = null;
        vertexMovedX = null;
        vertexMovedY = null;
        vertexMovedZ = null;
        depth = null;
        faceLists = null;
        anIntArray1673 = null;
        anIntArrayArray1674 = null;
        anIntArray1675 = null;
        anIntArray1676 = null;
        anIntArray1677 = null;
        SINE = null;
        COSINE = null;
        modelColors = null;
        modelLocations = null;
    }

    public void scale2(int i) {
        for (int i1 = 0; i1 < this.verticesCount; ++i1) {
            this.verticesX[i1] = this.verticesX[i1] / i;
            this.verticesY[i1] = this.verticesY[i1] / i;
            this.verticesZ[i1] = this.verticesZ[i1] / i;
        }
    }

    public Model(int modelId) {
        if (modelId == 0) {
            return;
        }
        if (modelId == 39284 || modelId == 1295) {
            return;
        }
        try {
            this.verticesCount = 0;
            this.trianglesCount = 0;
            this.facePriority = 0;
            this.isBoundsCalculated = false;
            byte[] data2 = Model.modelHeaders[modelId].data;
            if (data2[data2.length - 1] == -3 && data2[data2.length - 2] == -1) {
                ModelLoader.decodeType3(this, data2);
            } else if (data2[data2.length - 1] == -2 && data2[data2.length - 2] == -1) {
                ModelLoader.decodeType2(this, data2);
            } else if (data2[data2.length - 1] == -1 && data2[data2.length - 2] == -1) {
                ModelLoader.decodeType1(this, data2);
            } else {
                ModelLoader.decodeOldFormat(this, data2);
            }
            if (newmodel[modelId]) {
                this.scale2(4);
                if (this.renderPriorities != null) {
                    for (int j = 0; j < this.renderPriorities.length; ++j) {
                        this.renderPriorities[j] = 10;
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error decoding model: " + modelId);
        }
    }

    public static void loadModel(byte[] modelData, int modelId) {
        int offset;
        if (modelData == null) {
            ModelHeader modelHeader = Model.modelHeaders[modelId] = new ModelHeader();
            modelHeader.vertexCount = 0;
            modelHeader.triangleCount = 0;
            modelHeader.texturedTriangleCount = 0;
            return;
        }
        Buffer stream = new Buffer(modelData);
        stream.currentPosition = modelData.length - 18;
        ModelHeader modelHeader = Model.modelHeaders[modelId] = new ModelHeader();
        modelHeader.data = modelData;
        modelHeader.vertexCount = stream.readUShort();
        modelHeader.triangleCount = stream.readUShort();
        modelHeader.texturedTriangleCount = stream.readUnsignedByte();
        int useTextures = stream.readUnsignedByte();
        int useTrianglePriority = stream.readUnsignedByte();
        int useAlpha = stream.readUnsignedByte();
        int useTriangleSkins = stream.readUnsignedByte();
        int useVertexSkins = stream.readUnsignedByte();
        int dataLengthX = stream.readUShort();
        int dataLengthY = stream.readUShort();
        int dataLengthZ = stream.readUShort();
        int dataLengthTriangle = stream.readUShort();
        modelHeader.vertexDirectionOffset = offset = 0;
        modelHeader.triangleTypeOffset = offset += modelHeader.vertexCount;
        modelHeader.trianglePriorityOffset = offset += modelHeader.triangleCount;
        if (useTrianglePriority == 255) {
            offset += modelHeader.triangleCount;
        } else {
            modelHeader.trianglePriorityOffset = -useTrianglePriority - 1;
        }
        modelHeader.triangleSkinOffset = offset;
        if (useTriangleSkins == 1) {
            offset += modelHeader.triangleCount;
        } else {
            modelHeader.triangleSkinOffset = -1;
        }
        modelHeader.texturePointerOffset = offset;
        if (useTextures == 1) {
            offset += modelHeader.triangleCount;
        } else {
            modelHeader.texturePointerOffset = -1;
        }
        modelHeader.vertexSkinOffset = offset;
        if (useVertexSkins == 1) {
            offset += modelHeader.vertexCount;
        } else {
            modelHeader.vertexSkinOffset = -1;
        }
        modelHeader.triangleAlphaOffset = offset;
        if (useAlpha == 1) {
            offset += modelHeader.triangleCount;
        } else {
            modelHeader.triangleAlphaOffset = -1;
        }
        modelHeader.triangleDataOffset = offset;
        modelHeader.colourDataOffset = offset += dataLengthTriangle;
        modelHeader.texturedTriangleOffset = offset += modelHeader.triangleCount * 2;
        modelHeader.dataOffsetX = offset += modelHeader.texturedTriangleCount * 6;
        modelHeader.dataOffsetY = offset += dataLengthX;
        modelHeader.dataOffsetZ = offset += dataLengthY;
        offset += dataLengthZ;
    }

    public static void init() {
        modelHeaders = new ModelHeader[100000];
        newmodel = new boolean[100000];
    }

    public static void resetModel(int model) {
        Model.modelHeaders[model] = null;
    }

    public static Model getModel(int file) {
        ModelHeader header = modelHeaders[file];
        if (header == null) {
            Client.instance.resourceProvider.provide(0, file);
            return null;
        }
        try {
            return new Model(file);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isCached(int file) {
        if (modelHeaders == null) {
            return false;
        }
        ModelHeader mdl = modelHeaders[file];
        if (mdl == null) {
            Client.instance.resourceProvider.provide(0, file);
            return false;
        }
        return true;
    }

    Model() {
        this.verticesCount = 0;
        this.trianglesCount = 0;
        this.texturesCount = 0;
        this.facePriority = 0;
        this.singleTile = true;
        this.isBoundsCalculated = false;
    }

    public Model(int length, Model[] models) {
        try {
            Model build;
            this.singleTile = false;
            boolean typeFlag = false;
            boolean priorityFlag = false;
            boolean alphaFlag = false;
            boolean tSkinFlag = false;
            boolean colorFlag = false;
            boolean textureFlag = false;
            boolean coordinateFlag = false;
            boolean mergeSkeletalData = false;
            this.verticesCount = 0;
            this.trianglesCount = 0;
            this.texturesCount = 0;
            this.facePriority = (byte)-1;
            for (int count2 = 0; count2 < length; ++count2) {
                build = models[count2];
                if (build == null) continue;
                this.verticesCount += build.verticesCount;
                this.trianglesCount += build.trianglesCount;
                this.texturesCount += build.texturesCount;
                typeFlag |= build.drawType != null;
                alphaFlag |= build.triangleAlpha != null;
                if (build.renderPriorities != null) {
                    priorityFlag = true;
                } else {
                    if (this.facePriority == -1) {
                        this.facePriority = build.facePriority;
                    }
                    if (this.facePriority != build.facePriority) {
                        priorityFlag = true;
                    }
                }
                tSkinFlag |= build.triangleData != null;
                colorFlag |= build.colors != null;
                textureFlag |= build.materials != null;
                coordinateFlag |= build.textures != null;
                mergeSkeletalData |= build.skeletalBones != null;
            }
            this.verticesX = new int[this.verticesCount];
            this.verticesY = new int[this.verticesCount];
            this.verticesZ = new int[this.verticesCount];
            this.vertexData = new int[this.verticesCount];
            this.trianglesX = new int[this.trianglesCount];
            this.trianglesY = new int[this.trianglesCount];
            this.trianglesZ = new int[this.trianglesCount];
            if (colorFlag) {
                this.colors = new short[this.trianglesCount];
            }
            if (typeFlag) {
                this.drawType = new int[this.trianglesCount];
            }
            if (priorityFlag) {
                this.renderPriorities = new byte[this.trianglesCount];
            }
            if (alphaFlag) {
                this.triangleAlpha = new byte[this.trianglesCount];
            }
            if (tSkinFlag) {
                this.triangleData = new int[this.trianglesCount];
            }
            if (mergeSkeletalData) {
                this.skeletalBones = new int[this.verticesCount][];
                this.skeletalScales = new int[this.verticesCount][];
            }
            if (textureFlag) {
                this.materials = new short[this.trianglesCount];
            }
            if (coordinateFlag) {
                this.textures = new byte[this.trianglesCount];
            }
            if (this.texturesCount > 0) {
                this.textureTypes = new byte[this.texturesCount];
                this.texturesX = new int[this.texturesCount];
                this.texturesY = new int[this.texturesCount];
                this.texturesZ = new int[this.texturesCount];
            }
            this.verticesCount = 0;
            this.trianglesCount = 0;
            this.texturesCount = 0;
            int textureFace = 0;
            for (int index = 0; index < length; ++index) {
                build = models[index];
                if (build == null) continue;
                for (int face = 0; face < build.trianglesCount; ++face) {
                    if (typeFlag && build.drawType != null) {
                        this.drawType[this.trianglesCount] = build.drawType[face];
                    }
                    if (priorityFlag) {
                        this.renderPriorities[this.trianglesCount] = build.renderPriorities == null ? build.facePriority : build.renderPriorities[face];
                    }
                    if (alphaFlag && build.triangleAlpha != null) {
                        this.triangleAlpha[this.trianglesCount] = build.triangleAlpha[face];
                    }
                    if (tSkinFlag && build.triangleData != null) {
                        this.triangleData[this.trianglesCount] = build.triangleData[face];
                    }
                    if (textureFlag) {
                        this.materials[this.trianglesCount] = build.materials != null ? build.materials[face] : -1;
                    }
                    if (coordinateFlag) {
                        this.textures[this.trianglesCount] = build.textures != null && build.textures[face] != -1 ? (int)(build.textures[face] + textureFace) : -1;
                    }
                    this.colors[this.trianglesCount] = build.colors[face];
                    this.trianglesX[this.trianglesCount] = this.getFirstIdenticalVertexId(build, build.trianglesX[face]);
                    this.trianglesY[this.trianglesCount] = this.getFirstIdenticalVertexId(build, build.trianglesY[face]);
                    this.trianglesZ[this.trianglesCount] = this.getFirstIdenticalVertexId(build, build.trianglesZ[face]);
                    ++this.trianglesCount;
                }
                for (int textureEdge = 0; textureEdge < build.texturesCount; ++textureEdge) {
                    this.texturesX[this.texturesCount] = (short)this.getFirstIdenticalVertexId(build, build.texturesX[textureEdge]);
                    this.texturesY[this.texturesCount] = (short)this.getFirstIdenticalVertexId(build, build.texturesY[textureEdge]);
                    this.texturesZ[this.texturesCount] = (short)this.getFirstIdenticalVertexId(build, build.texturesZ[textureEdge]);
                    ++this.texturesCount;
                }
                textureFace += build.texturesCount;
            }
            this.vertexNormals();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Model(Model[] models) {
        Model build;
        int currentModel;
        int modelCount = 2;
        this.singleTile = false;
        ++anInt1620;
        boolean renderTypeFlag = false;
        boolean priorityFlag = false;
        boolean alphaFlag = false;
        boolean colorFlag = false;
        boolean textureFlag = false;
        boolean coordinateFlag = false;
        this.verticesCount = 0;
        this.trianglesCount = 0;
        this.texturesCount = 0;
        this.facePriority = (byte)-1;
        for (currentModel = 0; currentModel < modelCount; ++currentModel) {
            build = models[currentModel];
            if (build == null) continue;
            this.verticesCount += build.verticesCount;
            this.trianglesCount += build.trianglesCount;
            this.texturesCount += build.texturesCount;
            renderTypeFlag |= this.drawType != null;
            if (build.renderPriorities != null) {
                priorityFlag = true;
            } else {
                if (this.facePriority == -1) {
                    this.facePriority = build.facePriority;
                }
                if (this.facePriority != build.facePriority) {
                    priorityFlag = true;
                }
            }
            alphaFlag |= build.triangleAlpha != null;
            colorFlag |= build.colors != null;
            textureFlag |= build.materials != null;
            coordinateFlag |= build.textures != null;
        }
        this.verticesX = new int[this.verticesCount];
        this.verticesY = new int[this.verticesCount];
        this.verticesZ = new int[this.verticesCount];
        this.trianglesX = new int[this.trianglesCount];
        this.trianglesY = new int[this.trianglesCount];
        this.trianglesZ = new int[this.trianglesCount];
        this.colorsX = new int[this.trianglesCount];
        this.colorsY = new int[this.trianglesCount];
        this.colorsZ = new int[this.trianglesCount];
        if (renderTypeFlag) {
            this.drawType = new int[this.trianglesCount];
        }
        if (priorityFlag) {
            this.renderPriorities = new byte[this.trianglesCount];
        }
        if (alphaFlag) {
            this.triangleAlpha = new byte[this.trianglesCount];
        }
        if (textureFlag) {
            this.materials = new short[this.trianglesCount];
        }
        if (coordinateFlag) {
            this.textures = new byte[this.trianglesCount];
        }
        if (this.texturesCount > 0) {
            this.textureTypes = new byte[this.texturesCount];
            this.texturesX = new int[this.texturesCount];
            this.texturesY = new int[this.texturesCount];
            this.texturesZ = new int[this.texturesCount];
        }
        if (colorFlag) {
            this.colors = new short[this.trianglesCount];
        }
        this.verticesCount = 0;
        this.trianglesCount = 0;
        this.texturesCount = 0;
        for (currentModel = 0; currentModel < modelCount; ++currentModel) {
            build = models[currentModel];
            if (build == null) continue;
            int vertex = this.verticesCount;
            for (int point = 0; point < build.verticesCount; ++point) {
                this.verticesX[this.verticesCount] = build.verticesX[point];
                this.verticesY[this.verticesCount] = build.verticesY[point];
                this.verticesZ[this.verticesCount] = build.verticesZ[point];
                ++this.verticesCount;
            }
            for (int face = 0; face < build.trianglesCount; ++face) {
                this.trianglesX[this.trianglesCount] = build.trianglesX[face] + vertex;
                this.trianglesY[this.trianglesCount] = build.trianglesY[face] + vertex;
                this.trianglesZ[this.trianglesCount] = build.trianglesZ[face] + vertex;
                try {
                    this.colorsX[this.trianglesCount] = build.colorsX[face];
                    this.colorsY[this.trianglesCount] = build.colorsY[face];
                    this.colorsZ[this.trianglesCount] = build.colorsZ[face];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.colors[this.trianglesCount] = build.colors[face];
                if (renderTypeFlag && build.drawType != null) {
                    this.drawType[this.trianglesCount] = build.drawType[face];
                }
                if (alphaFlag && build.triangleAlpha != null) {
                    this.triangleAlpha[this.trianglesCount] = build.triangleAlpha[face];
                }
                if (priorityFlag) {
                    this.renderPriorities[this.trianglesCount] = build.renderPriorities == null ? build.facePriority : build.renderPriorities[face];
                }
                if (colorFlag && build.colors != null) {
                    this.colors[this.trianglesCount] = build.colors[face];
                }
                if (textureFlag) {
                    this.materials[this.trianglesCount] = build.materials != null ? build.materials[face] : -1;
                }
                if (coordinateFlag) {
                    this.textures[this.trianglesCount] = build.textures != null && build.textures[face] != -1 ? (int)(build.textures[face] + this.texturesCount) : -1;
                }
                ++this.trianglesCount;
            }
            try {
                for (int texture = 0; texture < build.texturesCount && this.texturesX.length != this.texturesCount && build.texturesX.length != this.texturesCount; ++texture) {
                    this.texturesX[this.texturesCount] = (short)(build.texturesX[texture] + vertex);
                    this.texturesY[this.texturesCount] = (short)(build.texturesY[texture] + vertex);
                    this.texturesZ[this.texturesCount] = (short)(build.texturesZ[texture] + vertex);
                    ++this.texturesCount;
                }
                this.texturesCount += build.texturesCount;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.calculateBoundsCylinder();
        this.resetBounds();
    }

    public Model(boolean colorFlag, boolean alphaFlag, boolean animated, Model model) {
        this(colorFlag, alphaFlag, animated, false, model);
    }

    public Model(boolean colorFlag, boolean alphaFlag, boolean animated, boolean textureFlag, Model model) {
        this.singleTile = false;
        this.verticesCount = model.verticesCount;
        this.trianglesCount = model.trianglesCount;
        this.texturesCount = model.texturesCount;
        if (animated) {
            this.verticesX = model.verticesX;
            this.verticesY = model.verticesY;
            this.verticesZ = model.verticesZ;
        } else {
            this.verticesX = new int[this.verticesCount];
            this.verticesY = new int[this.verticesCount];
            this.verticesZ = new int[this.verticesCount];
            for (int point = 0; point < this.verticesCount; ++point) {
                this.verticesX[point] = model.verticesX[point];
                this.verticesY[point] = model.verticesY[point];
                this.verticesZ[point] = model.verticesZ[point];
            }
        }
        if (colorFlag) {
            this.colors = model.colors;
        } else {
            this.colors = new short[this.trianglesCount];
            System.arraycopy(model.colors, 0, this.colors, 0, this.trianglesCount);
        }
        if (!textureFlag && model.materials != null) {
            this.materials = new short[this.trianglesCount];
            System.arraycopy(model.materials, 0, this.materials, 0, this.trianglesCount);
        } else {
            this.materials = model.materials;
        }
        if (alphaFlag) {
            this.triangleAlpha = model.triangleAlpha;
        } else {
            this.triangleAlpha = new byte[this.trianglesCount];
            if (model.triangleAlpha == null) {
                for (int l = 0; l < this.trianglesCount; ++l) {
                    this.triangleAlpha[l] = 0;
                }
            } else {
                System.arraycopy(model.triangleAlpha, 0, this.triangleAlpha, 0, this.trianglesCount);
            }
        }
        this.vertexData = model.vertexData;
        this.triangleData = model.triangleData;
        this.drawType = model.drawType;
        this.trianglesX = model.trianglesX;
        this.trianglesY = model.trianglesY;
        this.trianglesZ = model.trianglesZ;
        this.renderPriorities = model.renderPriorities;
        this.facePriority = model.facePriority;
        this.texturesX = model.texturesX;
        this.texturesY = model.texturesY;
        this.texturesZ = model.texturesZ;
        this.textures = model.textures;
        this.textureTypes = model.textureTypes;
        this.normals = model.normals;
        this.faceNormals = model.faceNormals;
        this.skeletalBones = model.skeletalBones;
        this.skeletalScales = model.skeletalScales;
        this.vertexNormalsOffsets = model.vertexNormalsOffsets;
    }

    public Model(boolean resetVertices, boolean resetColors, Model model) {
        this.singleTile = false;
        this.verticesCount = model.verticesCount;
        this.trianglesCount = model.trianglesCount;
        this.texturesCount = model.texturesCount;
        if (resetVertices) {
            this.verticesY = new int[this.verticesCount];
            for (int j = 0; j < this.verticesCount; ++j) {
                this.verticesY[j] = model.verticesY[j];
            }
        } else {
            this.verticesY = model.verticesY;
        }
        if (resetColors) {
            int face;
            this.colorsX = new int[this.trianglesCount];
            this.colorsY = new int[this.trianglesCount];
            this.colorsZ = new int[this.trianglesCount];
            for (face = 0; face < this.trianglesCount; ++face) {
                this.colorsX[face] = model.colorsX[face];
                this.colorsY[face] = model.colorsY[face];
                this.colorsZ[face] = model.colorsZ[face];
            }
            this.drawType = new int[this.trianglesCount];
            if (model.drawType == null) {
                for (face = 0; face < this.trianglesCount; ++face) {
                    this.drawType[face] = 0;
                }
            } else {
                System.arraycopy(model.drawType, 0, this.drawType, 0, this.trianglesCount);
            }
        } else {
            this.colorsX = model.colorsX;
            this.colorsY = model.colorsY;
            this.colorsZ = model.colorsZ;
            this.drawType = model.drawType;
        }
        this.verticesX = model.verticesX;
        this.verticesZ = model.verticesZ;
        this.colors = model.colors;
        this.triangleAlpha = model.triangleAlpha;
        this.renderPriorities = model.renderPriorities;
        this.facePriority = model.facePriority;
        this.trianglesX = model.trianglesX;
        this.trianglesY = model.trianglesY;
        this.trianglesZ = model.trianglesZ;
        this.texturesX = model.texturesX;
        this.texturesY = model.texturesY;
        this.texturesZ = model.texturesZ;
        this.modelBaseY = model.modelBaseY;
        this.textures = model.textures;
        this.materials = model.materials;
        this.diagonal2DAboveOrigin = model.diagonal2DAboveOrigin;
        this.diagonal3DAboveOrigin = model.diagonal3DAboveOrigin;
        this.diagonal3D = model.diagonal3D;
        this.minX = model.minX;
        this.maxZ = model.maxZ;
        this.minZ = model.minZ;
        this.maxX = model.maxX;
        this.vertexNormalsX = model.vertexNormalsX;
        this.vertexNormalsY = model.vertexNormalsY;
        this.vertexNormalsZ = model.vertexNormalsZ;
        this.faceTextureUVCoordinates = model.faceTextureUVCoordinates;
    }

    public void buildSharedSequenceModel(Model model, boolean replaceAlpha) {
        this.verticesCount = model.verticesCount;
        this.trianglesCount = model.trianglesCount;
        this.texturesCount = model.texturesCount;
        if (sharedVerticesX.length < this.verticesCount) {
            sharedVerticesX = new int[this.verticesCount + 100];
            sharedVerticesY = new int[this.verticesCount + 100];
            sharedVerticesZ = new int[this.verticesCount + 100];
        }
        this.verticesX = sharedVerticesX;
        this.verticesY = sharedVerticesY;
        this.verticesZ = sharedVerticesZ;
        for (int point = 0; point < this.verticesCount; ++point) {
            this.verticesX[point] = model.verticesX[point];
            this.verticesY[point] = model.verticesY[point];
            this.verticesZ[point] = model.verticesZ[point];
        }
        if (replaceAlpha) {
            this.triangleAlpha = model.triangleAlpha;
        } else {
            if (sharedTriangleAlpha.length < this.trianglesCount) {
                sharedTriangleAlpha = new byte[this.trianglesCount + 100];
            }
            this.triangleAlpha = sharedTriangleAlpha;
            if (model.triangleAlpha == null) {
                for (int face = 0; face < this.trianglesCount; ++face) {
                    this.triangleAlpha[face] = 0;
                }
            } else {
                System.arraycopy(model.triangleAlpha, 0, this.triangleAlpha, 0, this.trianglesCount);
            }
        }
        this.drawType = model.drawType;
        this.colors = model.colors;
        this.renderPriorities = model.renderPriorities;
        this.facePriority = model.facePriority;
        this.groupedTriangleLabels = model.groupedTriangleLabels;
        this.groupedVertexLabels = model.groupedVertexLabels;
        this.trianglesX = model.trianglesX;
        this.trianglesY = model.trianglesY;
        this.trianglesZ = model.trianglesZ;
        this.colorsX = model.colorsX;
        this.colorsY = model.colorsY;
        this.skeletalBones = model.skeletalBones;
        this.skeletalScales = model.skeletalScales;
        this.colorsZ = model.colorsZ;
        this.texturesX = model.texturesX;
        this.texturesY = model.texturesY;
        this.texturesZ = model.texturesZ;
        this.textures = model.textures;
        this.textureTypes = model.textureTypes;
        this.materials = model.materials;
        this.vertexNormalsOffsets = model.vertexNormalsOffsets;
        this.vertexNormalsX = model.vertexNormalsX;
        this.vertexNormalsY = model.vertexNormalsY;
        this.vertexNormalsZ = model.vertexNormalsZ;
        model.resetBounds();
    }

    private int getFirstIdenticalVertexId(Model model, int vertex) {
        int vertexId = -1;
        int x = model.verticesX[vertex];
        int y = model.verticesY[vertex];
        int z = model.verticesZ[vertex];
        for (int v = 0; v < this.verticesCount; ++v) {
            if (x != this.verticesX[v] || y != this.verticesY[v] || z != this.verticesZ[v]) continue;
            vertexId = v;
            break;
        }
        if (vertexId == -1) {
            this.verticesX[this.verticesCount] = x;
            this.verticesY[this.verticesCount] = y;
            this.verticesZ[this.verticesCount] = z;
            if (model.vertexData != null) {
                this.vertexData[this.verticesCount] = model.vertexData[vertex];
            }
            if (model.skeletalBones != null) {
                this.skeletalBones[this.verticesCount] = model.skeletalBones[vertex];
                this.skeletalScales[this.verticesCount] = model.skeletalScales[vertex];
            }
            vertexId = this.verticesCount++;
        }
        return vertexId;
    }

    @Override
    public void calculateBoundsCylinder() {
        if (this.boundsType != 1) {
            this.boundsType = 1;
            this.modelBaseY = 0;
            this.diagonal2DAboveOrigin = 0;
            this.maxY = 0;
            for (int vertex = 0; vertex < this.verticesCount; ++vertex) {
                int bounds;
                int x = this.verticesX[vertex];
                int y = this.verticesY[vertex];
                int z = this.verticesZ[vertex];
                if (-y > this.modelBaseY) {
                    this.modelBaseY = -y;
                }
                if (y > this.maxY) {
                    this.maxY = y;
                }
                if ((bounds = x * x + z * z) <= this.diagonal2DAboveOrigin) continue;
                this.diagonal2DAboveOrigin = bounds;
            }
            this.diagonal2DAboveOrigin = (int)(Math.sqrt(this.diagonal2DAboveOrigin) + 0.99);
            this.diagonal3DAboveOrigin = (int)(Math.sqrt(this.diagonal2DAboveOrigin * this.diagonal2DAboveOrigin + this.modelBaseY * this.modelBaseY) + 0.99);
            this.diagonal3D = this.diagonal3DAboveOrigin + (int)(Math.sqrt(this.diagonal2DAboveOrigin * this.diagonal2DAboveOrigin + this.maxY * this.maxY) + 0.99);
        }
    }

    void calculateDiagonals() {
        if (this.boundsType != 2) {
            this.boundsType = 2;
            this.diagonal2DAboveOrigin = 0;
            for (int count2 = 0; count2 < this.verticesCount; ++count2) {
                int x = this.verticesX[count2];
                int z = this.verticesZ[count2];
                int y = this.verticesY[count2];
                int bounds = x * x + z * z + y * y;
                if (bounds <= this.diagonal2DAboveOrigin) continue;
                this.diagonal2DAboveOrigin = bounds;
            }
            this.diagonal3DAboveOrigin = this.diagonal2DAboveOrigin = (int)(Math.sqrt(this.diagonal2DAboveOrigin) + 0.99);
            this.diagonal3D = this.diagonal2DAboveOrigin + this.diagonal2DAboveOrigin;
        }
    }

    public void normalise() {
        this.modelBaseY = 0;
        this.maxY = 0;
        for (int vertex = 0; vertex < this.verticesCount; ++vertex) {
            int y = this.verticesY[vertex];
            if (-y > this.modelBaseY) {
                this.modelBaseY = -y;
            }
            if (y <= this.maxY) continue;
            this.maxY = y;
        }
        this.diagonal3DAboveOrigin = (int)(Math.sqrt(this.diagonal2DAboveOrigin * this.diagonal2DAboveOrigin + this.modelBaseY * this.modelBaseY) + 0.99);
        this.diagonal3D = this.diagonal3DAboveOrigin + (int)(Math.sqrt(this.diagonal2DAboveOrigin * this.diagonal2DAboveOrigin + this.maxY * this.maxY) + 0.99);
    }

    public Model method1121(int[][] var1, int var2, int var3, int var4, boolean var5, int var6) {
        this.calculateBounds();
        int var7 = var2 + this.minX;
        int var8 = var2 + this.maxX;
        int var9 = var4 + this.maxZ;
        int var10 = var4 + this.minZ;
        if (var7 >= 0 && var8 + 128 >> 7 < var1.length && var9 >= 0 && var10 + 128 >> 7 < var1[0].length) {
            var8 = var8 + 127 >> 7;
            var10 = var10 + 127 >> 7;
            if (var3 == var1[var7 >>= 7][var9 >>= 7] && var3 == var1[var8][var9] && var3 == var1[var7][var10] && var3 == var1[var8][var10]) {
                return this;
            }
            Model var11 = new Model();
            var11.verticesCount = this.verticesCount;
            var11.trianglesCount = this.trianglesCount;
            var11.texturesCount = this.texturesCount;
            var11.verticesX = this.verticesX;
            var11.verticesZ = this.verticesZ;
            var11.trianglesX = this.trianglesX;
            var11.trianglesY = this.trianglesY;
            var11.trianglesZ = this.trianglesZ;
            var11.drawType = this.drawType;
            var11.renderPriorities = this.renderPriorities;
            var11.triangleAlpha = this.triangleAlpha;
            var11.textures = this.textures;
            var11.colors = this.colors;
            var11.materials = this.materials;
            var11.facePriority = this.facePriority;
            var11.textureTypes = this.textureTypes;
            var11.texturesX = this.texturesX;
            var11.texturesY = this.texturesY;
            var11.texturesZ = this.texturesZ;
            var11.vertexData = this.vertexData;
            var11.triangleData = this.triangleData;
            var11.groupedVertexLabels = this.groupedVertexLabels;
            var11.groupedTriangleLabels = this.groupedTriangleLabels;
            var11.ambient = this.ambient;
            var11.contrast = this.contrast;
            var11.verticesY = new int[var11.verticesCount];
            if (var6 == 0) {
                for (int var12 = 0; var12 < var11.verticesCount; ++var12) {
                    int var13 = var2 + this.verticesX[var12];
                    int var14 = var4 + this.verticesZ[var12];
                    int var15 = var13 & 0x7F;
                    int var16 = var14 & 0x7F;
                    int var17 = var13 >> 7;
                    int var18 = var14 >> 7;
                    int var19 = var1[var17][var18] * (128 - var15) + var1[var17 + 1][var18] * var15 >> 7;
                    int var20 = var1[var17][var18 + 1] * (128 - var15) + var15 * var1[var17 + 1][var18 + 1] >> 7;
                    int var21 = var19 * (128 - var16) + var20 * var16 >> 7;
                    var11.verticesY[var12] = var21 + this.verticesY[var12] - var3;
                }
            } else {
                for (int var12 = 0; var12 < var11.verticesCount; ++var12) {
                    int var13 = (-this.verticesY[var12] << 16) / this.modelBaseY;
                    if (var13 >= var6) continue;
                    int var14 = var2 + this.verticesX[var12];
                    int var15 = var4 + this.verticesZ[var12];
                    int var16 = var14 & 0x7F;
                    int var17 = var15 & 0x7F;
                    int var18 = var14 >> 7;
                    int var19 = var15 >> 7;
                    int var20 = var1[var18][var19] * (128 - var16) + var1[var18 + 1][var19] * var16 >> 7;
                    int var21 = var1[var18][var19 + 1] * (128 - var16) + var16 * var1[var18 + 1][var19 + 1] >> 7;
                    int var22 = var20 * (128 - var17) + var21 * var17 >> 7;
                    var11.verticesY[var12] = (var6 - var13) * (var22 - var3) / var6 + this.verticesY[var12];
                }
            }
            var11.invalidate();
            return var11;
        }
        return this;
    }

    public void calculateBounds() {
        if (!this.isBoundsCalculated) {
            this.modelBaseY = 0;
            this.diagonal2DAboveOrigin = 0;
            this.maxY = 0;
            this.minX = 999999;
            this.maxX = -999999;
            this.maxZ = -99999;
            this.minZ = 99999;
            for (int vertex = 0; vertex < this.verticesCount; ++vertex) {
                int bounds;
                int x = this.verticesX[vertex];
                int y = this.verticesY[vertex];
                int z = this.verticesZ[vertex];
                if (x < this.minX) {
                    this.minX = x;
                }
                if (x > this.maxX) {
                    this.maxX = x;
                }
                if (z < this.minZ) {
                    this.minZ = z;
                }
                if (z > this.maxZ) {
                    this.maxZ = z;
                }
                if (-y > this.modelBaseY) {
                    this.modelBaseY = -y;
                }
                if (y > this.maxY) {
                    this.maxY = y;
                }
                if ((bounds = x * x + z * z) <= this.diagonal2DAboveOrigin) continue;
                this.diagonal2DAboveOrigin = bounds;
            }
            this.isBoundsCalculated = true;
        }
    }

    public void generateBones() {
        if (this.vertexData != null) {
            int[] ai = new int[256];
            int j = 0;
            for (int l = 0; l < this.verticesCount; ++l) {
                int j1;
                int n = j1 = this.vertexData[l];
                ai[n] = ai[n] + 1;
                if (j1 <= j) continue;
                j = j1;
            }
            this.groupedVertexLabels = new int[j + 1][];
            for (int k1 = 0; k1 <= j; ++k1) {
                this.groupedVertexLabels[k1] = new int[ai[k1]];
                ai[k1] = 0;
            }
            int j2 = 0;
            while (j2 < this.verticesCount) {
                int l2;
                int n = l2 = this.vertexData[j2];
                int n2 = ai[n];
                ai[n] = n2 + 1;
                this.groupedVertexLabels[l2][n2] = j2++;
            }
        }
        if (this.triangleData != null) {
            int[] ai1 = new int[256];
            int k = 0;
            for (int i1 = 0; i1 < this.trianglesCount; ++i1) {
                int l1;
                int n = l1 = this.triangleData[i1];
                ai1[n] = ai1[n] + 1;
                if (l1 <= k) continue;
                k = l1;
            }
            this.groupedTriangleLabels = new int[k + 1][];
            for (int uid = 0; uid <= k; ++uid) {
                this.groupedTriangleLabels[uid] = new int[ai1[uid]];
                ai1[uid] = 0;
            }
            int k2 = 0;
            while (k2 < this.trianglesCount) {
                int i3;
                int n = i3 = this.triangleData[k2];
                int n3 = ai1[n];
                ai1[n] = n3 + 1;
                this.groupedTriangleLabels[i3][n3] = k2++;
            }
        }
    }

    private void transform(int animationType, int[] skin, int x, int y, int z) {
        int i1 = skin.length;
        if (animationType == 0) {
            int j1 = 0;
            xAnimOffset = 0;
            yAnimOffset = 0;
            zAnimOffset = 0;
            for (int l3 : skin) {
                int[] ai5;
                if (l3 >= this.groupedVertexLabels.length) continue;
                for (int j6 : ai5 = this.groupedVertexLabels[l3]) {
                    xAnimOffset += this.verticesX[j6];
                    yAnimOffset += this.verticesY[j6];
                    zAnimOffset += this.verticesZ[j6];
                    ++j1;
                }
            }
            if (j1 > 0) {
                xAnimOffset = xAnimOffset / j1 + x;
                yAnimOffset = yAnimOffset / j1 + y;
                zAnimOffset = zAnimOffset / j1 + z;
                return;
            }
            xAnimOffset = x;
            yAnimOffset = y;
            zAnimOffset = z;
            return;
        }
        if (animationType == 1) {
            for (int l2 : skin) {
                int[] ai1;
                if (l2 >= this.groupedVertexLabels.length) continue;
                int[] nArray = ai1 = this.groupedVertexLabels[l2];
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int j5;
                    int n2 = j5 = nArray[i];
                    this.verticesX[n2] = this.verticesX[n2] + x;
                    int n3 = j5;
                    this.verticesY[n3] = this.verticesY[n3] + y;
                    int n4 = j5;
                    this.verticesZ[n4] = this.verticesZ[n4] + z;
                }
            }
            return;
        }
        if (animationType == 2) {
            for (int i3 : skin) {
                int[] ai2;
                if (i3 >= this.groupedVertexLabels.length) continue;
                int[] nArray = ai2 = this.groupedVertexLabels[i3];
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int k5;
                    int n5 = k5 = nArray[i];
                    this.verticesX[n5] = this.verticesX[n5] - xAnimOffset;
                    int n6 = k5;
                    this.verticesY[n6] = this.verticesY[n6] - yAnimOffset;
                    int n7 = k5;
                    this.verticesZ[n7] = this.verticesZ[n7] - zAnimOffset;
                    int k6 = x;
                    int l6 = y;
                    int i7 = z;
                    if (i7 != 0) {
                        int j7 = SINE[i7 &= 0x7FF];
                        int i8 = COSINE[i7];
                        int l8 = this.verticesY[k5] * j7 + this.verticesX[k5] * i8 >> 16;
                        this.verticesY[k5] = this.verticesY[k5] * i8 - this.verticesX[k5] * j7 >> 16;
                        this.verticesX[k5] = l8;
                    }
                    if (k6 != 0) {
                        int k7 = SINE[k6 &= 0x7FF];
                        int j8 = COSINE[k6];
                        int i9 = this.verticesY[k5] * j8 - this.verticesZ[k5] * k7 >> 16;
                        this.verticesZ[k5] = this.verticesY[k5] * k7 + this.verticesZ[k5] * j8 >> 16;
                        this.verticesY[k5] = i9;
                    }
                    if (l6 != 0) {
                        int l7 = SINE[l6 &= 0x7FF];
                        int k8 = COSINE[l6];
                        int j9 = this.verticesZ[k5] * l7 + this.verticesX[k5] * k8 >> 16;
                        this.verticesZ[k5] = this.verticesZ[k5] * k8 - this.verticesX[k5] * l7 >> 16;
                        this.verticesX[k5] = j9;
                    }
                    int n8 = k5;
                    this.verticesX[n8] = this.verticesX[n8] + xAnimOffset;
                    int n9 = k5;
                    this.verticesY[n9] = this.verticesY[n9] + yAnimOffset;
                    int n10 = k5;
                    this.verticesZ[n10] = this.verticesZ[n10] + zAnimOffset;
                }
            }
            return;
        }
        if (animationType == 3) {
            for (int j3 : skin) {
                int[] ai3;
                if (j3 >= this.groupedVertexLabels.length) continue;
                int[] nArray = ai3 = this.groupedVertexLabels[j3];
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int l5;
                    int n11 = l5 = nArray[i];
                    this.verticesX[n11] = this.verticesX[n11] - xAnimOffset;
                    int n12 = l5;
                    this.verticesY[n12] = this.verticesY[n12] - yAnimOffset;
                    int n13 = l5;
                    this.verticesZ[n13] = this.verticesZ[n13] - zAnimOffset;
                    this.verticesX[l5] = this.verticesX[l5] * x / 128;
                    this.verticesY[l5] = this.verticesY[l5] * y / 128;
                    this.verticesZ[l5] = this.verticesZ[l5] * z / 128;
                    int n14 = l5;
                    this.verticesX[n14] = this.verticesX[n14] + xAnimOffset;
                    int n15 = l5;
                    this.verticesY[n15] = this.verticesY[n15] + yAnimOffset;
                    int n16 = l5;
                    this.verticesZ[n16] = this.verticesZ[n16] + zAnimOffset;
                }
            }
            return;
        }
        if (animationType == 5 && this.groupedTriangleLabels != null && this.triangleAlpha != null) {
            for (int k3 : skin) {
                int[] ai4;
                if (k3 >= this.groupedTriangleLabels.length) continue;
                for (int i6 : ai4 = this.groupedTriangleLabels[k3]) {
                    int i = (this.triangleAlpha[i6] & 0xFF) + x * 8;
                    if (i < 0) {
                        i = 0;
                    } else if (i > 255) {
                        i = 255;
                    }
                    this.triangleAlpha[i6] = (byte)i;
                }
            }
        }
    }

    public void playSkeletal(SeqDefinition seqDefinition, int tick) {
        int skeletalId = seqDefinition.getSkeletalId();
        Index frameIndex = SeqFrameDefs.getFrameIndex();
        Index baseIndex = SeqBaseDefs.getBaseIndex();
        SkaFSet skeletalFrameset = SkaFSet.getSkaf(frameIndex, baseIndex, skeletalId);
        this.transformSkeletal(skeletalFrameset, tick);
    }

    public void transformSkeletal(SkaFSet skaFSet, int tick) {
        SeqBase base = skaFSet.seqBase;
        ABW ABW2 = base.getABW();
        if (ABW2 != null) {
            base.getABW().ut(skaFSet, tick);
            this.transformSkeletal(base.getABW(), skaFSet.getFid());
        }
        if (skaFSet.hExisting()) {
            this.applyAlphaTransforms(skaFSet, tick);
        }
    }

    public void playSkeletalDouble(SeqDefinition primary, SeqDefinition secondary, int primaryTick, int secondaryTick) {
        int primarySkeletalId = primary.getSkeletalId();
        int secondarySkeletalId = secondary.getSkeletalId();
        Index frameIndex = SeqFrameDefs.getFrameIndex();
        Index baseIndex = SeqBaseDefs.getBaseIndex();
        SkaFSet primarySkeletalFrameset = SkaFSet.getSkaf(frameIndex, baseIndex, primarySkeletalId);
        SkaFSet secondarySkeletalFrameset = SkaFSet.getSkaf(frameIndex, baseIndex, secondarySkeletalId);
        boolean[] mask = primary.getBooleanMasks();
        SeqBase base = primarySkeletalFrameset.seqBase;
        this.transformSkeletalMultiple(base, primarySkeletalFrameset, primaryTick, mask, false, !secondary.isSkeletalAnimation());
        this.transformSkeletalMultiple(base, secondarySkeletalFrameset, secondaryTick, mask, true, true);
    }

    private void transformVertex(int vertex, Matrix4f bm) {
        float x = this.verticesX[vertex];
        float y = -this.verticesY[vertex];
        float z = -this.verticesZ[vertex];
        float w = 1.0f;
        int newX = (int)(bm.values[0] * x + bm.values[4] * y + bm.values[8] * z + bm.values[12] * w);
        int newY = -((int)(bm.values[1] * x + bm.values[5] * y + bm.values[9] * z + bm.values[13] * w));
        int newZ = -((int)(bm.values[2] * x + bm.values[6] * y + bm.values[10] * z + bm.values[14] * w));
        this.verticesX[vertex] = newX;
        this.verticesY[vertex] = newY;
        this.verticesZ[vertex] = newZ;
    }

    private void transformSkeletal(ABW animBoneWrapper, int frameId) {
        if (this.skeletalBones == null) {
            return;
        }
        for (int vertex = 0; vertex < this.verticesCount; ++vertex) {
            int[] bonesForVertex = this.skeletalBones[vertex];
            if (bonesForVertex == null || bonesForVertex.length == 0) continue;
            int[] scalesForVertex = this.skeletalScales[vertex];
            fbm.zero();
            for (int i = 0; i < bonesForVertex.length; ++i) {
                int bi = bonesForVertex[i];
                AB bone = animBoneWrapper.getAB(bi);
                if (bone == null) continue;
                sm.sc((float)scalesForVertex[i] / 255.0f);
                cbm.sf(bone.gcbm(frameId));
                cbm.mp(sm);
                fbm.a(cbm);
            }
            this.transformVertex(vertex, fbm);
        }
    }

    public void transformSkeletalMultiple(SeqBase base, SkaFSet skaFSet, int tick, boolean[] mask, boolean state, boolean hasSkeletalAnimations) {
        ABW boneAnimationWrapper = base.getABW();
        if (boneAnimationWrapper != null) {
            boneAnimationWrapper.ut(skaFSet, tick, mask, state);
            if (hasSkeletalAnimations) {
                this.transformSkeletal(boneAnimationWrapper, skaFSet.getFid());
            }
        }
        if (!state && skaFSet.hExisting()) {
            this.applyAlphaTransforms(skaFSet, tick);
        }
    }

    private void applyAlphaTransforms(SkaFSet skaFSet, int tick) {
        SeqBase base = skaFSet.seqBase;
        for (int baseIndex = 0; baseIndex < base.getLength(); ++baseIndex) {
            int[] vertexLabels;
            int type2 = base.getTypes()[baseIndex];
            if (type2 != 5 || skaFSet.tt == null || skaFSet.tt[baseIndex] == null || skaFSet.tt[baseIndex][0] == null || this.groupedTriangleLabels == null || this.triangleAlpha == null) continue;
            TO TO2 = skaFSet.tt[baseIndex][0];
            for (int label : vertexLabels = base.getGroupLabels()[baseIndex]) {
                int[] triangleLabels;
                if (label >= this.groupedTriangleLabels.length) continue;
                for (int triangleIndex : triangleLabels = this.groupedTriangleLabels[label]) {
                    int alpha = (int)((float)(this.triangleAlpha[triangleIndex] & 0xFF) + TO2.gv(tick) * 255.0f);
                    if (alpha < 0) {
                        alpha = 0;
                    } else if (alpha > 255) {
                        alpha = 255;
                    }
                    this.triangleAlpha[triangleIndex] = (byte)alpha;
                }
            }
        }
    }

    public void interpolate(int frameId) {
        if (this.groupedVertexLabels == null) {
            return;
        }
        if (frameId == -1) {
            return;
        }
        SeqFrame frame = SeqFrame.get(frameId);
        if (frame == null) {
            return;
        }
        SeqBase base = frame.getBase();
        xAnimOffset = 0;
        yAnimOffset = 0;
        zAnimOffset = 0;
        for (int index = 0; index < frame.getBaseCount(); ++index) {
            int pos = frame.getBases()[index];
            this.transform(base.getTypes()[pos], base.getGroupLabels()[pos], frame.getXModifier()[index], frame.getYModifier()[index], frame.getZModifier()[index]);
        }
        this.resetBounds();
        this.invalidate();
    }

    public void mix(int[] label, int idle, int current) {
        if (current != -1) {
            if (label != null && idle != -1) {
                int condition;
                int var11;
                SeqFrame anim = SeqFrame.get(current);
                if (anim == null) {
                    return;
                }
                SeqFrame skin = SeqFrame.get(idle);
                if (skin == null) {
                    this.interpolate(current);
                    return;
                }
                SeqBase list = anim.getBase();
                xAnimOffset = 0;
                yAnimOffset = 0;
                zAnimOffset = 0;
                int idOffset = 0;
                int id = idOffset + 1;
                int table = label[id++];
                for (var11 = 0; var11 < anim.getBaseCount(); ++var11) {
                    condition = anim.getBases()[var11];
                    while (condition > table) {
                        table = label[id++];
                    }
                    if (condition == table && list.getTypes()[condition] != 0) continue;
                    this.transform(list.getTypes()[condition], list.getGroupLabels()[condition], anim.getXModifier()[var11], anim.getYModifier()[var11], anim.getZModifier()[var11]);
                }
                xAnimOffset = 0;
                yAnimOffset = 0;
                zAnimOffset = 0;
                idOffset = 0;
                id = idOffset + 1;
                table = label[id++];
                for (var11 = 0; var11 < skin.getBaseCount(); ++var11) {
                    condition = skin.getBases()[var11];
                    while (condition > table) {
                        table = label[id++];
                    }
                    if (condition != table && list.getTypes()[condition] != 0) continue;
                    this.transform(list.getTypes()[condition], list.getGroupLabels()[condition], skin.getXModifier()[var11], skin.getYModifier()[var11], skin.getZModifier()[var11]);
                }
                this.resetBounds();
                this.invalidate();
            } else {
                this.interpolate(current);
            }
        }
    }

    public void rotate90Degrees() {
        for (int vertex = 0; vertex < this.verticesCount; ++vertex) {
            int x = this.verticesX[vertex];
            this.verticesX[vertex] = this.verticesZ[vertex];
            this.verticesZ[vertex] = -x;
        }
        this.resetBounds();
        this.invalidate();
    }

    public void rotateZ(int factor) {
        int sin = SINE[factor];
        int cos = COSINE[factor];
        for (int point = 0; point < this.verticesCount; ++point) {
            int y = this.verticesY[point] * cos - this.verticesZ[point] * sin >> 16;
            this.verticesZ[point] = this.verticesY[point] * sin + this.verticesZ[point] * cos >> 16;
            this.verticesY[point] = y;
        }
        this.resetBounds();
        this.invalidate();
    }

    public void offsetBy(int x, int y, int z) {
        int point = 0;
        while (point < this.verticesCount) {
            int n = point;
            this.verticesX[n] = this.verticesX[n] + x;
            int n2 = point;
            this.verticesY[n2] = this.verticesY[n2] + y;
            int n3 = point++;
            this.verticesZ[n3] = this.verticesZ[n3] + z;
        }
        this.resetBounds();
        this.invalidate();
    }

    public Model recolor(int found, int replace) {
        if (this.colors != null) {
            for (int face = 0; face < this.trianglesCount; ++face) {
                if (this.colors[face] != (short)found) continue;
                this.colors[face] = (short)replace;
            }
        }
        return this;
    }

    @Override
    public net.runelite.api.Model recolor(short found, short replace) {
        if (this.colors != null) {
            for (int face = 0; face < this.trianglesCount; ++face) {
                if (this.colors[face] != found) continue;
                this.colors[face] = replace;
            }
        }
        return this;
    }

    @Override
    public net.runelite.api.Model light(int i, int i1, int defaultX, int defaultY, int defaultZ) {
        return this.light(i, i1, defaultX, defaultY, defaultZ, true);
    }

    public void recolorShort(short[] found, short[] replace) {
        if (this.colors != null) {
            for (int face = 0; face < this.trianglesCount; ++face) {
                if (this.colors[face] != found[0]) continue;
                this.colors[face] = replace[0];
            }
        }
    }

    public void retexture(short found, short replace) {
        if (this.materials != null) {
            for (int face = 0; face < this.trianglesCount; ++face) {
                if (this.materials[face] != found) continue;
                this.materials[face] = replace;
            }
        }
    }

    public void shadingRecolor4(int j) {
        for (int k = 0; k < this.trianglesCount; ++k) {
            if (j == 222) {
                System.out.println("k = " + this.colors[k]);
            }
            if (this.colors[k] == 65535 || k + j < 0) continue;
            int n = k;
            this.colors[n] = (short)(this.colors[n] + j);
        }
    }

    public void mirror() {
        for (int vertex = 0; vertex < this.verticesCount; ++vertex) {
            this.verticesZ[vertex] = -this.verticesZ[vertex];
        }
        for (int face = 0; face < this.trianglesCount; ++face) {
            int newTriangleZ = this.trianglesX[face];
            this.trianglesX[face] = this.trianglesZ[face];
            this.trianglesZ[face] = newTriangleZ;
        }
    }

    @Override
    public Model scale(int x, int z, int y) {
        for (int index = 0; index < this.verticesCount; ++index) {
            this.verticesX[index] = this.verticesX[index] * x / 128;
            this.verticesY[index] = this.verticesY[index] * y / 128;
            this.verticesZ[index] = this.verticesZ[index] * z / 128;
        }
        this.resetBounds();
        this.invalidate();
        return this;
    }

    @Override
    public net.runelite.api.Model translate(int i, int i1, int i2) {
        this.offsetBy(i, i1, i2);
        return this;
    }

    @Override
    public net.runelite.api.Model light() {
        return this.light(139, 2643, -50, -10, -50);
    }

    public void calculateVertexNormals() {
        if (this.normals == null) {
            int i;
            this.normals = new VertexNormal[this.verticesCount];
            for (i = 0; i < this.verticesCount; ++i) {
                this.normals[i] = new VertexNormal();
            }
            for (i = 0; i < this.trianglesCount; ++i) {
                int var13;
                int var2 = this.trianglesX[i];
                int var3 = this.trianglesY[i];
                int var4 = this.trianglesZ[i];
                if (var2 < 0 || var2 >= this.verticesCount || var3 < 0 || var3 >= this.verticesCount || var4 < 0 || var4 >= this.verticesCount) {
                    System.out.println("\u26a0\ufe0f Corrupt triangle index detected in model!");
                    System.out.println("Triangle " + i + " has invalid indices: " + var2 + ", " + var3 + ", " + var4);
                    System.out.println("Model info \u2014 verticesCount: " + this.verticesCount + ", trianglesCount: " + this.trianglesCount);
                    Thread.dumpStack();
                    continue;
                }
                int var5 = this.verticesX[var3] - this.verticesX[var2];
                int var6 = this.verticesY[var3] - this.verticesY[var2];
                int var7 = this.verticesZ[var3] - this.verticesZ[var2];
                int var8 = this.verticesX[var4] - this.verticesX[var2];
                int var9 = this.verticesY[var4] - this.verticesY[var2];
                int var10 = this.verticesZ[var4] - this.verticesZ[var2];
                int var11 = var6 * var10 - var9 * var7;
                int var12 = var7 * var8 - var10 * var5;
                for (var13 = var5 * var9 - var8 * var6; var11 > 8192 || var12 > 8192 || var13 > 8192 || var11 < -8192 || var12 < -8192 || var13 < -8192; var11 >>= 1, var12 >>= 1, var13 >>= 1) {
                }
                int var14 = (int)Math.sqrt(var11 * var11 + var12 * var12 + var13 * var13);
                if (var14 <= 0) {
                    var14 = 1;
                }
                var11 = var11 * 256 / var14;
                var12 = var12 * 256 / var14;
                var13 = var13 * 256 / var14;
                int var15 = this.drawType == null ? 0 : this.drawType[i];
                if (var15 == 0) {
                    VertexNormal v1 = this.normals[var2];
                    v1.x += var11;
                    v1.y += var12;
                    v1.z += var13;
                    ++v1.magnitude;
                    VertexNormal v2 = this.normals[var3];
                    v2.x += var11;
                    v2.y += var12;
                    v2.z += var13;
                    ++v2.magnitude;
                    VertexNormal v3 = this.normals[var4];
                    v3.x += var11;
                    v3.y += var12;
                    v3.z += var13;
                    ++v3.magnitude;
                    continue;
                }
                if (var15 != 1) continue;
                if (this.faceNormals == null) {
                    this.faceNormals = new FaceNormal[this.trianglesCount];
                }
                FaceNormal normal = this.faceNormals[i] = new FaceNormal();
                normal.x = var11;
                normal.y = var12;
                normal.z = var13;
            }
        }
    }

    public Model light(int ambient, int contrast, int x, int y, int z, boolean flatShading) {
        this.calculateVertexNormals();
        int magnitude = (int)Math.sqrt(z * z + x * x + y * y);
        int var7 = magnitude * contrast >> 8;
        Model model = new Model();
        model.colorsX = new int[this.trianglesCount];
        model.colorsY = new int[this.trianglesCount];
        model.colorsZ = new int[this.trianglesCount];
        if (this.texturesCount > 0 && this.textures != null) {
            int var11;
            int var10;
            int[] var9 = new int[this.texturesCount];
            for (var10 = 0; var10 < this.trianglesCount; ++var10) {
                if (this.textures[var10] == -1) continue;
                int n = this.textures[var10] & 0xFF;
                var9[n] = var9[n] + 1;
            }
            model.texturesCount = 0;
            for (var10 = 0; var10 < this.texturesCount; ++var10) {
                if (var9[var10] <= 0 || this.textureTypes[var10] != 0) continue;
                ++model.texturesCount;
            }
            model.texturesX = new int[model.texturesCount];
            model.texturesY = new int[model.texturesCount];
            model.texturesZ = new int[model.texturesCount];
            var10 = 0;
            for (var11 = 0; var11 < this.texturesCount; ++var11) {
                if (var9[var11] > 0 && this.textureTypes[var11] == 0) {
                    model.texturesX[var10] = (short)(this.texturesX[var11] & 0xFFFF);
                    model.texturesY[var10] = (short)(this.texturesY[var11] & 0xFFFF);
                    model.texturesZ[var10] = (short)(this.texturesZ[var11] & 0xFFFF);
                    var9[var11] = var10++;
                    continue;
                }
                var9[var11] = -1;
            }
            model.textures = new byte[this.trianglesCount];
            for (var11 = 0; var11 < this.trianglesCount; ++var11) {
                model.textures[var11] = this.textures[var11] != -1 ? (int)var9[this.textures[var11] & 0xFF] : -1;
            }
        }
        for (int var16 = 0; var16 < this.trianglesCount; ++var16) {
            VertexNormal var13;
            int var14;
            FaceNormal var19;
            int var17 = this.drawType == null ? 0 : this.drawType[var16];
            byte var18 = this.triangleAlpha == null ? (byte)0 : this.triangleAlpha[var16];
            int var12 = this.materials == null ? -1 : this.materials[var16];
            if (var18 == -2) {
                var17 = 3;
            }
            if (var18 == -1) {
                var17 = 2;
            }
            if (var12 == -1) {
                if (var17 != 0) {
                    if (var17 == 1) {
                        var19 = this.faceNormals[var16];
                        var14 = (y * var19.y + z * var19.z + x * var19.x) / (var7 / 2 + var7) + ambient;
                        model.colorsX[var16] = Model.light(this.colors[var16] & 0xFFFF, var14);
                        model.colorsZ[var16] = -1;
                        continue;
                    }
                    if (var17 == 3) {
                        model.colorsX[var16] = 128;
                        model.colorsZ[var16] = -1;
                        continue;
                    }
                    model.colorsZ[var16] = -2;
                    continue;
                }
                int var15 = this.colors[var16] & 0xFFFF;
                var13 = this.vertexNormalsOffsets != null && this.vertexNormalsOffsets[this.trianglesX[var16]] != null ? this.vertexNormalsOffsets[this.trianglesX[var16]] : this.normals[this.trianglesX[var16]];
                var14 = (y * var13.y + z * var13.z + x * var13.x) / (var7 * var13.magnitude) + ambient;
                model.colorsX[var16] = Model.light(var15, var14);
                var13 = this.vertexNormalsOffsets != null && this.vertexNormalsOffsets[this.trianglesY[var16]] != null ? this.vertexNormalsOffsets[this.trianglesY[var16]] : this.normals[this.trianglesY[var16]];
                var14 = (y * var13.y + z * var13.z + x * var13.x) / (var7 * var13.magnitude) + ambient;
                model.colorsY[var16] = Model.light(var15, var14);
                var13 = this.vertexNormalsOffsets != null && this.vertexNormalsOffsets[this.trianglesZ[var16]] != null ? this.vertexNormalsOffsets[this.trianglesZ[var16]] : this.normals[this.trianglesZ[var16]];
                var14 = (y * var13.y + z * var13.z + x * var13.x) / (var7 * var13.magnitude) + ambient;
                model.colorsZ[var16] = Model.light(var15, var14);
                continue;
            }
            if (var17 != 0) {
                if (var17 == 1) {
                    var19 = this.faceNormals[var16];
                    var14 = (y * var19.y + z * var19.z + x * var19.x) / (var7 / 2 + var7) + ambient;
                    model.colorsX[var16] = Model.light(var14);
                    model.colorsZ[var16] = -1;
                    continue;
                }
                model.colorsZ[var16] = -2;
                continue;
            }
            var13 = this.vertexNormalsOffsets != null && this.vertexNormalsOffsets[this.trianglesX[var16]] != null ? this.vertexNormalsOffsets[this.trianglesX[var16]] : this.normals[this.trianglesX[var16]];
            var14 = (y * var13.y + z * var13.z + x * var13.x) / (var7 * var13.magnitude) + ambient;
            model.colorsX[var16] = Model.light(var14);
            var13 = this.vertexNormalsOffsets != null && this.vertexNormalsOffsets[this.trianglesY[var16]] != null ? this.vertexNormalsOffsets[this.trianglesY[var16]] : this.normals[this.trianglesY[var16]];
            var14 = (y * var13.y + z * var13.z + x * var13.x) / (var7 * var13.magnitude) + ambient;
            model.colorsY[var16] = Model.light(var14);
            var13 = this.vertexNormalsOffsets != null && this.vertexNormalsOffsets[this.trianglesZ[var16]] != null ? this.vertexNormalsOffsets[this.trianglesZ[var16]] : this.normals[this.trianglesZ[var16]];
            var14 = (y * var13.y + z * var13.z + x * var13.x) / (var7 * var13.magnitude) + ambient;
            model.colorsZ[var16] = Model.light(var14);
        }
        this.generateBones();
        model.verticesCount = this.verticesCount;
        model.verticesX = this.verticesX;
        model.verticesY = this.verticesY;
        model.verticesZ = this.verticesZ;
        model.trianglesCount = this.trianglesCount;
        model.trianglesX = this.trianglesX;
        model.trianglesY = this.trianglesY;
        model.trianglesZ = this.trianglesZ;
        model.renderPriorities = this.renderPriorities;
        model.triangleAlpha = this.triangleAlpha;
        model.facePriority = this.facePriority;
        model.groupedVertexLabels = this.groupedVertexLabels;
        model.groupedTriangleLabels = this.groupedTriangleLabels;
        model.materials = this.materials;
        model.skeletalBones = this.skeletalBones;
        model.skeletalScales = this.skeletalScales;
        this.colorsX = model.colorsX;
        this.colorsY = model.colorsY;
        this.colorsZ = model.colorsZ;
        this.texturesCount = model.texturesCount;
        this.textures = model.textures;
        this.texturesX = model.texturesX;
        this.texturesY = model.texturesY;
        this.texturesZ = model.texturesZ;
        this.texturesZ = model.texturesZ;
        if (flatShading) {
            this.calculateBoundsCylinder();
        } else {
            this.vertexNormalsOffsets = new VertexNormal[this.verticesCount];
            for (int point = 0; point < this.verticesCount; ++point) {
                VertexNormal norm = this.normals[point];
                VertexNormal merge = this.vertexNormalsOffsets[point] = new VertexNormal();
                merge.x = norm.x;
                merge.y = norm.y;
                merge.z = norm.z;
                merge.magnitude = norm.magnitude;
            }
            this.calculateBounds();
        }
        this.resetBounds();
        if (this.textures == null) {
            this.vertexNormals();
        }
        VertexNormal[] vertexNormals2 = this.normals;
        VertexNormal[] vertexVertices = this.vertexNormalsOffsets;
        if (vertexNormals2 != null && this.vertexNormalsX == null) {
            int verticesCount = this.getVerticesCount();
            this.vertexNormalsX = new int[verticesCount];
            this.vertexNormalsY = new int[verticesCount];
            this.vertexNormalsZ = new int[verticesCount];
            for (int i = 0; i < verticesCount; ++i) {
                VertexNormal vertexNormal;
                if (vertexVertices != null && (vertexNormal = vertexVertices[i]) != null) {
                    this.vertexNormalsX[i] = vertexNormal.getX();
                    this.vertexNormalsY[i] = vertexNormal.getY();
                    this.vertexNormalsZ[i] = vertexNormal.getZ();
                    continue;
                }
                vertexNormal = vertexNormals2[i];
                if (vertexNormal == null) continue;
                this.vertexNormalsX[i] = vertexNormal.getX();
                this.vertexNormalsY[i] = vertexNormal.getY();
                this.vertexNormalsZ[i] = vertexNormal.getZ();
            }
        }
        this.normals = model.normals;
        this.vertexNormalsOffsets = model.vertexNormalsOffsets;
        return this;
    }

    public final void setLighting(int intensity, int specular, int x, int y, int z) {
        this.setLighting(intensity, specular, x, y, z, false);
    }

    public final void setLighting(int intensity, int specular, int x, int y, int z, boolean player) {
        int face;
        for (face = 0; face < this.trianglesCount; ++face) {
            int a = this.trianglesX[face];
            int b = this.trianglesY[face];
            int c = this.trianglesZ[face];
            if (this.materials != null && player) {
                if (this.triangleAlpha != null && this.colors != null) {
                    if (this.colors[face] == 0 && this.renderPriorities[face] == 0 && this.drawType[face] == 2 && this.materials[face] == -1) {
                        this.triangleAlpha[face] = -1;
                    }
                } else if (this.triangleAlpha == null && this.colors[face] == 0 && this.renderPriorities[face] == 0 && this.materials[face] == -1) {
                    this.triangleAlpha = new byte[this.trianglesCount];
                }
            }
            if (this.drawType == null) {
                int hsl = this.colors[face] & 0xFFFF;
                VertexNormal vertex = this.normals[a];
                int dir_light_intensity = intensity + (x * vertex.x + y * vertex.y + z * vertex.z) / (specular * vertex.magnitude);
                this.colorsX[face] = Model.light(hsl, dir_light_intensity, 0);
                vertex = this.normals[b];
                dir_light_intensity = intensity + (x * vertex.x + y * vertex.y + z * vertex.z) / (specular * vertex.magnitude);
                this.colorsY[face] = Model.light(hsl, dir_light_intensity, 0);
                vertex = this.normals[c];
                dir_light_intensity = intensity + (x * vertex.x + y * vertex.y + z * vertex.z) / (specular * vertex.magnitude);
                this.colorsZ[face] = Model.light(hsl, dir_light_intensity, 0);
                continue;
            }
            if ((this.drawType[face] & 1) != 0) continue;
            int type2 = this.drawType[face];
            int hsl = this.colors[face] & 0xFFFF;
            VertexNormal vertex = this.normals[a];
            int dir_light_intensity = intensity + (x * vertex.x + y * vertex.y + z * vertex.z) / (specular * vertex.magnitude);
            this.colorsX[face] = Model.light(hsl, dir_light_intensity, type2);
            vertex = this.normals[b];
            dir_light_intensity = intensity + (x * vertex.x + y * vertex.y + z * vertex.z) / (specular * vertex.magnitude);
            this.colorsY[face] = Model.light(hsl, dir_light_intensity, type2);
            vertex = this.normals[c];
            dir_light_intensity = intensity + (x * vertex.x + y * vertex.y + z * vertex.z) / (specular * vertex.magnitude);
            this.colorsZ[face] = Model.light(hsl, dir_light_intensity, type2);
        }
        this.normals = null;
        this.vertexNormalsOffsets = null;
        this.vertexData = null;
        this.triangleData = null;
        if (this.drawType != null) {
            for (face = 0; face < this.trianglesCount; ++face) {
                if ((this.drawType[face] & 2) != 2) continue;
                return;
            }
        }
        this.colors = null;
    }

    public static final int light(int light) {
        if (light >= 2) {
            if (light > 126) {
                light = 126;
            }
        } else {
            light = 2;
        }
        return light;
    }

    public static final int light(int hsl, int light) {
        if ((light = light * (hsl & 0x7F) >> 7) < 2) {
            light = 2;
        } else if (light > 126) {
            light = 126;
        }
        return (hsl & 0xFF80) + light;
    }

    public static final int light(int hsl, int light, int type2) {
        if ((type2 & 2) == 2) {
            return Model.light(light);
        }
        return Model.light(hsl, light);
    }

    public void renderModel(int rotationY, int rotationZ, int rotationXW, int translationX, int translationY, int translationZ) {
        if (this.boundsType != 2 && this.boundsType != 1) {
            this.calculateDiagonals();
        }
        int centerX = Rasterizer3D.originViewX;
        int centerY = Rasterizer3D.originViewY;
        int sineY = SINE[rotationY];
        int cosineY = COSINE[rotationY];
        int sineZ = SINE[rotationZ];
        int cosineZ = COSINE[rotationZ];
        int sineXW = SINE[rotationXW];
        int cosineXW = COSINE[rotationXW];
        int transformation = translationY * sineXW + translationZ * cosineXW >> 16;
        for (int vertex = 0; vertex < this.verticesCount; ++vertex) {
            int newX;
            int x = this.verticesX[vertex];
            int y = this.verticesY[vertex];
            int z = this.verticesZ[vertex];
            if (rotationZ != 0) {
                newX = y * sineZ + x * cosineZ >> 16;
                y = y * cosineZ - x * sineZ >> 16;
                x = newX;
            }
            if (rotationY != 0) {
                newX = z * sineY + x * cosineY >> 16;
                z = z * cosineY - x * sineY >> 16;
                x = newX;
            }
            int newY = (y += translationY) * cosineXW - (z += translationZ) * sineXW >> 16;
            z = y * sineXW + z * cosineXW >> 16;
            y = newY;
            Model.vertexScreenZ[vertex] = z - transformation;
            Model.vertexScreenX[vertex] = centerX + ((x += translationX) << 9) / z;
            Model.vertexScreenY[vertex] = centerY + (y << 9) / z;
            if (this.texturesCount <= 0) continue;
            Model.vertexMovedX[vertex] = x;
            Model.vertexMovedY[vertex] = y;
            Model.vertexMovedZ[vertex] = z;
        }
        try {
            this.withinObject(false, false, 0L, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void cursorCalculations() {
        int mouseX = MouseHandler.mouseX;
        int mouseY = MouseHandler.mouseY;
        if (MouseHandler.lastButton != 0) {
            mouseX = MouseHandler.saveClickX;
            mouseY = MouseHandler.saveClickY;
        }
        if (mouseX >= Client.instance.getViewportXOffset() && mouseX < Client.instance.getViewportXOffset() + Client.instance.getViewportWidth() && mouseY >= Client.instance.getViewportYOffset() && mouseY < Client.instance.getViewportHeight() + Client.instance.getViewportYOffset()) {
            cursorX = mouseX - Client.instance.getViewportXOffset();
            cursorY = mouseY - Client.instance.getViewportYOffset();
            mouseInViewport = true;
        } else {
            mouseInViewport = false;
        }
        objectsHovering = 0;
    }

    @Override
    public void calculateBoundingBox(int orientation) {
        if (!this.aabb.containsKey(orientation)) {
            int minX = 0;
            int minZ = 0;
            int minY = 0;
            int maxX = 0;
            int maxZ = 0;
            int maxY = 0;
            int cosine = COSINE[orientation];
            int sine = SINE[orientation];
            for (int vert = 0; vert < this.verticesCount; ++vert) {
                int x = Rasterizer3D.method4046(this.verticesX[vert], this.verticesZ[vert], cosine, sine);
                int y = this.verticesY[vert];
                int z = Rasterizer3D.method4046(this.verticesX[vert], this.verticesZ[vert], cosine, sine);
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minZ) {
                    minZ = y;
                }
                if (y > maxZ) {
                    maxZ = y;
                }
                if (z < minY) {
                    minY = z;
                }
                if (z <= maxY) continue;
                maxY = z;
            }
            AABB aabb = new AABB((maxX + minX) / 2, (maxZ + minZ) / 2, (maxY + minY) / 2, (maxX - minX + 1) / 2, (maxZ - minZ + 1) / 2, (maxY - minY + 1) / 2);
            if (aabb.xMidOffset < 32) {
                aabb.xMidOffset = 32;
            }
            if (aabb.zMidOffset < 32) {
                aabb.zMidOffset = 32;
            }
            if (this.singleTile) {
                aabb.xMidOffset += 8;
                aabb.zMidOffset += 8;
            }
            this.aabb.put(orientation, aabb);
        }
    }

    @Override
    public byte[] getTextureFaces() {
        return this.textures;
    }

    @Override
    public int[] getTexIndices1() {
        return this.texturesX;
    }

    @Override
    public int[] getTexIndices2() {
        return this.texturesY;
    }

    @Override
    public int[] getTexIndices3() {
        return this.texturesZ;
    }

    @Override
    public final void renderAtPoint(int orientation, int pitchSine, int pitchCos, int yawSin, int yawCos, int offsetX, int offsetY, int offsetZ, long uid, int plane) {
        int id;
        int opcode;
        int y;
        int x;
        boolean gpu;
        if (this.boundsType != 1) {
            this.calculateBoundsCylinder();
        }
        this.calculateBoundingBox(orientation);
        int sceneX = offsetZ * yawCos - offsetX * yawSin >> 16;
        int sceneY = offsetY * pitchSine + sceneX * pitchCos >> 16;
        int dimensionSinY = this.diagonal2DAboveOrigin * pitchCos >> 16;
        int pos = sceneY + dimensionSinY;
        boolean bl = gpu = Client.instance.isGpu() && Rasterizer3D.world;
        if (pos <= 50 || sceneY >= 3500 && !gpu) {
            return;
        }
        int xRot = offsetZ * yawSin + offsetX * yawCos >> 16;
        int objX = (xRot - this.diagonal2DAboveOrigin) * Rasterizer3D.fieldOfView;
        if (objX / pos >= Rasterizer2D.viewportCenterX) {
            return;
        }
        int objWidth = (xRot + this.diagonal2DAboveOrigin) * Rasterizer3D.fieldOfView;
        if (objWidth / pos <= -Rasterizer2D.viewportCenterX) {
            return;
        }
        int yRot = offsetY * pitchCos - sceneX * pitchSine >> 16;
        int dimensionCosY = this.diagonal2DAboveOrigin * pitchSine >> 16;
        int var20 = (pitchCos * this.maxY >> 16) + dimensionCosY;
        int objHeight = (yRot + var20) * Rasterizer3D.fieldOfView;
        if (objHeight / pos <= -Rasterizer2D.viewportCenterY) {
            return;
        }
        int offset = dimensionCosY + (this.modelBaseY * pitchCos >> 16);
        int objY = (yRot - offset) * Rasterizer3D.fieldOfView;
        if (objY / pos >= Rasterizer2D.viewportCenterY) {
            return;
        }
        int size = dimensionSinY + (this.modelBaseY * pitchSine >> 16);
        boolean var25 = false;
        boolean nearSight = false;
        if (sceneY - size <= 50) {
            nearSight = true;
        }
        boolean inView = nearSight || this.texturesCount > 0;
        boolean highlighted = false;
        if (this.DEBUG_MODELS) {
            x = ObjectKeyUtil.getObjectX(uid);
            y = ObjectKeyUtil.getObjectY(uid);
            opcode = ObjectKeyUtil.getObjectOpcode(uid);
            id = ObjectKeyUtil.getObjectId(uid);
            System.out.println("Render at Point , ID: " + id + " at " + x + ", " + y + " = " + uid);
        }
        if (uid > 0L && mouseInViewport) {
            if (this.DEBUG_MODELS) {
                x = ObjectKeyUtil.getObjectX(uid);
                y = ObjectKeyUtil.getObjectY(uid);
                opcode = ObjectKeyUtil.getObjectOpcode(uid);
                id = ObjectKeyUtil.getObjectId(uid);
                System.out.println("Render at Point Hover, ID: " + id + " at " + x + ", " + y + " = " + uid);
            }
            boolean withinBounds = false;
            int distanceMin = 50;
            int distanceMax = 3500;
            int var43 = (cursorX - Rasterizer3D.originViewX) * distanceMin / Rasterizer3D.fieldOfView;
            int var44 = (cursorY - Rasterizer3D.originViewY) * distanceMin / Rasterizer3D.fieldOfView;
            int var45 = (cursorX - Rasterizer3D.originViewX) * distanceMax / Rasterizer3D.fieldOfView;
            int var46 = (cursorY - Rasterizer3D.originViewY) * distanceMax / Rasterizer3D.fieldOfView;
            int var47 = Rasterizer3D.method4045(var44, distanceMin, SceneGraph.camUpDownX, SceneGraph.camUpDownY);
            int var53 = Rasterizer3D.method4046(var44, distanceMin, SceneGraph.camUpDownX, SceneGraph.camUpDownY);
            var44 = var47;
            var47 = Rasterizer3D.method4045(var46, distanceMax, SceneGraph.camUpDownX, SceneGraph.camUpDownY);
            int var54 = Rasterizer3D.method4046(var46, distanceMax, SceneGraph.camUpDownX, SceneGraph.camUpDownY);
            var46 = var47;
            var47 = Rasterizer3D.method4025(var43, var53, SceneGraph.camLeftRightX, SceneGraph.camLeftRightY);
            var53 = Rasterizer3D.method4044(var43, var53, SceneGraph.camLeftRightX, SceneGraph.camLeftRightY);
            var43 = var47;
            var47 = Rasterizer3D.method4025(var45, var54, SceneGraph.camLeftRightX, SceneGraph.camLeftRightY);
            var54 = Rasterizer3D.method4044(var45, var54, SceneGraph.camLeftRightX, SceneGraph.camLeftRightY);
            int ViewportMouse_field2588 = (var43 + var47) / 2;
            int GZipDecompressor_field4821 = (var46 + var44) / 2;
            int class340_field4138 = (var54 + var53) / 2;
            int ViewportMouse_field2589 = (var47 - var43) / 2;
            int ItemComposition_field2148 = (var46 - var44) / 2;
            int User_field4308 = (var54 - var53) / 2;
            int class421_field4607 = Math.abs(ViewportMouse_field2589);
            int ViewportMouse_field2590 = Math.abs(ItemComposition_field2148);
            int class136_field1612 = Math.abs(User_field4308);
            AABB var50 = (AABB)this.aabb.get(orientation);
            int var37 = offsetX + var50.xMid;
            int var38 = offsetY + var50.yMid;
            int var39 = offsetZ + var50.zMid;
            var43 = ViewportMouse_field2588 - var37;
            var44 = GZipDecompressor_field4821 - var38;
            var45 = class340_field4138 - var39;
            withinBounds = Math.abs(var43) > var50.xMidOffset + class421_field4607 ? false : (Math.abs(var44) > var50.yMidOffset + ViewportMouse_field2590 ? false : (Math.abs(var45) > var50.zMidOffset + class136_field1612 ? false : (Math.abs(var45 * ItemComposition_field2148 - var44 * User_field4308) > var50.yMidOffset * class136_field1612 + var50.zMidOffset * ViewportMouse_field2590 ? false : (Math.abs(var43 * User_field4308 - var45 * ViewportMouse_field2589) > var50.zMidOffset * class421_field4607 + var50.xMidOffset * class136_field1612 ? false : Math.abs(var44 * ViewportMouse_field2589 - var43 * ItemComposition_field2148) <= var50.xMidOffset * ViewportMouse_field2590 + var50.yMidOffset * class421_field4607))));
            if (plane < Client.instance.getPlane() && !OBSTACLE_IDS.contains(ObjectKeyUtil.getObjectId(uid))) {
                withinBounds = false;
            }
            if (withinBounds) {
                if (this.singleTile) {
                    Model.hoveringObjects[Model.objectsHovering++] = uid;
                } else {
                    highlighted = true;
                }
            }
        }
        int sineX = 0;
        int cosineX = 0;
        if (orientation != 0) {
            sineX = SINE[orientation];
            cosineX = COSINE[orientation];
        }
        for (int index = 0; index < this.verticesCount; ++index) {
            int positionX = this.verticesX[index];
            int rasterY = this.verticesY[index];
            int positionZ = this.verticesZ[index];
            if (orientation != 0) {
                int rotatedX = positionZ * sineX + positionX * cosineX >> 16;
                positionZ = positionZ * cosineX - positionX * sineX >> 16;
                positionX = rotatedX;
            }
            int positionY = (positionZ += offsetZ) * yawSin + yawCos * (positionX += offsetX) >> 16;
            positionZ = yawCos * positionZ - positionX * yawSin >> 16;
            positionX = positionY;
            positionY = pitchCos * (rasterY += offsetY) - positionZ * pitchSine >> 16;
            positionZ = rasterY * pitchSine + pitchCos * positionZ >> 16;
            Model.vertexScreenZ[index] = positionZ - sceneY;
            if (positionZ >= 50) {
                Model.vertexScreenX[index] = positionX * Rasterizer3D.fieldOfView / positionZ + Rasterizer3D.originViewX;
                Model.vertexScreenY[index] = positionY * Rasterizer3D.fieldOfView / positionZ + Rasterizer3D.originViewY;
            } else {
                Model.vertexScreenX[index] = -5000;
                var25 = true;
            }
            if (!inView) continue;
            Model.vertexMovedX[index] = positionX;
            Model.vertexMovedY[index] = positionY;
            Model.vertexMovedZ[index] = positionZ;
        }
        try {
            if (!gpu || highlighted && !(Math.sqrt(offsetX * offsetX + offsetZ * offsetZ) > 4480.0)) {
                this.withinObject(var25, highlighted, uid, plane);
            }
            if (gpu) {
                Client.instance.getDrawCallbacks().draw(this, orientation, pitchSine, pitchCos, yawSin, yawCos, offsetX, offsetY, offsetZ, uid);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean inBounds(int x, int y, int z, int screenX, int screenY, int screenZ, int size) {
        int height = cursorY + size;
        if (height < x && height < y && height < z) {
            return false;
        }
        height = cursorY - size;
        if (height > x && height > y && height > z) {
            return false;
        }
        height = cursorX + size;
        if (height < screenX && height < screenY && height < screenZ) {
            return false;
        }
        height = cursorX - size;
        return height <= screenX || height <= screenY || height <= screenZ;
    }

    final void withinObject(boolean var25, boolean highlighted, long uid, int plane) {
        block35: {
            int var18;
            int var16;
            int var15;
            boolean gpu;
            boolean bl = gpu = Client.instance.isGpu() && Rasterizer3D.world;
            if (this.diagonal3D >= 6000) break block35;
            for (int diagonalIndex = 0; diagonalIndex < this.diagonal3D; ++diagonalIndex) {
                Model.depth[diagonalIndex] = 0;
            }
            int size = this.singleTile ? 20 : 5;
            for (int currentTriangle = 0; currentTriangle < this.trianglesCount; ++currentTriangle) {
                int var26;
                int var25a;
                int var24;
                int index;
                if (this.colorsZ[currentTriangle] == -2) continue;
                int triX = this.trianglesX[currentTriangle];
                int triY = this.trianglesY[currentTriangle];
                int triZ = this.trianglesZ[currentTriangle];
                int screenXX = vertexScreenX[triX];
                int screenXY = vertexScreenX[triY];
                int screenXZ = vertexScreenX[triZ];
                if (gpu) {
                    if (screenXX == -5000 || screenXY == -5000 || screenXZ == -5000 || !highlighted || !this.inBounds(vertexScreenY[triX], vertexScreenY[triY], vertexScreenY[triZ], screenXX, screenXY, screenXZ, size) || plane < Client.instance.getPlane() && !OBSTACLE_IDS.contains(ObjectKeyUtil.getObjectId(uid))) continue;
                    Model.hoveringObjects[Model.objectsHovering++] = uid;
                    continue;
                }
                if (!var25 || screenXX != -5000 && screenXY != -5000 && screenXZ != -5000) {
                    if (highlighted && this.inBounds(vertexScreenY[triX], vertexScreenY[triY], vertexScreenY[triZ], screenXX, screenXY, screenXZ, size)) {
                        if (plane >= Client.instance.getPlane() || OBSTACLE_IDS.contains(ObjectKeyUtil.getObjectId(uid))) {
                            Model.hoveringObjects[Model.objectsHovering++] = uid;
                        }
                        highlighted = false;
                    }
                    if ((screenXX - screenXY) * (vertexScreenY[triZ] - vertexScreenY[triY]) - (screenXZ - screenXY) * (vertexScreenY[triX] - vertexScreenY[triY]) <= 0) continue;
                    Model.outOfReach[currentTriangle] = false;
                    Model.hasAnEdgeToRestrict[currentTriangle] = screenXX < 0 || screenXY < 0 || screenXZ < 0 || screenXX > Rasterizer3D.lastX || screenXY > Rasterizer3D.lastX || screenXZ > Rasterizer3D.lastX;
                    index = (vertexScreenZ[triX] + vertexScreenZ[triY] + vertexScreenZ[triZ]) / 3 + this.diagonal3DAboveOrigin;
                    if (index < 0) {
                        index = 0;
                    }
                    int n = index;
                    int n2 = depth[n];
                    depth[n] = n2 + 1;
                    Model.faceLists[index][n2] = currentTriangle;
                    continue;
                }
                index = vertexMovedX[triX];
                var15 = vertexMovedX[triY];
                var16 = vertexMovedX[triZ];
                int var30 = vertexMovedY[triX];
                var18 = vertexMovedY[triY];
                int var19 = vertexMovedY[triZ];
                int var20 = vertexMovedZ[triX];
                int var21 = vertexMovedZ[triY];
                int var22 = vertexMovedZ[triZ];
                int var23 = (var30 -= var18) * (var22 -= var21) - (var20 -= var21) * (var19 -= var18);
                if (var15 * var23 + var18 * (var24 = var20 * (var16 -= var15) - (index -= var15) * var22) + var21 * (var25a = index * var19 - var30 * var16) <= 0) continue;
                Model.outOfReach[currentTriangle] = true;
                int n = var26 = (vertexScreenZ[triX] + vertexScreenZ[triY] + vertexScreenZ[triZ]) / 3 + this.diagonal3DAboveOrigin;
                int n3 = depth[n];
                depth[n] = n3 + 1;
                Model.faceLists[var26][n3] = currentTriangle;
            }
            if (gpu) {
                return;
            }
            if (this.renderPriorities == null) {
                for (int faceIndex = this.diagonal3D - 1; faceIndex >= 0; --faceIndex) {
                    int depth = Model.depth[faceIndex];
                    if (depth <= 0) continue;
                    for (int index = 0; index < depth; ++index) {
                        this.drawFace(faceLists[faceIndex][index]);
                    }
                }
            } else {
                int var11;
                int var8;
                for (int currentIndex = 0; currentIndex < 12; ++currentIndex) {
                    Model.anIntArray1673[currentIndex] = 0;
                    Model.anIntArray1677[currentIndex] = 0;
                }
                for (int depthIndex = this.diagonal3D - 1; depthIndex >= 0; --depthIndex) {
                    var8 = depth[depthIndex];
                    if (var8 <= 0) continue;
                    for (int var10 = 0; var10 < var8; ++var10) {
                        byte var31;
                        var11 = faceLists[depthIndex][var10];
                        byte by = var31 = this.renderPriorities[var11];
                        anIntArray1673[by] = anIntArray1673[by] + 1;
                        Model.anIntArrayArray1674[var31][var28] = var11;
                        if (var31 < 10) {
                            byte by2 = var31;
                            anIntArray1677[by2] = anIntArray1677[by2] + depthIndex;
                            continue;
                        }
                        if (var31 == 10) {
                            Model.anIntArray1675[var28] = depthIndex;
                            continue;
                        }
                        Model.anIntArray1676[var28] = depthIndex;
                    }
                }
                int var7 = 0;
                if (anIntArray1673[1] > 0 || anIntArray1673[2] > 0) {
                    var7 = (anIntArray1677[1] + anIntArray1677[2]) / (anIntArray1673[1] + anIntArray1673[2]);
                }
                var8 = 0;
                if (anIntArray1673[3] > 0 || anIntArray1673[4] > 0) {
                    var8 = (anIntArray1677[3] + anIntArray1677[4]) / (anIntArray1673[3] + anIntArray1673[4]);
                }
                int var9 = 0;
                if (anIntArray1673[6] > 0 || anIntArray1673[8] > 0) {
                    var9 = (anIntArray1677[8] + anIntArray1677[6]) / (anIntArray1673[8] + anIntArray1673[6]);
                }
                var11 = 0;
                int var12 = anIntArray1673[10];
                int[] var13 = anIntArrayArray1674[10];
                int[] var14 = anIntArray1675;
                if (var11 == var12) {
                    var11 = 0;
                    var12 = anIntArray1673[11];
                    var13 = anIntArrayArray1674[11];
                    var14 = anIntArray1676;
                }
                int var10 = var11 < var12 ? var14[var11] : -1000;
                for (var15 = 0; var15 < 10; ++var15) {
                    while (var15 == 0 && var10 > var7) {
                        this.drawFace(var13[var11++]);
                        if (var11 == var12 && var13 != anIntArrayArray1674[11]) {
                            var11 = 0;
                            var12 = anIntArray1673[11];
                            var13 = anIntArrayArray1674[11];
                            var14 = anIntArray1676;
                        }
                        if (var11 < var12) {
                            var10 = var14[var11];
                            continue;
                        }
                        var10 = -1000;
                    }
                    while (var15 == 3 && var10 > var8) {
                        this.drawFace(var13[var11++]);
                        if (var11 == var12 && var13 != anIntArrayArray1674[11]) {
                            var11 = 0;
                            var12 = anIntArray1673[11];
                            var13 = anIntArrayArray1674[11];
                            var14 = anIntArray1676;
                        }
                        if (var11 < var12) {
                            var10 = var14[var11];
                            continue;
                        }
                        var10 = -1000;
                    }
                    while (var15 == 5 && var10 > var9) {
                        this.drawFace(var13[var11++]);
                        if (var11 == var12 && var13 != anIntArrayArray1674[11]) {
                            var11 = 0;
                            var12 = anIntArray1673[11];
                            var13 = anIntArrayArray1674[11];
                            var14 = anIntArray1676;
                        }
                        if (var11 < var12) {
                            var10 = var14[var11];
                            continue;
                        }
                        var10 = -1000;
                    }
                    var16 = anIntArray1673[var15];
                    int[] var17 = anIntArrayArray1674[var15];
                    for (var18 = 0; var18 < var16; ++var18) {
                        this.drawFace(var17[var18]);
                    }
                }
                while (var10 != -1000) {
                    this.drawFace(var13[var11++]);
                    if (var11 == var12 && var13 != anIntArrayArray1674[11]) {
                        var11 = 0;
                        var13 = anIntArrayArray1674[11];
                        var12 = anIntArray1673[11];
                        var14 = anIntArray1676;
                    }
                    if (var11 < var12) {
                        var10 = var14[var11];
                        continue;
                    }
                    var10 = -1000;
                }
            }
        }
    }

    @Override
    public void drawFace(int face) {
        DrawCallbacks callbacks = Client.instance.getDrawCallbacks();
        if (callbacks == null || !callbacks.drawFace(this, face)) {
            if (outOfReach[face]) {
                this.faceRotation(face);
                return;
            }
            int triX = this.trianglesX[face];
            int triY = this.trianglesY[face];
            int triZ = this.trianglesZ[face];
            Rasterizer3D.textureOutOfDrawingBounds = hasAnEdgeToRestrict[face];
            Rasterizer3D.alpha = this.triangleAlpha == null ? 0 : this.triangleAlpha[face] & 0xFF;
            int type2 = this.drawType == null ? 0 : this.drawType[face] & 3;
            if (this.materials != null && this.materials[face] != -1) {
                int textureA = triX;
                int textureB = triY;
                int textureC = triZ;
                if (this.textures != null && this.textures[face] != -1) {
                    int coordinate = this.textures[face] & 0xFF;
                    textureA = this.texturesX[coordinate];
                    textureB = this.texturesY[coordinate];
                    textureC = this.texturesZ[coordinate];
                }
                if (this.colorsZ[face] == -1 || type2 == 3) {
                    Rasterizer3D.drawTexturedTriangle(vertexScreenY[triX], vertexScreenY[triY], vertexScreenY[triZ], vertexScreenX[triX], vertexScreenX[triY], vertexScreenX[triZ], this.colorsX[face], this.colorsX[face], this.colorsX[face], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[face]);
                } else {
                    Rasterizer3D.drawTexturedTriangle(vertexScreenY[triX], vertexScreenY[triY], vertexScreenY[triZ], vertexScreenX[triX], vertexScreenX[triY], vertexScreenX[triZ], this.colorsX[face], this.colorsY[face], this.colorsZ[face], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[face]);
                }
            } else if (this.colorsZ[face] == -1) {
                Rasterizer3D.drawFlatTriangle(vertexScreenY[triX], vertexScreenY[triY], vertexScreenY[triZ], vertexScreenX[triX], vertexScreenX[triY], vertexScreenX[triZ], modelColors[this.colorsX[face]]);
            } else {
                if (type2 == 0) {
                    Rasterizer3D.drawShadedTriangle(vertexScreenY[triX], vertexScreenY[triY], vertexScreenY[triZ], vertexScreenX[triX], vertexScreenX[triY], vertexScreenX[triZ], this.colorsX[face], this.colorsY[face], this.colorsZ[face]);
                }
                if (type2 == 1) {
                    Rasterizer3D.drawFlatTriangle(vertexScreenY[triX], vertexScreenY[triY], vertexScreenY[triZ], vertexScreenX[triX], vertexScreenX[triY], vertexScreenX[triZ], modelColors[this.colorsX[face]]);
                }
            }
        }
    }

    private final void faceRotation(int triangle) {
        int colour;
        int movedY2;
        int movedX2;
        int centreX = Rasterizer3D.originViewX;
        int centreY = Rasterizer3D.originViewY;
        int counter = 0;
        int x = this.trianglesX[triangle];
        int y = this.trianglesY[triangle];
        int z = this.trianglesZ[triangle];
        int movedX = vertexMovedZ[x];
        int movedY = vertexMovedZ[y];
        int movedZ = vertexMovedZ[z];
        if (movedX >= 50) {
            Model.xPosition[counter] = vertexScreenX[x];
            Model.yPosition[counter] = vertexScreenY[x];
            Model.zPosition[counter++] = this.colorsX[triangle];
        } else {
            movedX2 = vertexMovedX[x];
            movedY2 = vertexMovedY[x];
            colour = this.colorsX[triangle];
            if (movedZ >= 50) {
                int k5 = (50 - movedX) * modelLocations[movedZ - movedX];
                Model.xPosition[counter] = centreX + (movedX2 + ((vertexMovedX[z] - movedX2) * k5 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.yPosition[counter] = centreY + (movedY2 + ((vertexMovedY[z] - movedY2) * k5 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.zPosition[counter++] = colour + ((this.colorsZ[triangle] - colour) * k5 >> 16);
            }
            if (movedY >= 50) {
                int l5 = (50 - movedX) * modelLocations[movedY - movedX];
                Model.xPosition[counter] = centreX + (movedX2 + ((vertexMovedX[y] - movedX2) * l5 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.yPosition[counter] = centreY + (movedY2 + ((vertexMovedY[y] - movedY2) * l5 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.zPosition[counter++] = colour + ((this.colorsY[triangle] - colour) * l5 >> 16);
            }
        }
        if (movedY >= 50) {
            Model.xPosition[counter] = vertexScreenX[y];
            Model.yPosition[counter] = vertexScreenY[y];
            Model.zPosition[counter++] = this.colorsY[triangle];
        } else {
            movedX2 = vertexMovedX[y];
            movedY2 = vertexMovedY[y];
            colour = this.colorsY[triangle];
            if (movedX >= 50) {
                int i6 = (50 - movedY) * modelLocations[movedX - movedY];
                Model.xPosition[counter] = centreX + (movedX2 + ((vertexMovedX[x] - movedX2) * i6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.yPosition[counter] = centreY + (movedY2 + ((vertexMovedY[x] - movedY2) * i6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.zPosition[counter++] = colour + ((this.colorsX[triangle] - colour) * i6 >> 16);
            }
            if (movedZ >= 50) {
                int j6 = (50 - movedY) * modelLocations[movedZ - movedY];
                Model.xPosition[counter] = centreX + (movedX2 + ((vertexMovedX[z] - movedX2) * j6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.yPosition[counter] = centreY + (movedY2 + ((vertexMovedY[z] - movedY2) * j6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.zPosition[counter++] = colour + ((this.colorsZ[triangle] - colour) * j6 >> 16);
            }
        }
        if (movedZ >= 50) {
            Model.xPosition[counter] = vertexScreenX[z];
            Model.yPosition[counter] = vertexScreenY[z];
            Model.zPosition[counter++] = this.colorsZ[triangle];
        } else {
            movedX2 = vertexMovedX[z];
            movedY2 = vertexMovedY[z];
            colour = this.colorsZ[triangle];
            if (movedY >= 50) {
                int k6 = (50 - movedZ) * modelLocations[movedY - movedZ];
                Model.xPosition[counter] = centreX + (movedX2 + ((vertexMovedX[y] - movedX2) * k6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.yPosition[counter] = centreY + (movedY2 + ((vertexMovedY[y] - movedY2) * k6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.zPosition[counter++] = colour + ((this.colorsY[triangle] - colour) * k6 >> 16);
            }
            if (movedX >= 50) {
                int l6 = (50 - movedZ) * modelLocations[movedX - movedZ];
                Model.xPosition[counter] = centreX + (movedX2 + ((vertexMovedX[x] - movedX2) * l6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.yPosition[counter] = centreY + (movedY2 + ((vertexMovedY[x] - movedY2) * l6 >> 16)) * Rasterizer3D.fieldOfView / 50;
                Model.zPosition[counter++] = colour + ((this.colorsX[triangle] - colour) * l6 >> 16);
            }
        }
        int xA = xPosition[0];
        int xB = xPosition[1];
        int xC = xPosition[2];
        int yA = yPosition[0];
        int yB = yPosition[1];
        int yC = yPosition[2];
        if ((xA - xB) * (yC - yB) - (yA - yB) * (xC - xB) > 0) {
            int coordinate;
            int drawType;
            Rasterizer3D.textureOutOfDrawingBounds = false;
            int textureA = x;
            int textureB = y;
            int textureC = z;
            if (counter == 3) {
                if (xA < 0 || xB < 0 || xC < 0 || xA > Rasterizer2D.lastX || xB > Rasterizer2D.lastX || xC > Rasterizer2D.lastX) {
                    Rasterizer3D.textureOutOfDrawingBounds = true;
                }
                drawType = this.drawType == null ? 0 : this.drawType[triangle] & 3;
                if (this.materials != null && this.materials[triangle] != -1) {
                    if (this.textures != null && this.textures[triangle] != -1) {
                        coordinate = this.textures[triangle] & 0xFF;
                        textureA = this.texturesX[coordinate];
                        textureB = this.texturesY[coordinate];
                        textureC = this.texturesZ[coordinate];
                    }
                    if (this.colorsZ[triangle] == -1) {
                        Rasterizer3D.drawTexturedTriangle(yA, yB, yC, xA, xB, xC, this.colorsX[triangle], this.colorsX[triangle], this.colorsX[triangle], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[triangle]);
                    } else {
                        Rasterizer3D.drawTexturedTriangle(yA, yB, yC, xA, xB, xC, zPosition[0], zPosition[1], zPosition[2], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[triangle]);
                    }
                } else if (drawType == 0) {
                    Rasterizer3D.drawShadedTriangle(yA, yB, yC, xA, xB, xC, zPosition[0], zPosition[1], zPosition[2]);
                } else if (drawType == 1) {
                    Rasterizer3D.drawFlatTriangle(yA, yB, yC, xA, xB, xC, modelColors[this.colorsX[triangle]]);
                }
            }
            if (counter == 4) {
                if (xA < 0 || xB < 0 || xC < 0 || xA > Rasterizer2D.lastX || xB > Rasterizer2D.lastX || xC > Rasterizer2D.lastX || xPosition[3] < 0 || xPosition[3] > Rasterizer2D.lastX) {
                    Rasterizer3D.textureOutOfDrawingBounds = true;
                }
                drawType = this.drawType == null ? 0 : this.drawType[triangle] & 3;
                if (this.materials != null && this.materials[triangle] != -1) {
                    if (this.textures != null && this.textures[triangle] != -1) {
                        coordinate = this.textures[triangle] & 0xFF;
                        textureA = this.texturesX[coordinate];
                        textureB = this.texturesY[coordinate];
                        textureC = this.texturesZ[coordinate];
                    }
                    if (this.colorsZ[triangle] == -1) {
                        Rasterizer3D.drawTexturedTriangle(yA, yB, yC, xA, xB, xC, this.colorsX[triangle], this.colorsX[triangle], this.colorsX[triangle], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[triangle]);
                        Rasterizer3D.drawTexturedTriangle(yA, yC, yPosition[3], xA, xC, xPosition[3], this.colorsX[triangle], this.colorsX[triangle], this.colorsX[triangle], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[triangle]);
                    } else {
                        Rasterizer3D.drawTexturedTriangle(yA, yB, yC, xA, xB, xC, zPosition[0], zPosition[1], zPosition[2], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[triangle]);
                        Rasterizer3D.drawTexturedTriangle(yA, yC, yPosition[3], xA, xC, xPosition[3], zPosition[0], zPosition[2], zPosition[3], vertexMovedX[textureA], vertexMovedX[textureB], vertexMovedX[textureC], vertexMovedY[textureA], vertexMovedY[textureB], vertexMovedY[textureC], vertexMovedZ[textureA], vertexMovedZ[textureB], vertexMovedZ[textureC], this.materials[triangle]);
                    }
                } else {
                    if (drawType == 0) {
                        Rasterizer3D.drawShadedTriangle(yA, yB, yC, xA, xB, xC, zPosition[0], zPosition[1], zPosition[2]);
                        Rasterizer3D.drawShadedTriangle(yA, yC, yPosition[3], xA, xC, xPosition[3], zPosition[0], zPosition[2], zPosition[3]);
                        return;
                    }
                    if (drawType == 1) {
                        int l8 = modelColors[this.colorsX[triangle]];
                        Rasterizer3D.drawFlatTriangle(yA, yB, yC, xA, xB, xC, l8);
                        Rasterizer3D.drawFlatTriangle(yA, yC, yPosition[3], xA, xC, xPosition[3], l8);
                    }
                }
            }
        }
    }

    @Override
    public List<Vertex> getVertices() {
        int[] verticesX = this.getVerticesX();
        int[] verticesY = this.getVerticesY();
        int[] verticesZ = this.getVerticesZ();
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(this.getVerticesCount());
        for (int i = 0; i < this.getVerticesCount(); ++i) {
            Vertex vertex = new Vertex(verticesX[i], verticesY[i], verticesZ[i]);
            vertices.add(vertex);
        }
        return vertices;
    }

    @Override
    public List<Triangle> getTriangles() {
        int[] trianglesX = this.getFaceIndices1();
        int[] trianglesY = this.getFaceIndices2();
        int[] trianglesZ = this.getFaceIndices3();
        List<Vertex> vertices = this.getVertices();
        ArrayList<Triangle> triangles = new ArrayList<Triangle>(this.getFaceCount());
        for (int i = 0; i < this.getFaceCount(); ++i) {
            int triangleX = trianglesX[i];
            int triangleY = trianglesY[i];
            int triangleZ = trianglesZ[i];
            Triangle triangle = new Triangle(vertices.get(triangleX), vertices.get(triangleY), vertices.get(triangleZ));
            triangles.add(triangle);
        }
        return triangles;
    }

    @Override
    public int getVerticesCount() {
        return this.verticesCount;
    }

    @Override
    public int[] getVerticesX() {
        return this.verticesX;
    }

    @Override
    public int[] getVerticesY() {
        return this.verticesY;
    }

    @Override
    public int[] getVerticesZ() {
        return this.verticesZ;
    }

    @Override
    public int getFaceCount() {
        return this.trianglesCount;
    }

    @Override
    public int[] getFaceIndices1() {
        return this.trianglesX;
    }

    @Override
    public int[] getFaceIndices2() {
        return this.trianglesY;
    }

    @Override
    public int[] getFaceIndices3() {
        return this.trianglesZ;
    }

    @Override
    public int[] getFaceColors1() {
        return this.colorsX;
    }

    @Override
    public int[] getFaceColors2() {
        return this.colorsY;
    }

    @Override
    public int[] getFaceColors3() {
        return this.colorsZ;
    }

    @Override
    public byte[] getFaceTransparencies() {
        return this.triangleAlpha;
    }

    @Override
    public int getSceneId() {
        return this.sceneId;
    }

    @Override
    public void setSceneId(int sceneId) {
        this.sceneId = sceneId;
    }

    @Override
    public int getBufferOffset() {
        return this.bufferOffset;
    }

    @Override
    public void setBufferOffset(int bufferOffset) {
        this.bufferOffset = bufferOffset;
    }

    @Override
    public int getUvBufferOffset() {
        return this.uvBufferOffset;
    }

    @Override
    public void setUvBufferOffset(int uvBufferOffset) {
        this.uvBufferOffset = uvBufferOffset;
    }

    @Override
    public int getModelHeight() {
        return this.modelBaseY;
    }

    @Override
    public void animate(int type2, int[] list, int x, int y, int z) {
    }

    @Override
    public byte[] getFaceRenderPriorities() {
        return this.renderPriorities;
    }

    @Override
    public int[][] getGroupedVertexLabels() {
        return new int[0][];
    }

    @Override
    public int getRadius() {
        return this.diagonal3DAboveOrigin;
    }

    @Override
    public int getDiameter() {
        return this.diagonal3D;
    }

    @Override
    public short[] getFaceTextures() {
        return this.materials;
    }

    @Override
    public void calculateExtreme(int orientation) {
        this.calculateBoundingBox(orientation);
    }

    @Override
    public void resetBounds() {
        this.boundsType = 0;
        this.aabb.clear();
    }

    @Override
    public RSModel toSharedModel(boolean b) {
        return null;
    }

    @Override
    public RSModel toSharedSpotAnimModel(boolean b) {
        return null;
    }

    void invalidate() {
        this.vertexNormalsOffsets = null;
        this.normals = null;
        this.faceNormals = null;
        this.isBoundsCalculated = false;
    }

    @Override
    public Model rotateY90Ccw() {
        this.rotate90Degrees();
        this.resetBounds();
        this.invalidate();
        return this;
    }

    @Override
    public Model rotateY180Ccw() {
        for (int vert = 0; vert < this.verticesCount; ++vert) {
            this.verticesX[vert] = -this.verticesX[vert];
            this.verticesZ[vert] = -this.verticesZ[vert];
        }
        this.resetBounds();
        this.invalidate();
        return this;
    }

    @Override
    public Model rotateY270Ccw() {
        for (int vert = 0; vert < this.verticesCount; ++vert) {
            int var2 = this.verticesZ[vert];
            this.verticesZ[vert] = this.verticesX[vert];
            this.verticesX[vert] = -var2;
        }
        this.resetBounds();
        this.invalidate();
        return this;
    }

    @Override
    public int getXYZMag() {
        return this.diagonal2DAboveOrigin;
    }

    @Override
    public boolean isClickable() {
        return this.singleTile;
    }

    @Override
    public void interpolateFrames(RSFrames frames, int frameId, RSFrames nextFrames, int nextFrameId, int interval, int intervalCount) {
    }

    @Override
    public int[] getVertexNormalsX() {
        if (this.vertexNormalsX == null) {
            return this.getVerticesX();
        }
        return this.vertexNormalsX;
    }

    @Override
    public void setVertexNormalsX(int[] vertexNormalsX) {
        this.vertexNormalsX = vertexNormalsX;
    }

    @Override
    public int[] getVertexNormalsY() {
        if (this.vertexNormalsY == null) {
            return this.getVerticesY();
        }
        return this.vertexNormalsY;
    }

    @Override
    public void setVertexNormalsY(int[] vertexNormalsY) {
        this.vertexNormalsY = vertexNormalsY;
    }

    @Override
    public int[] getVertexNormalsZ() {
        if (this.vertexNormalsZ == null) {
            return this.getVerticesZ();
        }
        return this.vertexNormalsZ;
    }

    @Override
    public void setVertexNormalsZ(int[] vertexNormalsZ) {
        this.vertexNormalsZ = vertexNormalsZ;
    }

    @Override
    public byte getOverrideAmount() {
        return 0;
    }

    @Override
    public byte getOverrideHue() {
        return 0;
    }

    @Override
    public byte getOverrideSaturation() {
        return 0;
    }

    @Override
    public byte getOverrideLuminance() {
        return 0;
    }

    @Override
    public HashMap<Integer, net.runelite.api.AABB> getAABBMap() {
        return this.aabb;
    }

    @Override
    public Shape getConvexHull(int localX, int localY, int orientation, int tileHeight) {
        int[] x2d = new int[this.getVerticesCount()];
        int[] y2d = new int[this.getVerticesCount()];
        Perspective.modelToCanvas(Client.instance, this.getVerticesCount(), localX, localY, tileHeight, orientation, this.getVerticesX(), this.getVerticesZ(), this.getVerticesY(), x2d, y2d);
        return Jarvis.convexHull(x2d, y2d);
    }

    @Override
    public int getBottomY() {
        return this.modelBaseY;
    }

    private void vertexNormals() {
        if (this.vertexNormalsX == null) {
            int verticesCount = this.getVerticesCount();
            this.vertexNormalsX = new int[verticesCount];
            this.vertexNormalsY = new int[verticesCount];
            this.vertexNormalsZ = new int[verticesCount];
            int[] trianglesX = this.getFaceIndices1();
            int[] trianglesY = this.getFaceIndices2();
            int[] trianglesZ = this.getFaceIndices3();
            int[] verticesX = this.getVerticesX();
            int[] verticesY = this.getVerticesY();
            int[] verticesZ = this.getVerticesZ();
            for (int i = 0; i < this.trianglesCount; ++i) {
                int var20;
                int var9 = trianglesX[i];
                int var10 = trianglesY[i];
                int var11 = trianglesZ[i];
                int var12 = verticesX[var10] - verticesX[var9];
                int var13 = verticesY[var10] - verticesY[var9];
                int var14 = verticesZ[var10] - verticesZ[var9];
                int var15 = verticesX[var11] - verticesX[var9];
                int var16 = verticesY[var11] - verticesY[var9];
                int var17 = verticesZ[var11] - verticesZ[var9];
                int var18 = var13 * var17 - var16 * var14;
                int var19 = var14 * var15 - var17 * var12;
                for (var20 = var12 * var16 - var15 * var13; var18 > 8192 || var19 > 8192 || var20 > 8192 || var18 < -8192 || var19 < -8192 || var20 < -8192; var18 >>= 1, var19 >>= 1, var20 >>= 1) {
                }
                int var21 = (int)Math.sqrt(var18 * var18 + var19 * var19 + var20 * var20);
                if (var21 <= 0) {
                    var21 = 1;
                }
                var18 = var18 * 256 / var21;
                var19 = var19 * 256 / var21;
                var20 = var20 * 256 / var21;
                int n = var9;
                this.vertexNormalsX[n] = this.vertexNormalsX[n] + var18;
                int n2 = var9;
                this.vertexNormalsY[n2] = this.vertexNormalsY[n2] + var19;
                int n3 = var9;
                this.vertexNormalsZ[n3] = this.vertexNormalsZ[n3] + var20;
                int n4 = var10;
                this.vertexNormalsX[n4] = this.vertexNormalsX[n4] + var18;
                int n5 = var10;
                this.vertexNormalsY[n5] = this.vertexNormalsY[n5] + var19;
                int n6 = var10;
                this.vertexNormalsZ[n6] = this.vertexNormalsZ[n6] + var20;
                int n7 = var11;
                this.vertexNormalsX[n7] = this.vertexNormalsX[n7] + var18;
                int n8 = var11;
                this.vertexNormalsY[n8] = this.vertexNormalsY[n8] + var19;
                int n9 = var11;
                this.vertexNormalsZ[n9] = this.vertexNormalsZ[n9] + var20;
            }
        }
    }

    @Override
    public int getLastOrientation() {
        return this.lastOrientation;
    }

    @Override
    public Model cloneColors() {
        short[] newFaceColor = Arrays.copyOf(this.getFaceColors(), this.getFaceColors().length);
        this.setFaceColors(newFaceColor);
        return this;
    }

    @Override
    public AABB getAABB(int orientation) {
        this.calculateExtreme(orientation);
        this.lastOrientation = orientation;
        return (AABB)this.getAABBMap().get(this.lastOrientation);
    }

    public Model contourGround(int[][] var1, int var2, int var3, int var4, boolean var5, int var6) {
        this.calculateBoundsCylinder();
        int var7 = var2 - this.diagonal2DAboveOrigin;
        int var8 = var2 + this.diagonal2DAboveOrigin;
        int var9 = var4 - this.diagonal2DAboveOrigin;
        int var10 = var4 + this.diagonal2DAboveOrigin;
        if (var7 >= 0 && var8 + 128 >> 7 < var1.length && var9 >= 0 && var10 + 128 >> 7 < var1[0].length) {
            Model var11;
            var8 = var8 + 127 >> 7;
            var10 = var10 + 127 >> 7;
            if (var3 == var1[var7 >>= 7][var9 >>= 7] && var3 == var1[var8][var9] && var3 == var1[var7][var10] && var3 == var1[var8][var10]) {
                return this;
            }
            if (var5) {
                var11 = new Model();
                var11.verticesCount = this.verticesCount;
                var11.trianglesCount = this.trianglesCount;
                var11.texturesCount = this.texturesCount;
                var11.verticesX = this.verticesX;
                var11.verticesZ = this.verticesZ;
                var11.trianglesX = this.trianglesX;
                var11.trianglesY = this.trianglesY;
                var11.trianglesZ = this.trianglesZ;
                var11.colorsX = this.colorsX;
                var11.colorsY = this.colorsY;
                var11.colorsZ = this.colorsZ;
                var11.renderPriorities = this.renderPriorities;
                var11.triangleAlpha = this.triangleAlpha;
                var11.textures = this.textures;
                var11.materials = this.materials;
                var11.facePriority = this.facePriority;
                var11.texturesX = this.texturesX;
                var11.texturesY = this.texturesY;
                var11.texturesZ = this.texturesZ;
                var11.groupedVertexLabels = this.groupedVertexLabels;
                var11.groupedTriangleLabels = this.groupedTriangleLabels;
                var11.isSingleTile = this.isSingleTile;
                var11.verticesY = new int[var11.verticesCount];
            } else {
                var11 = this;
            }
            if (var6 == 0) {
                for (int var12 = 0; var12 < var11.verticesCount; ++var12) {
                    int var13 = var2 + this.verticesX[var12];
                    int var14 = var4 + this.verticesZ[var12];
                    int var15 = var13 & 0x7F;
                    int var16 = var14 & 0x7F;
                    int var17 = var13 >> 7;
                    int var18 = var14 >> 7;
                    int var19 = var1[var17][var18] * (128 - var15) + var1[var17 + 1][var18] * var15 >> 7;
                    int var20 = var1[var17][var18 + 1] * (128 - var15) + var15 * var1[var17 + 1][var18 + 1] >> 7;
                    int var21 = var19 * (128 - var16) + var20 * var16 >> 7;
                    var11.verticesY[var12] = var21 + this.verticesY[var12] - var3;
                }
            } else {
                for (int var12 = 0; var12 < var11.verticesCount; ++var12) {
                    int var13 = (-this.verticesY[var12] << 16) / this.modelBaseY;
                    if (var13 >= var6) continue;
                    int var14 = var2 + this.verticesX[var12];
                    int var15 = var4 + this.verticesZ[var12];
                    int var16 = var14 & 0x7F;
                    int var17 = var15 & 0x7F;
                    int var18 = var14 >> 7;
                    int var19 = var15 >> 7;
                    int var20 = var1[var18][var19] * (128 - var16) + var1[var18 + 1][var19] * var16 >> 7;
                    int var21 = var1[var18][var19 + 1] * (128 - var16) + var16 * var1[var18 + 1][var19 + 1] >> 7;
                    int var22 = var20 * (128 - var17) + var21 * var17 >> 7;
                    var11.verticesY[var12] = (var6 - var13) * (var22 - var3) / var6 + this.verticesY[var12];
                }
            }
            var11.resetBounds();
            return var11;
        }
        return this;
    }

    private void setFaceColors(short[] newFaceColor) {
        this.colors = newFaceColor;
    }

    @Override
    public short[] getFaceColors() {
        return this.colors;
    }

    static {
        fbm = new Matrix4f();
        sm = new Matrix4f();
        cbm = new Matrix4f();
        mouseInViewport = false;
        OBSTACLE_IDS = ImmutableSet.of(Integer.valueOf(23547));
        emptyModel = new Model();
        sharedVerticesX = new int[2000];
        sharedVerticesY = new int[2000];
        sharedVerticesZ = new int[2000];
        sharedTriangleAlpha = new byte[2000];
        hasAnEdgeToRestrict = new boolean[25000];
        outOfReach = new boolean[25000];
        vertexScreenX = new int[25000];
        vertexScreenY = new int[25000];
        vertexScreenZ = new int[25000];
        vertexMovedX = new int[25000];
        vertexMovedY = new int[25000];
        vertexMovedZ = new int[25000];
        depth = new int[3600];
        faceLists = new int[3600][65535];
        anIntArray1673 = new int[12];
        anIntArrayArray1674 = new int[12][65535];
        anIntArray1676 = new int[65535];
        anIntArray1675 = new int[65535];
        anIntArray1677 = new int[12];
        xPosition = new int[10];
        yPosition = new int[10];
        zPosition = new int[10];
        hoveringObjects = new long[25000];
        SINE = Rasterizer3D.SINE;
        COSINE = Rasterizer3D.COSINE;
        modelColors = Rasterizer3D.hslToRgb;
        modelLocations = Rasterizer3D.anIntArray1469;
    }
}

