/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Client;
import com.client.Rasterizer2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.util.Hashtable;

public final class RSImageProducer {
    public final int[] canvasRaster;
    public final int width;
    public final int height;
    public final BufferedImage image;
    public final Component component;
    private final Rectangle clip = new Rectangle();
    private static final ColorModel COLOR_MODEL = new DirectColorModel(32, 0xFF0000, 65280, 255);

    public RSImageProducer(int width, int height, Component component) {
        this.width = width;
        this.height = height;
        this.component = component;
        int count2 = width * height;
        this.canvasRaster = new int[count2];
        this.image = new BufferedImage(COLOR_MODEL, Raster.createWritableRaster(COLOR_MODEL.createCompatibleSampleModel(width, height), new DataBufferInt(this.canvasRaster, count2), null), false, new Hashtable());
        this.initDrawingArea();
    }

    public void drawGraphics(int x, int y, Graphics gfx) {
        this.draw(gfx, x, y);
    }

    public void draw(Graphics gfx, int x, int y) {
        RSImageProducer.drawScaledImage(this.image, gfx, x, y, this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics gfx, int x, int y, int clipX, int clipY, int clipWidth, int clipHeight) {
        Shape tmp = gfx.getClip();
        try {
            this.clip.x = clipX;
            this.clip.y = clipY;
            this.clip.width = clipWidth;
            this.clip.height = clipHeight;
            gfx.setClip(this.clip);
            gfx.drawImage(this.image, x, y, this.component);
        }
        finally {
            gfx.setClip(tmp);
        }
    }

    public void initDrawingArea() {
        Rasterizer2D.initDrawingArea(this.height, this.width, this.canvasRaster);
    }

    public static Point2D.Double getStretchScale() {
        if (!Client.instance.isResized()) {
            double widthScale = (double)Client.instance.getGameComponent().getWidth() / 765.0;
            double heightScale = (double)Client.instance.getGameComponent().getHeight() / 503.0;
            return new Point2D.Double(Math.max(1.0, widthScale), Math.max(1.0, heightScale));
        }
        return new Point2D.Double(1.0, 1.0);
    }

    public static void drawScaledImage(Image image, Graphics gfx, int x, int y, int width, int height) {
        if (!Client.instance.isResized() && Client.instance.isStretchedEnabled()) {
            Graphics2D gfx2d = (Graphics2D)gfx;
            gfx2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            Point2D.Double scale = RSImageProducer.getStretchScale();
            int stretchedWidth = (int)Math.floor((double)width * scale.getX());
            int stretchedHeight = (int)Math.floor((double)height * scale.getY());
            x = (int)((double)x * scale.getX());
            y = (int)((double)y * scale.getY());
            gfx2d.drawImage(image, x, y, stretchedWidth, stretchedHeight, Color.BLACK, null);
        } else {
            gfx.drawImage(image, x, y, null);
        }
    }
}

