/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Client;
import com.client.Rasterizer2D;
import com.client.graphics.textures.TextureLoader;
import com.client.graphics.textures.TextureProvider;

public final class Rasterizer3D
extends Rasterizer2D {
    public static int fieldOfView = 512;
    public static double brightness = 0.0;
    public static boolean world = true;
    public static boolean renderOnGpu = false;
    public static TextureLoader textureLoader;
    public static boolean lowMem;
    public static boolean textureOutOfDrawingBounds;
    private static boolean isTransparent;
    public static boolean aBoolean1464;
    public static int alpha;
    public static int originViewX;
    public static int originViewY;
    private static int[] anIntArray1468;
    public static final int[] anIntArray1469;
    public static int[] SINE;
    public static int[] COSINE;
    public static int[] scanOffsets;
    public static int[] hslToRgb;

    public static void clear() {
        anIntArray1468 = null;
        SINE = null;
        COSINE = null;
        scanOffsets = null;
        hslToRgb = null;
    }

    public static void useViewport() {
        scanOffsets = new int[Rasterizer2D.height];
        for (int j = 0; j < Rasterizer2D.height; ++j) {
            Rasterizer3D.scanOffsets[j] = Rasterizer2D.width * j;
        }
        originViewX = Rasterizer2D.width / 2;
        originViewY = Rasterizer2D.height / 2;
    }

    public static void reposition(int width, int length) {
        scanOffsets = new int[length];
        for (int x = 0; x < length; ++x) {
            Rasterizer3D.scanOffsets[x] = width * x;
        }
        originViewX = width / 2;
        originViewY = length / 2;
    }

    public static final void setTextureLoader(TextureLoader var0) {
        textureLoader = var0;
    }

    public static final void setBrightness(double var0) {
        ((TextureProvider)textureLoader).setBrightness(var0);
        Rasterizer3D.Rasterizer3D_buildPalette(var0, 0, 512);
    }

    static final void Rasterizer3D_buildPalette(double var0, int var2, int var3) {
        int var4 = var2 * 128;
        for (int var5 = var2; var5 < var3; ++var5) {
            double var6 = (double)(var5 >> 3) / 64.0 + 0.0078125;
            double var8 = (double)(var5 & 7) / 8.0 + 0.0625;
            for (int var10 = 0; var10 < 128; ++var10) {
                double var11;
                double var13 = var11 = (double)var10 / 128.0;
                double var15 = var11;
                double var17 = var11;
                if (var8 != 0.0) {
                    double var27;
                    double var19 = var11 < 0.5 ? var11 * (1.0 + var8) : var11 + var8 - var11 * var8;
                    double var21 = 2.0 * var11 - var19;
                    double var23 = var6 + 0.3333333333333333;
                    if (var23 > 1.0) {
                        var23 -= 1.0;
                    }
                    if ((var27 = var6 - 0.3333333333333333) < 0.0) {
                        var27 += 1.0;
                    }
                    var13 = 6.0 * var23 < 1.0 ? var21 + (var19 - var21) * 6.0 * var23 : (2.0 * var23 < 1.0 ? var19 : (3.0 * var23 < 2.0 ? var21 + (var19 - var21) * (0.6666666666666666 - var23) * 6.0 : var21));
                    var15 = 6.0 * var6 < 1.0 ? var21 + (var19 - var21) * 6.0 * var6 : (2.0 * var6 < 1.0 ? var19 : (3.0 * var6 < 2.0 ? var21 + (var19 - var21) * (0.6666666666666666 - var6) * 6.0 : var21));
                    var17 = 6.0 * var27 < 1.0 ? var21 + (var19 - var21) * 6.0 * var27 : (2.0 * var27 < 1.0 ? var19 : (3.0 * var27 < 2.0 ? var21 + (var19 - var21) * (0.6666666666666666 - var27) * 6.0 : var21));
                }
                int var29 = (int)(var13 * 256.0);
                int var20 = (int)(var15 * 256.0);
                int var30 = (int)(var17 * 256.0);
                int var22 = var30 + (var20 << 8) + (var29 << 16);
                if ((var22 = Rasterizer3D.adjustBrightness(var22, var0)) == 0) {
                    var22 = 1;
                }
                Rasterizer3D.hslToRgb[var4++] = var22;
            }
        }
    }

    public static int adjustBrightness(int rgb, double intensity) {
        double r = (double)(rgb >> 16) / 256.0;
        double g2 = (double)(rgb >> 8 & 0xFF) / 256.0;
        double b = (double)(rgb & 0xFF) / 256.0;
        r = Math.pow(r, intensity);
        g2 = Math.pow(g2, intensity);
        b = Math.pow(b, intensity);
        int r_byte = (int)(r * 256.0);
        int g_byte = (int)(g2 * 256.0);
        int b_byte = (int)(b * 256.0);
        return (r_byte << 16) + (g_byte << 8) + b_byte;
    }

    private static int adjust_brightness(int rgb, double intensity) {
        double r = (double)(rgb >> 16) / 256.0;
        double g2 = (double)(rgb >> 8 & 0xFF) / 256.0;
        double b = (double)(rgb & 0xFF) / 256.0;
        r = Math.pow(r, intensity);
        g2 = Math.pow(g2, intensity);
        b = Math.pow(b, intensity);
        int r_byte = (int)(r * 256.0);
        int g_byte = (int)(g2 * 256.0);
        int b_byte = (int)(b * 256.0);
        return (r_byte << 16) + (g_byte << 8) + b_byte;
    }

    public static void drawShadedTriangle(int y1, int y2, int y3, int x1, int x2, int x3, int hsl1, int hsl2, int hsl3) {
        if (Client.instance.isGpu() && !renderOnGpu) {
            return;
        }
        int var9 = x2 - x1;
        int var10 = y2 - y1;
        int var11 = x3 - x1;
        int var12 = y3 - y1;
        int var13 = hsl2 - hsl1;
        int var14 = hsl3 - hsl1;
        int var15 = y3 != y2 ? (x3 - x2 << 14) / (y3 - y2) : 0;
        int var16 = y1 != y2 ? (var9 << 14) / var10 : 0;
        int var17 = y1 != y3 ? (var11 << 14) / var12 : 0;
        int var18 = var9 * var12 - var11 * var10;
        if (var18 != 0) {
            int var19 = (var13 * var12 - var14 * var10 << 8) / var18;
            int var20 = (var14 * var9 - var13 * var11 << 8) / var18;
            if (y1 <= y2 && y1 <= y3) {
                if (y1 < Rasterizer2D.bottomY) {
                    if (y2 > Rasterizer2D.bottomY) {
                        y2 = Rasterizer2D.bottomY;
                    }
                    if (y3 > Rasterizer2D.bottomY) {
                        y3 = Rasterizer2D.bottomY;
                    }
                    hsl1 = var19 + ((hsl1 << 8) - x1 * var19);
                    if (y2 < y3) {
                        x3 = x1 <<= 14;
                        if (y1 < 0) {
                            x3 -= y1 * var17;
                            x1 -= y1 * var16;
                            hsl1 -= y1 * var20;
                            y1 = 0;
                        }
                        x2 <<= 14;
                        if (y2 < 0) {
                            x2 -= var15 * y2;
                            y2 = 0;
                        }
                        if (!(y1 != y2 && var17 < var16 || y1 == y2 && var17 > var15)) {
                            y3 -= y2;
                            y2 -= y1;
                            y1 = scanOffsets[y1];
                            while (true) {
                                if (--y2 < 0) {
                                    while (true) {
                                        if (--y3 < 0) {
                                            return;
                                        }
                                        Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y1, 0, 0, x2 >> 14, x3 >> 14, hsl1, var19);
                                        x3 += var17;
                                        x2 += var15;
                                        hsl1 += var20;
                                        y1 += Rasterizer2D.width;
                                    }
                                }
                                Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y1, 0, 0, x1 >> 14, x3 >> 14, hsl1, var19);
                                x3 += var17;
                                x1 += var16;
                                hsl1 += var20;
                                y1 += Rasterizer2D.width;
                            }
                        }
                        y3 -= y2;
                        y2 -= y1;
                        y1 = scanOffsets[y1];
                        while (true) {
                            if (--y2 < 0) {
                                while (true) {
                                    if (--y3 < 0) {
                                        return;
                                    }
                                    Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y1, 0, 0, x3 >> 14, x2 >> 14, hsl1, var19);
                                    x3 += var17;
                                    x2 += var15;
                                    hsl1 += var20;
                                    y1 += Rasterizer2D.width;
                                }
                            }
                            Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y1, 0, 0, x3 >> 14, x1 >> 14, hsl1, var19);
                            x3 += var17;
                            x1 += var16;
                            hsl1 += var20;
                            y1 += Rasterizer2D.width;
                        }
                    }
                    x2 = x1 <<= 14;
                    if (y1 < 0) {
                        x2 -= y1 * var17;
                        x1 -= y1 * var16;
                        hsl1 -= y1 * var20;
                        y1 = 0;
                    }
                    x3 <<= 14;
                    if (y3 < 0) {
                        x3 -= var15 * y3;
                        y3 = 0;
                    }
                    if (y1 != y3 && var17 < var16 || y1 == y3 && var15 > var16) {
                        y2 -= y3;
                        y3 -= y1;
                        y1 = scanOffsets[y1];
                        while (true) {
                            if (--y3 < 0) {
                                while (true) {
                                    if (--y2 < 0) {
                                        return;
                                    }
                                    Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y1, 0, 0, x3 >> 14, x1 >> 14, hsl1, var19);
                                    x3 += var15;
                                    x1 += var16;
                                    hsl1 += var20;
                                    y1 += Rasterizer2D.width;
                                }
                            }
                            Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y1, 0, 0, x2 >> 14, x1 >> 14, hsl1, var19);
                            x2 += var17;
                            x1 += var16;
                            hsl1 += var20;
                            y1 += Rasterizer2D.width;
                        }
                    }
                    y2 -= y3;
                    y3 -= y1;
                    y1 = scanOffsets[y1];
                    while (true) {
                        if (--y3 < 0) {
                            while (true) {
                                if (--y2 < 0) {
                                    return;
                                }
                                Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y1, 0, 0, x1 >> 14, x3 >> 14, hsl1, var19);
                                x3 += var15;
                                x1 += var16;
                                hsl1 += var20;
                                y1 += Rasterizer2D.width;
                            }
                        }
                        Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y1, 0, 0, x1 >> 14, x2 >> 14, hsl1, var19);
                        x2 += var17;
                        x1 += var16;
                        hsl1 += var20;
                        y1 += Rasterizer2D.width;
                    }
                }
            } else if (y2 <= y3) {
                if (y2 < Rasterizer2D.bottomY) {
                    if (y3 > Rasterizer2D.bottomY) {
                        y3 = Rasterizer2D.bottomY;
                    }
                    if (y1 > Rasterizer2D.bottomY) {
                        y1 = Rasterizer2D.bottomY;
                    }
                    hsl2 = var19 + ((hsl2 << 8) - var19 * x2);
                    if (y3 < y1) {
                        x1 = x2 <<= 14;
                        if (y2 < 0) {
                            x1 -= var16 * y2;
                            x2 -= var15 * y2;
                            hsl2 -= var20 * y2;
                            y2 = 0;
                        }
                        x3 <<= 14;
                        if (y3 < 0) {
                            x3 -= var17 * y3;
                            y3 = 0;
                        }
                        if (!(y3 != y2 && var16 < var15 || y3 == y2 && var16 > var17)) {
                            y1 -= y3;
                            y3 -= y2;
                            y2 = scanOffsets[y2];
                            while (true) {
                                if (--y3 < 0) {
                                    while (true) {
                                        if (--y1 < 0) {
                                            return;
                                        }
                                        Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y2, 0, 0, x3 >> 14, x1 >> 14, hsl2, var19);
                                        x1 += var16;
                                        x3 += var17;
                                        hsl2 += var20;
                                        y2 += Rasterizer2D.width;
                                    }
                                }
                                Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y2, 0, 0, x2 >> 14, x1 >> 14, hsl2, var19);
                                x1 += var16;
                                x2 += var15;
                                hsl2 += var20;
                                y2 += Rasterizer2D.width;
                            }
                        }
                        y1 -= y3;
                        y3 -= y2;
                        y2 = scanOffsets[y2];
                        while (true) {
                            if (--y3 < 0) {
                                while (true) {
                                    if (--y1 < 0) {
                                        return;
                                    }
                                    Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y2, 0, 0, x1 >> 14, x3 >> 14, hsl2, var19);
                                    x1 += var16;
                                    x3 += var17;
                                    hsl2 += var20;
                                    y2 += Rasterizer2D.width;
                                }
                            }
                            Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y2, 0, 0, x1 >> 14, x2 >> 14, hsl2, var19);
                            x1 += var16;
                            x2 += var15;
                            hsl2 += var20;
                            y2 += Rasterizer2D.width;
                        }
                    }
                    x3 = x2 <<= 14;
                    if (y2 < 0) {
                        x3 -= var16 * y2;
                        x2 -= var15 * y2;
                        hsl2 -= var20 * y2;
                        y2 = 0;
                    }
                    x1 <<= 14;
                    if (y1 < 0) {
                        x1 -= y1 * var17;
                        y1 = 0;
                    }
                    if (var16 < var15) {
                        y3 -= y1;
                        y1 -= y2;
                        y2 = scanOffsets[y2];
                        while (true) {
                            if (--y1 < 0) {
                                while (true) {
                                    if (--y3 < 0) {
                                        return;
                                    }
                                    Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y2, 0, 0, x1 >> 14, x2 >> 14, hsl2, var19);
                                    x1 += var17;
                                    x2 += var15;
                                    hsl2 += var20;
                                    y2 += Rasterizer2D.width;
                                }
                            }
                            Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y2, 0, 0, x3 >> 14, x2 >> 14, hsl2, var19);
                            x3 += var16;
                            x2 += var15;
                            hsl2 += var20;
                            y2 += Rasterizer2D.width;
                        }
                    }
                    y3 -= y1;
                    y1 -= y2;
                    y2 = scanOffsets[y2];
                    while (true) {
                        if (--y1 < 0) {
                            while (true) {
                                if (--y3 < 0) {
                                    return;
                                }
                                Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y2, 0, 0, x2 >> 14, x1 >> 14, hsl2, var19);
                                x1 += var17;
                                x2 += var15;
                                hsl2 += var20;
                                y2 += Rasterizer2D.width;
                            }
                        }
                        Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y2, 0, 0, x2 >> 14, x3 >> 14, hsl2, var19);
                        x3 += var16;
                        x2 += var15;
                        hsl2 += var20;
                        y2 += Rasterizer2D.width;
                    }
                }
            } else if (y3 < Rasterizer2D.bottomY) {
                if (y1 > Rasterizer2D.bottomY) {
                    y1 = Rasterizer2D.bottomY;
                }
                if (y2 > Rasterizer2D.bottomY) {
                    y2 = Rasterizer2D.bottomY;
                }
                hsl3 = var19 + ((hsl3 << 8) - x3 * var19);
                if (y1 < y2) {
                    x2 = x3 <<= 14;
                    if (y3 < 0) {
                        x2 -= var15 * y3;
                        x3 -= var17 * y3;
                        hsl3 -= var20 * y3;
                        y3 = 0;
                    }
                    x1 <<= 14;
                    if (y1 < 0) {
                        x1 -= y1 * var16;
                        y1 = 0;
                    }
                    if (var15 < var17) {
                        y2 -= y1;
                        y1 -= y3;
                        y3 = scanOffsets[y3];
                        while (true) {
                            if (--y1 < 0) {
                                while (true) {
                                    if (--y2 < 0) {
                                        return;
                                    }
                                    Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y3, 0, 0, x2 >> 14, x1 >> 14, hsl3, var19);
                                    x2 += var15;
                                    x1 += var16;
                                    hsl3 += var20;
                                    y3 += Rasterizer2D.width;
                                }
                            }
                            Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y3, 0, 0, x2 >> 14, x3 >> 14, hsl3, var19);
                            x2 += var15;
                            x3 += var17;
                            hsl3 += var20;
                            y3 += Rasterizer2D.width;
                        }
                    }
                    y2 -= y1;
                    y1 -= y3;
                    y3 = scanOffsets[y3];
                    while (true) {
                        if (--y1 < 0) {
                            while (true) {
                                if (--y2 < 0) {
                                    return;
                                }
                                Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y3, 0, 0, x1 >> 14, x2 >> 14, hsl3, var19);
                                x2 += var15;
                                x1 += var16;
                                hsl3 += var20;
                                y3 += Rasterizer2D.width;
                            }
                        }
                        Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y3, 0, 0, x3 >> 14, x2 >> 14, hsl3, var19);
                        x2 += var15;
                        x3 += var17;
                        hsl3 += var20;
                        y3 += Rasterizer2D.width;
                    }
                }
                x1 = x3 <<= 14;
                if (y3 < 0) {
                    x1 -= var15 * y3;
                    x3 -= var17 * y3;
                    hsl3 -= var20 * y3;
                    y3 = 0;
                }
                x2 <<= 14;
                if (y2 < 0) {
                    x2 -= var16 * y2;
                    y2 = 0;
                }
                if (var15 < var17) {
                    y1 -= y2;
                    y2 -= y3;
                    y3 = scanOffsets[y3];
                    while (true) {
                        if (--y2 < 0) {
                            while (true) {
                                if (--y1 < 0) {
                                    return;
                                }
                                Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y3, 0, 0, x2 >> 14, x3 >> 14, hsl3, var19);
                                x2 += var16;
                                x3 += var17;
                                hsl3 += var20;
                                y3 += Rasterizer2D.width;
                            }
                        }
                        Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y3, 0, 0, x1 >> 14, x3 >> 14, hsl3, var19);
                        x1 += var15;
                        x3 += var17;
                        hsl3 += var20;
                        y3 += Rasterizer2D.width;
                    }
                }
                y1 -= y2;
                y2 -= y3;
                y3 = scanOffsets[y3];
                while (true) {
                    if (--y2 < 0) {
                        while (true) {
                            if (--y1 < 0) {
                                return;
                            }
                            Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y3, 0, 0, x3 >> 14, x2 >> 14, hsl3, var19);
                            x2 += var16;
                            x3 += var17;
                            hsl3 += var20;
                            y3 += Rasterizer2D.width;
                        }
                    }
                    Rasterizer3D.drawGouraudScanline(Rasterizer2D.pixels, y3, 0, 0, x3 >> 14, x1 >> 14, hsl3, var19);
                    x1 += var15;
                    x3 += var17;
                    hsl3 += var20;
                    y3 += Rasterizer2D.width;
                }
            }
        }
    }

    public static void drawGouraudScanline(int[] var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7) {
        if (!Client.instance.isResized() && world && var1 <= 259086) {
            var1 += 3064;
        }
        if (textureOutOfDrawingBounds) {
            if (var5 > lastX) {
                var5 = lastX;
            }
            if (var4 < 0) {
                var4 = 0;
            }
        }
        if (var4 < var5) {
            var1 += var4;
            var6 += var4 * var7;
            if (aBoolean1464) {
                var3 = var5 - var4 >> 2;
                var7 <<= 2;
                if (alpha == 0) {
                    if (var3 > 0) {
                        do {
                            var2 = hslToRgb[var6 >> 8];
                            var6 += var7;
                            Rasterizer3D.drawAlpha(var0, var1++, var2, 255);
                            Rasterizer3D.drawAlpha(var0, var1++, var2, 255);
                            Rasterizer3D.drawAlpha(var0, var1++, var2, 255);
                            Rasterizer3D.drawAlpha(var0, var1++, var2, 255);
                        } while (--var3 > 0);
                    }
                    if ((var3 = var5 - var4 & 3) > 0) {
                        var2 = hslToRgb[var6 >> 8];
                        do {
                            Rasterizer3D.drawAlpha(var0, var1++, var2, 255);
                        } while (--var3 > 0);
                    }
                } else {
                    int var10;
                    int var8 = alpha;
                    int var9 = 256 - alpha;
                    if (var3 > 0) {
                        do {
                            var2 = hslToRgb[var6 >> 8];
                            var6 += var7;
                            var2 = (var9 * (var2 & 0xFF00) >> 8 & 0xFF00) + (var9 * (var2 & 0xFF00FF) >> 8 & 0xFF00FF);
                            var10 = var0[var1];
                            Rasterizer3D.drawAlpha(var0, var1++, ((var10 & 0xFF00FF) * var8 >> 8 & 0xFF00FF) + var2 + (var8 * (var10 & 0xFF00) >> 8 & 0xFF00), 255);
                            var10 = var0[var1];
                            Rasterizer3D.drawAlpha(var0, var1++, ((var10 & 0xFF00FF) * var8 >> 8 & 0xFF00FF) + var2 + (var8 * (var10 & 0xFF00) >> 8 & 0xFF00), 255);
                            var10 = var0[var1];
                            Rasterizer3D.drawAlpha(var0, var1++, ((var10 & 0xFF00FF) * var8 >> 8 & 0xFF00FF) + var2 + (var8 * (var10 & 0xFF00) >> 8 & 0xFF00), 255);
                            var10 = var0[var1];
                            Rasterizer3D.drawAlpha(var0, var1++, ((var10 & 0xFF00FF) * var8 >> 8 & 0xFF00FF) + var2 + (var8 * (var10 & 0xFF00) >> 8 & 0xFF00), 255);
                        } while (--var3 > 0);
                    }
                    if ((var3 = var5 - var4 & 3) > 0) {
                        var2 = hslToRgb[var6 >> 8];
                        var2 = (var9 * (var2 & 0xFF00) >> 8 & 0xFF00) + (var9 * (var2 & 0xFF00FF) >> 8 & 0xFF00FF);
                        do {
                            var10 = var0[var1];
                            Rasterizer3D.drawAlpha(var0, var1++, ((var10 & 0xFF00FF) * var8 >> 8 & 0xFF00FF) + var2 + (var8 * (var10 & 0xFF00) >> 8 & 0xFF00), 255);
                        } while (--var3 > 0);
                    }
                }
            } else {
                var3 = var5 - var4;
                if (alpha == 0) {
                    do {
                        Rasterizer3D.drawAlpha(var0, var1++, hslToRgb[var6 >> 8], 255);
                        var6 += var7;
                    } while (--var3 > 0);
                } else {
                    int var8 = alpha;
                    int var9 = 256 - alpha;
                    do {
                        var2 = hslToRgb[var6 >> 8];
                        var6 += var7;
                        var2 = (var9 * (var2 & 0xFF00) >> 8 & 0xFF00) + (var9 * (var2 & 0xFF00FF) >> 8 & 0xFF00FF);
                        int var10 = var0[var1];
                        Rasterizer3D.drawAlpha(var0, var1++, ((var10 & 0xFF00FF) * var8 >> 8 & 0xFF00FF) + var2 + (var8 * (var10 & 0xFF00) >> 8 & 0xFF00), 255);
                    } while (--var3 > 0);
                }
            }
        }
    }

    public static void drawFlatTriangle(int y_a, int y_b, int y_c, int x_a, int x_b, int x_c, int k1) {
        if (Client.instance.isGpu() && !renderOnGpu) {
            return;
        }
        int a_to_b = 0;
        if (y_b != y_a) {
            a_to_b = (x_b - x_a << 16) / (y_b - y_a);
        }
        int b_to_c = 0;
        if (y_c != y_b) {
            b_to_c = (x_c - x_b << 16) / (y_c - y_b);
        }
        int c_to_a = 0;
        if (y_c != y_a) {
            c_to_a = (x_a - x_c << 16) / (y_a - y_c);
        }
        float b_aX = x_b - x_a;
        float b_aY = y_b - y_a;
        float c_aX = x_c - x_a;
        float c_aY = y_c - y_a;
        if (y_a <= y_b && y_a <= y_c) {
            if (y_a >= Rasterizer2D.bottomY) {
                return;
            }
            if (y_b > Rasterizer2D.bottomY) {
                y_b = Rasterizer2D.bottomY;
            }
            if (y_c > Rasterizer2D.bottomY) {
                y_c = Rasterizer2D.bottomY;
            }
            if (y_b < y_c) {
                x_c = x_a <<= 16;
                if (y_a < 0) {
                    x_c -= c_to_a * y_a;
                    x_a -= a_to_b * y_a;
                    y_a = 0;
                }
                x_b <<= 16;
                if (y_b < 0) {
                    x_b -= b_to_c * y_b;
                    y_b = 0;
                }
                if (y_a != y_b && c_to_a < a_to_b || y_a == y_b && c_to_a > b_to_c) {
                    y_c -= y_b;
                    y_b -= y_a;
                    y_a = scanOffsets[y_a];
                    while (--y_b >= 0) {
                        Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_a, k1, x_c >> 16, x_a >> 16);
                        x_c += c_to_a;
                        x_a += a_to_b;
                        y_a += Rasterizer2D.width;
                    }
                    while (--y_c >= 0) {
                        Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_a, k1, x_c >> 16, x_b >> 16);
                        x_c += c_to_a;
                        x_b += b_to_c;
                        y_a += Rasterizer2D.width;
                    }
                    return;
                }
                y_c -= y_b;
                y_b -= y_a;
                y_a = scanOffsets[y_a];
                while (--y_b >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_a, k1, x_a >> 16, x_c >> 16);
                    x_c += c_to_a;
                    x_a += a_to_b;
                    y_a += Rasterizer2D.width;
                }
                while (--y_c >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_a, k1, x_b >> 16, x_c >> 16);
                    x_c += c_to_a;
                    x_b += b_to_c;
                    y_a += Rasterizer2D.width;
                }
                return;
            }
            x_b = x_a <<= 16;
            if (y_a < 0) {
                x_b -= c_to_a * y_a;
                x_a -= a_to_b * y_a;
                y_a = 0;
            }
            x_c <<= 16;
            if (y_c < 0) {
                x_c -= b_to_c * y_c;
                y_c = 0;
            }
            if (y_a != y_c && c_to_a < a_to_b || y_a == y_c && b_to_c > a_to_b) {
                y_b -= y_c;
                y_c -= y_a;
                y_a = scanOffsets[y_a];
                while (--y_c >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_a, k1, x_b >> 16, x_a >> 16);
                    x_b += c_to_a;
                    x_a += a_to_b;
                    y_a += Rasterizer2D.width;
                }
                while (--y_b >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_a, k1, x_c >> 16, x_a >> 16);
                    x_c += b_to_c;
                    x_a += a_to_b;
                    y_a += Rasterizer2D.width;
                }
                return;
            }
            y_b -= y_c;
            y_c -= y_a;
            y_a = scanOffsets[y_a];
            while (--y_c >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_a, k1, x_a >> 16, x_b >> 16);
                x_b += c_to_a;
                x_a += a_to_b;
                y_a += Rasterizer2D.width;
            }
            while (--y_b >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_a, k1, x_a >> 16, x_c >> 16);
                x_c += b_to_c;
                x_a += a_to_b;
                y_a += Rasterizer2D.width;
            }
            return;
        }
        if (y_b <= y_c) {
            if (y_b >= Rasterizer2D.bottomY) {
                return;
            }
            if (y_c > Rasterizer2D.bottomY) {
                y_c = Rasterizer2D.bottomY;
            }
            if (y_a > Rasterizer2D.bottomY) {
                y_a = Rasterizer2D.bottomY;
            }
            if (y_c < y_a) {
                x_a = x_b <<= 16;
                if (y_b < 0) {
                    x_a -= a_to_b * y_b;
                    x_b -= b_to_c * y_b;
                    y_b = 0;
                }
                x_c <<= 16;
                if (y_c < 0) {
                    x_c -= c_to_a * y_c;
                    y_c = 0;
                }
                if (y_b != y_c && a_to_b < b_to_c || y_b == y_c && a_to_b > c_to_a) {
                    y_a -= y_c;
                    y_c -= y_b;
                    y_b = scanOffsets[y_b];
                    while (--y_c >= 0) {
                        Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_b, k1, x_a >> 16, x_b >> 16);
                        x_a += a_to_b;
                        x_b += b_to_c;
                        y_b += Rasterizer2D.width;
                    }
                    while (--y_a >= 0) {
                        Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_b, k1, x_a >> 16, x_c >> 16);
                        x_a += a_to_b;
                        x_c += c_to_a;
                        y_b += Rasterizer2D.width;
                    }
                    return;
                }
                y_a -= y_c;
                y_c -= y_b;
                y_b = scanOffsets[y_b];
                while (--y_c >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_b, k1, x_b >> 16, x_a >> 16);
                    x_a += a_to_b;
                    x_b += b_to_c;
                    y_b += Rasterizer2D.width;
                }
                while (--y_a >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_b, k1, x_c >> 16, x_a >> 16);
                    x_a += a_to_b;
                    x_c += c_to_a;
                    y_b += Rasterizer2D.width;
                }
                return;
            }
            x_c = x_b <<= 16;
            if (y_b < 0) {
                x_c -= a_to_b * y_b;
                x_b -= b_to_c * y_b;
                y_b = 0;
            }
            x_a <<= 16;
            if (y_a < 0) {
                x_a -= c_to_a * y_a;
                y_a = 0;
            }
            if (a_to_b < b_to_c) {
                y_c -= y_a;
                y_a -= y_b;
                y_b = scanOffsets[y_b];
                while (--y_a >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_b, k1, x_c >> 16, x_b >> 16);
                    x_c += a_to_b;
                    x_b += b_to_c;
                    y_b += Rasterizer2D.width;
                }
                while (--y_c >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_b, k1, x_a >> 16, x_b >> 16);
                    x_a += c_to_a;
                    x_b += b_to_c;
                    y_b += Rasterizer2D.width;
                }
                return;
            }
            y_c -= y_a;
            y_a -= y_b;
            y_b = scanOffsets[y_b];
            while (--y_a >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_b, k1, x_b >> 16, x_c >> 16);
                x_c += a_to_b;
                x_b += b_to_c;
                y_b += Rasterizer2D.width;
            }
            while (--y_c >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_b, k1, x_b >> 16, x_a >> 16);
                x_a += c_to_a;
                x_b += b_to_c;
                y_b += Rasterizer2D.width;
            }
            return;
        }
        if (y_c >= Rasterizer2D.bottomY) {
            return;
        }
        if (y_a > Rasterizer2D.bottomY) {
            y_a = Rasterizer2D.bottomY;
        }
        if (y_b > Rasterizer2D.bottomY) {
            y_b = Rasterizer2D.bottomY;
        }
        if (y_a < y_b) {
            x_b = x_c <<= 16;
            if (y_c < 0) {
                x_b -= b_to_c * y_c;
                x_c -= c_to_a * y_c;
                y_c = 0;
            }
            x_a <<= 16;
            if (y_a < 0) {
                x_a -= a_to_b * y_a;
                y_a = 0;
            }
            if (b_to_c < c_to_a) {
                y_b -= y_a;
                y_a -= y_c;
                y_c = scanOffsets[y_c];
                while (--y_a >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_c, k1, x_b >> 16, x_c >> 16);
                    x_b += b_to_c;
                    x_c += c_to_a;
                    y_c += Rasterizer2D.width;
                }
                while (--y_b >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_c, k1, x_b >> 16, x_a >> 16);
                    x_b += b_to_c;
                    x_a += a_to_b;
                    y_c += Rasterizer2D.width;
                }
                return;
            }
            y_b -= y_a;
            y_a -= y_c;
            y_c = scanOffsets[y_c];
            while (--y_a >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_c, k1, x_c >> 16, x_b >> 16);
                x_b += b_to_c;
                x_c += c_to_a;
                y_c += Rasterizer2D.width;
            }
            while (--y_b >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_c, k1, x_a >> 16, x_b >> 16);
                x_b += b_to_c;
                x_a += a_to_b;
                y_c += Rasterizer2D.width;
            }
            return;
        }
        x_a = x_c <<= 16;
        if (y_c < 0) {
            x_a -= b_to_c * y_c;
            x_c -= c_to_a * y_c;
            y_c = 0;
        }
        x_b <<= 16;
        if (y_b < 0) {
            x_b -= a_to_b * y_b;
            y_b = 0;
        }
        if (b_to_c < c_to_a) {
            y_a -= y_b;
            y_b -= y_c;
            y_c = scanOffsets[y_c];
            while (--y_b >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_c, k1, x_a >> 16, x_c >> 16);
                x_a += b_to_c;
                x_c += c_to_a;
                y_c += Rasterizer2D.width;
            }
            while (--y_a >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_c, k1, x_b >> 16, x_c >> 16);
                x_b += a_to_b;
                x_c += c_to_a;
                y_c += Rasterizer2D.width;
            }
            return;
        }
        y_a -= y_b;
        y_b -= y_c;
        y_c = scanOffsets[y_c];
        while (--y_b >= 0) {
            Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_c, k1, x_c >> 16, x_a >> 16);
            x_a += b_to_c;
            x_c += c_to_a;
            y_c += Rasterizer2D.width;
        }
        while (--y_a >= 0) {
            Rasterizer3D.drawFlatTexturedScanline(Rasterizer2D.pixels, y_c, k1, x_c >> 16, x_b >> 16);
            x_b += a_to_b;
            x_c += c_to_a;
            y_c += Rasterizer2D.width;
        }
    }

    private static int applyLighting(int color, double lightFactor) {
        int r = color >> 16 & 0xFF;
        int g2 = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = (int)((double)r * lightFactor);
        g2 = (int)((double)g2 * lightFactor);
        b = (int)((double)b * lightFactor);
        return r << 16 | g2 << 8 | b;
    }

    private static double[] calculateBarycentricCoordinates(int x, int y, int[] v0, int[] v1, int[] v2) {
        double denominator = (v1[1] - v2[1]) * (v0[0] - v2[0]) + (v2[0] - v1[0]) * (v0[1] - v2[1]);
        double a = (double)((v1[1] - v2[1]) * (x - v2[0]) + (v2[0] - v1[0]) * (y - v2[1])) / denominator;
        double b = (double)((v2[1] - v0[1]) * (x - v2[0]) + (v0[0] - v2[0]) * (y - v2[1])) / denominator;
        double c = 1.0 - a - b;
        return new double[]{a, b, c};
    }

    private static int calculateSpecular(int color, double lightAngle, double shininess) {
        double specular = Math.pow(Math.max(0.0, Math.cos(lightAngle)), shininess);
        int r = Math.min(255, (int)((double)(color >> 16 & 0xFF) + specular * 255.0));
        int g2 = Math.min(255, (int)((double)(color >> 8 & 0xFF) + specular * 255.0));
        int b = Math.min(255, (int)((double)(color & 0xFF) + specular * 255.0));
        return r << 16 | g2 << 8 | b;
    }

    private static void drawFlatTexturedScanline(int[] dest, int dest_off, int loops, int start_x, int end_x) {
        if (!Client.instance.isResized() && world && dest_off <= 259086) {
            dest_off += 3064;
        }
        if (textureOutOfDrawingBounds) {
            if (end_x > Rasterizer2D.lastX) {
                end_x = Rasterizer2D.lastX;
            }
            if (start_x < 0) {
                start_x = 0;
            }
        }
        if (start_x >= end_x) {
            return;
        }
        dest_off += start_x;
        int rgb = end_x - start_x >> 2;
        if (alpha == 0) {
            while (--rgb >= 0) {
                for (int i = 0; i < 4; ++i) {
                    Rasterizer3D.drawAlpha(dest, dest_off, loops, 255);
                    ++dest_off;
                }
            }
            rgb = end_x - start_x & 3;
            while (--rgb >= 0) {
                Rasterizer3D.drawAlpha(dest, dest_off, loops, 255);
                ++dest_off;
            }
            return;
        }
        int dest_alpha = alpha;
        int src_alpha = 256 - alpha;
        loops = ((loops & 0xFF00FF) * src_alpha >> 8 & 0xFF00FF) + ((loops & 0xFF00) * src_alpha >> 8 & 0xFF00);
        while (--rgb >= 0) {
            for (int i = 0; i < 4; ++i) {
                Rasterizer3D.drawAlpha(dest, dest_off, loops + ((dest[dest_off] & 0xFF00FF) * dest_alpha >> 8 & 0xFF00FF) + ((dest[dest_off] & 0xFF00) * dest_alpha >> 8 & 0xFF00), 255);
                ++dest_off;
            }
        }
        rgb = end_x - start_x & 3;
        while (--rgb >= 0) {
            Rasterizer3D.drawAlpha(dest, dest_off, loops + ((dest[dest_off] & 0xFF00FF) * dest_alpha >> 8 & 0xFF00FF) + ((dest[dest_off] & 0xFF00) * dest_alpha >> 8 & 0xFF00), 255);
            ++dest_off;
        }
    }

    public static void drawTexturedTriangle(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int textureID) {
        if (Client.instance.isGpu() && !renderOnGpu) {
            return;
        }
        int[] texturePixels = textureLoader.getTexturePixels(textureID);
        if (texturePixels == null) {
            int averageRGB = textureLoader.getAverageTextureRGB(textureID);
            Rasterizer3D.drawShadedTriangle(var0, var1, var2, var3, var4, var5, Rasterizer3D.light(averageRGB, var6), Rasterizer3D.light(averageRGB, var7), Rasterizer3D.light(averageRGB, var8));
        } else {
            int var32;
            lowMem = textureLoader.isLowDetail(textureID);
            isTransparent = textureLoader.isTransparent(textureID);
            int var21 = var4 - var3;
            int var26 = var1 - var0;
            int var27 = var5 - var3;
            int var31 = var2 - var0;
            int var28 = var7 - var6;
            int var23 = var8 - var6;
            int var29 = 0;
            if (var1 != var0) {
                var29 = (var4 - var3 << 16) / (var1 - var0);
            }
            int var30 = 0;
            if (var2 != var1) {
                var30 = (var5 - var4 << 16) / (var2 - var1);
            }
            int var22 = 0;
            if (var2 != var0) {
                var22 = (var3 - var5 << 16) / (var0 - var2);
            }
            if ((var32 = var21 * var31 - var27 * var26) != 0) {
                int var41 = (var28 * var31 - var23 * var26 << 9) / var32;
                int var20 = (var23 * var21 - var28 * var27 << 9) / var32;
                var10 = var9 - var10;
                var13 = var12 - var13;
                var16 = var15 - var16;
                int FOV = aBoolean1464 ? fieldOfView : 512;
                int var24 = (var11 -= var9) * var12 - (var14 -= var12) * var9 << 14;
                int var38 = (int)(((long)(var14 * var15 - (var17 -= var15) * var12) << 3 << 14) / (long)FOV);
                int var25 = (int)(((long)(var17 * var9 - var11 * var15) << 14) / (long)FOV);
                int var36 = var10 * var12 - var13 * var9 << 14;
                int var39 = (int)(((long)(var13 * var15 - var16 * var12) << 3 << 14) / (long)FOV);
                int var37 = (int)(((long)(var16 * var9 - var10 * var15) << 14) / (long)FOV);
                int var33 = var13 * var11 - var10 * var14 << 14;
                int var40 = (int)(((long)(var16 * var14 - var13 * var17) << 3 << 14) / (long)FOV);
                int var34 = (int)(((long)(var10 * var17 - var16 * var11) << 14) / (long)FOV);
                if (var0 <= var1 && var0 <= var2) {
                    if (var0 < Rasterizer2D.bottomY) {
                        if (var1 > Rasterizer2D.bottomY) {
                            var1 = Rasterizer2D.bottomY;
                        }
                        if (var2 > Rasterizer2D.bottomY) {
                            var2 = Rasterizer2D.bottomY;
                        }
                        var6 = (var6 << 9) - var41 * var3 + var41;
                        if (var1 < var2) {
                            var5 = var3 <<= 16;
                            if (var0 < 0) {
                                var5 -= var22 * var0;
                                var3 -= var29 * var0;
                                var6 -= var20 * var0;
                                var0 = 0;
                            }
                            var4 <<= 16;
                            if (var1 < 0) {
                                var4 -= var30 * var1;
                                var1 = 0;
                            }
                            int var35 = var0 - originViewY;
                            var24 += var25 * var35;
                            var36 += var37 * var35;
                            var33 += var34 * var35;
                            if (!(var0 != var1 && var22 < var29 || var0 == var1 && var22 > var30)) {
                                var2 -= var1;
                                var1 -= var0;
                                var0 = scanOffsets[var0];
                                while (true) {
                                    if (--var1 < 0) {
                                        while (true) {
                                            if (--var2 < 0) {
                                                return;
                                            }
                                            Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var0, var4 >> 16, var5 >> 16, var6, var41, var24, var36, var33, var38, var39, var40);
                                            var5 += var22;
                                            var4 += var30;
                                            var6 += var20;
                                            var0 += Rasterizer2D.width;
                                            var24 += var25;
                                            var36 += var37;
                                            var33 += var34;
                                        }
                                    }
                                    Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var0, var3 >> 16, var5 >> 16, var6, var41, var24, var36, var33, var38, var39, var40);
                                    var5 += var22;
                                    var3 += var29;
                                    var6 += var20;
                                    var0 += Rasterizer2D.width;
                                    var24 += var25;
                                    var36 += var37;
                                    var33 += var34;
                                }
                            }
                            var2 -= var1;
                            var1 -= var0;
                            var0 = scanOffsets[var0];
                            while (true) {
                                if (--var1 < 0) {
                                    while (true) {
                                        if (--var2 < 0) {
                                            return;
                                        }
                                        Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var0, var5 >> 16, var4 >> 16, var6, var41, var24, var36, var33, var38, var39, var40);
                                        var5 += var22;
                                        var4 += var30;
                                        var6 += var20;
                                        var0 += Rasterizer2D.width;
                                        var24 += var25;
                                        var36 += var37;
                                        var33 += var34;
                                    }
                                }
                                Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var0, var5 >> 16, var3 >> 16, var6, var41, var24, var36, var33, var38, var39, var40);
                                var5 += var22;
                                var3 += var29;
                                var6 += var20;
                                var0 += Rasterizer2D.width;
                                var24 += var25;
                                var36 += var37;
                                var33 += var34;
                            }
                        }
                        var4 = var3 <<= 16;
                        if (var0 < 0) {
                            var4 -= var22 * var0;
                            var3 -= var29 * var0;
                            var6 -= var20 * var0;
                            var0 = 0;
                        }
                        var5 <<= 16;
                        if (var2 < 0) {
                            var5 -= var30 * var2;
                            var2 = 0;
                        }
                        int var35 = var0 - originViewY;
                        var24 += var25 * var35;
                        var36 += var37 * var35;
                        var33 += var34 * var35;
                        if (!(var0 != var2 && var22 < var29 || var0 == var2 && var30 > var29)) {
                            var1 -= var2;
                            var2 -= var0;
                            var0 = scanOffsets[var0];
                            while (true) {
                                if (--var2 < 0) {
                                    while (true) {
                                        if (--var1 < 0) {
                                            return;
                                        }
                                        Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var0, var3 >> 16, var5 >> 16, var6, var41, var24, var36, var33, var38, var39, var40);
                                        var5 += var30;
                                        var3 += var29;
                                        var6 += var20;
                                        var0 += Rasterizer2D.width;
                                        var24 += var25;
                                        var36 += var37;
                                        var33 += var34;
                                    }
                                }
                                Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var0, var3 >> 16, var4 >> 16, var6, var41, var24, var36, var33, var38, var39, var40);
                                var4 += var22;
                                var3 += var29;
                                var6 += var20;
                                var0 += Rasterizer2D.width;
                                var24 += var25;
                                var36 += var37;
                                var33 += var34;
                            }
                        }
                        var1 -= var2;
                        var2 -= var0;
                        var0 = scanOffsets[var0];
                        while (true) {
                            if (--var2 < 0) {
                                while (true) {
                                    if (--var1 < 0) {
                                        return;
                                    }
                                    Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var0, var5 >> 16, var3 >> 16, var6, var41, var24, var36, var33, var38, var39, var40);
                                    var5 += var30;
                                    var3 += var29;
                                    var6 += var20;
                                    var0 += Rasterizer2D.width;
                                    var24 += var25;
                                    var36 += var37;
                                    var33 += var34;
                                }
                            }
                            Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var0, var4 >> 16, var3 >> 16, var6, var41, var24, var36, var33, var38, var39, var40);
                            var4 += var22;
                            var3 += var29;
                            var6 += var20;
                            var0 += Rasterizer2D.width;
                            var24 += var25;
                            var36 += var37;
                            var33 += var34;
                        }
                    }
                } else if (var1 <= var2) {
                    if (var1 < Rasterizer2D.bottomY) {
                        if (var2 > Rasterizer2D.bottomY) {
                            var2 = Rasterizer2D.bottomY;
                        }
                        if (var0 > Rasterizer2D.bottomY) {
                            var0 = Rasterizer2D.bottomY;
                        }
                        var7 = (var7 << 9) - var41 * var4 + var41;
                        if (var2 < var0) {
                            var3 = var4 <<= 16;
                            if (var1 < 0) {
                                var3 -= var29 * var1;
                                var4 -= var30 * var1;
                                var7 -= var20 * var1;
                                var1 = 0;
                            }
                            var5 <<= 16;
                            if (var2 < 0) {
                                var5 -= var22 * var2;
                                var2 = 0;
                            }
                            int var35 = var1 - originViewY;
                            var24 += var25 * var35;
                            var36 += var37 * var35;
                            var33 += var34 * var35;
                            if (!(var1 != var2 && var29 < var30 || var1 == var2 && var29 > var22)) {
                                var0 -= var2;
                                var2 -= var1;
                                var1 = scanOffsets[var1];
                                while (true) {
                                    if (--var2 < 0) {
                                        while (true) {
                                            if (--var0 < 0) {
                                                return;
                                            }
                                            Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var1, var5 >> 16, var3 >> 16, var7, var41, var24, var36, var33, var38, var39, var40);
                                            var3 += var29;
                                            var5 += var22;
                                            var7 += var20;
                                            var1 += Rasterizer2D.width;
                                            var24 += var25;
                                            var36 += var37;
                                            var33 += var34;
                                        }
                                    }
                                    Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var1, var4 >> 16, var3 >> 16, var7, var41, var24, var36, var33, var38, var39, var40);
                                    var3 += var29;
                                    var4 += var30;
                                    var7 += var20;
                                    var1 += Rasterizer2D.width;
                                    var24 += var25;
                                    var36 += var37;
                                    var33 += var34;
                                }
                            }
                            var0 -= var2;
                            var2 -= var1;
                            var1 = scanOffsets[var1];
                            while (true) {
                                if (--var2 < 0) {
                                    while (true) {
                                        if (--var0 < 0) {
                                            return;
                                        }
                                        Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var1, var3 >> 16, var5 >> 16, var7, var41, var24, var36, var33, var38, var39, var40);
                                        var3 += var29;
                                        var5 += var22;
                                        var7 += var20;
                                        var1 += Rasterizer2D.width;
                                        var24 += var25;
                                        var36 += var37;
                                        var33 += var34;
                                    }
                                }
                                Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var1, var3 >> 16, var4 >> 16, var7, var41, var24, var36, var33, var38, var39, var40);
                                var3 += var29;
                                var4 += var30;
                                var7 += var20;
                                var1 += Rasterizer2D.width;
                                var24 += var25;
                                var36 += var37;
                                var33 += var34;
                            }
                        }
                        var5 = var4 <<= 16;
                        if (var1 < 0) {
                            var5 -= var29 * var1;
                            var4 -= var30 * var1;
                            var7 -= var20 * var1;
                            var1 = 0;
                        }
                        var3 <<= 16;
                        if (var0 < 0) {
                            var3 -= var22 * var0;
                            var0 = 0;
                        }
                        int var35 = var1 - originViewY;
                        var24 += var25 * var35;
                        var36 += var37 * var35;
                        var33 += var34 * var35;
                        if (var29 < var30) {
                            var2 -= var0;
                            var0 -= var1;
                            var1 = scanOffsets[var1];
                            while (true) {
                                if (--var0 < 0) {
                                    while (true) {
                                        if (--var2 < 0) {
                                            return;
                                        }
                                        Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var1, var3 >> 16, var4 >> 16, var7, var41, var24, var36, var33, var38, var39, var40);
                                        var3 += var22;
                                        var4 += var30;
                                        var7 += var20;
                                        var1 += Rasterizer2D.width;
                                        var24 += var25;
                                        var36 += var37;
                                        var33 += var34;
                                    }
                                }
                                Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var1, var5 >> 16, var4 >> 16, var7, var41, var24, var36, var33, var38, var39, var40);
                                var5 += var29;
                                var4 += var30;
                                var7 += var20;
                                var1 += Rasterizer2D.width;
                                var24 += var25;
                                var36 += var37;
                                var33 += var34;
                            }
                        }
                        var2 -= var0;
                        var0 -= var1;
                        var1 = scanOffsets[var1];
                        while (true) {
                            if (--var0 < 0) {
                                while (true) {
                                    if (--var2 < 0) {
                                        return;
                                    }
                                    Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var1, var4 >> 16, var3 >> 16, var7, var41, var24, var36, var33, var38, var39, var40);
                                    var3 += var22;
                                    var4 += var30;
                                    var7 += var20;
                                    var1 += Rasterizer2D.width;
                                    var24 += var25;
                                    var36 += var37;
                                    var33 += var34;
                                }
                            }
                            Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var1, var4 >> 16, var5 >> 16, var7, var41, var24, var36, var33, var38, var39, var40);
                            var5 += var29;
                            var4 += var30;
                            var7 += var20;
                            var1 += Rasterizer2D.width;
                            var24 += var25;
                            var36 += var37;
                            var33 += var34;
                        }
                    }
                } else if (var2 < Rasterizer2D.bottomY) {
                    if (var0 > Rasterizer2D.bottomY) {
                        var0 = Rasterizer2D.bottomY;
                    }
                    if (var1 > Rasterizer2D.bottomY) {
                        var1 = Rasterizer2D.bottomY;
                    }
                    var8 = (var8 << 9) - var41 * var5 + var41;
                    if (var0 < var1) {
                        var4 = var5 <<= 16;
                        if (var2 < 0) {
                            var4 -= var30 * var2;
                            var5 -= var22 * var2;
                            var8 -= var20 * var2;
                            var2 = 0;
                        }
                        var3 <<= 16;
                        if (var0 < 0) {
                            var3 -= var29 * var0;
                            var0 = 0;
                        }
                        int var35 = var2 - originViewY;
                        var24 += var25 * var35;
                        var36 += var37 * var35;
                        var33 += var34 * var35;
                        if (var30 < var22) {
                            var1 -= var0;
                            var0 -= var2;
                            var2 = scanOffsets[var2];
                            while (true) {
                                if (--var0 < 0) {
                                    while (true) {
                                        if (--var1 < 0) {
                                            return;
                                        }
                                        Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var2, var4 >> 16, var3 >> 16, var8, var41, var24, var36, var33, var38, var39, var40);
                                        var4 += var30;
                                        var3 += var29;
                                        var8 += var20;
                                        var2 += Rasterizer2D.width;
                                        var24 += var25;
                                        var36 += var37;
                                        var33 += var34;
                                    }
                                }
                                Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var2, var4 >> 16, var5 >> 16, var8, var41, var24, var36, var33, var38, var39, var40);
                                var4 += var30;
                                var5 += var22;
                                var8 += var20;
                                var2 += Rasterizer2D.width;
                                var24 += var25;
                                var36 += var37;
                                var33 += var34;
                            }
                        }
                        var1 -= var0;
                        var0 -= var2;
                        var2 = scanOffsets[var2];
                        while (true) {
                            if (--var0 < 0) {
                                while (true) {
                                    if (--var1 < 0) {
                                        return;
                                    }
                                    Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var2, var3 >> 16, var4 >> 16, var8, var41, var24, var36, var33, var38, var39, var40);
                                    var4 += var30;
                                    var3 += var29;
                                    var8 += var20;
                                    var2 += Rasterizer2D.width;
                                    var24 += var25;
                                    var36 += var37;
                                    var33 += var34;
                                }
                            }
                            Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var2, var5 >> 16, var4 >> 16, var8, var41, var24, var36, var33, var38, var39, var40);
                            var4 += var30;
                            var5 += var22;
                            var8 += var20;
                            var2 += Rasterizer2D.width;
                            var24 += var25;
                            var36 += var37;
                            var33 += var34;
                        }
                    }
                    var3 = var5 <<= 16;
                    if (var2 < 0) {
                        var3 -= var30 * var2;
                        var5 -= var22 * var2;
                        var8 -= var20 * var2;
                        var2 = 0;
                    }
                    var4 <<= 16;
                    if (var1 < 0) {
                        var4 -= var29 * var1;
                        var1 = 0;
                    }
                    int var35 = var2 - originViewY;
                    var24 += var25 * var35;
                    var36 += var37 * var35;
                    var33 += var34 * var35;
                    if (var30 < var22) {
                        var0 -= var1;
                        var1 -= var2;
                        var2 = scanOffsets[var2];
                        while (true) {
                            if (--var1 < 0) {
                                while (true) {
                                    if (--var0 < 0) {
                                        return;
                                    }
                                    Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var2, var4 >> 16, var5 >> 16, var8, var41, var24, var36, var33, var38, var39, var40);
                                    var4 += var29;
                                    var5 += var22;
                                    var8 += var20;
                                    var2 += Rasterizer2D.width;
                                    var24 += var25;
                                    var36 += var37;
                                    var33 += var34;
                                }
                            }
                            Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var2, var3 >> 16, var5 >> 16, var8, var41, var24, var36, var33, var38, var39, var40);
                            var3 += var30;
                            var5 += var22;
                            var8 += var20;
                            var2 += Rasterizer2D.width;
                            var24 += var25;
                            var36 += var37;
                            var33 += var34;
                        }
                    }
                    var0 -= var1;
                    var1 -= var2;
                    var2 = scanOffsets[var2];
                    while (true) {
                        if (--var1 < 0) {
                            while (true) {
                                if (--var0 < 0) {
                                    return;
                                }
                                Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var2, var5 >> 16, var4 >> 16, var8, var41, var24, var36, var33, var38, var39, var40);
                                var4 += var29;
                                var5 += var22;
                                var8 += var20;
                                var2 += Rasterizer2D.width;
                                var24 += var25;
                                var36 += var37;
                                var33 += var34;
                            }
                        }
                        Rasterizer3D.drawTexturedLine(Rasterizer2D.pixels, texturePixels, 0, 0, var2, var5 >> 16, var3 >> 16, var8, var41, var24, var36, var33, var38, var39, var40);
                        var3 += var30;
                        var5 += var22;
                        var8 += var20;
                        var2 += Rasterizer2D.width;
                        var24 += var25;
                        var36 += var37;
                        var33 += var34;
                    }
                }
            }
        }
    }

    static final int light(int var0, int var1) {
        if ((var1 = (var0 & 0x7F) * var1 >> 7) < 2) {
            var1 = 2;
        } else if (var1 > 126) {
            var1 = 126;
        }
        return (var0 & 0xFF80) + var1;
    }

    static void drawTexturedLine(int[] var0, int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14) {
        if (!Client.instance.isResized() && world && var4 <= 259086) {
            var4 += 3064;
        }
        if (textureOutOfDrawingBounds) {
            if (var6 > Rasterizer2D.lastX) {
                var6 = Rasterizer2D.lastX;
            }
            if (var5 < 0) {
                var5 = 0;
            }
        }
        if (var5 < var6) {
            var4 += var5;
            var7 += var8 * var5;
            int var17 = var6 - var5;
            if (lowMem) {
                int var16;
                int var22;
                int var18;
                int var20;
                int var15 = var5 - originViewX;
                var9 += (var12 >> 3) * var15;
                var10 += (var13 >> 3) * var15;
                int var19 = (var11 += (var14 >> 3) * var15) >> 12;
                if (var19 != 0) {
                    var20 = var9 / var19;
                    var18 = var10 / var19;
                    if (var20 < 0) {
                        var20 = 0;
                    } else if (var20 > 4032) {
                        var20 = 4032;
                    }
                } else {
                    var20 = 0;
                    var18 = 0;
                }
                var9 += var12;
                var10 += var13;
                var19 = (var11 += var14) >> 12;
                if (var19 != 0) {
                    var22 = var9 / var19;
                    var16 = var10 / var19;
                    if (var22 < 0) {
                        var22 = 0;
                    } else if (var22 > 4032) {
                        var22 = 4032;
                    }
                } else {
                    var22 = 0;
                    var16 = 0;
                }
                var2 = (var20 << 20) + var18;
                int var23 = (var22 - var20 >> 3 << 20) + (var16 - var18 >> 3);
                var17 >>= 3;
                var8 <<= 3;
                int var21 = var7 >> 8;
                if (isTransparent) {
                    if (var17 > 0) {
                        do {
                            var3 = var1[(var2 & 0xFC0) + (var2 >>> 26)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var3 = var1[((var2 += var23) & 0xFC0) + (var2 >>> 26)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var3 = var1[((var2 += var23) & 0xFC0) + (var2 >>> 26)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var3 = var1[((var2 += var23) & 0xFC0) + (var2 >>> 26)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var3 = var1[((var2 += var23) & 0xFC0) + (var2 >>> 26)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var3 = var1[((var2 += var23) & 0xFC0) + (var2 >>> 26)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var3 = var1[((var2 += var23) & 0xFC0) + (var2 >>> 26)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var3 = var1[((var2 += var23) & 0xFC0) + (var2 >>> 26)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var20 = var22;
                            var18 = var16;
                            var9 += var12;
                            var10 += var13;
                            var19 = (var11 += var14) >> 12;
                            if (var19 != 0) {
                                var22 = var9 / var19;
                                var16 = var10 / var19;
                                if (var22 < 0) {
                                    var22 = 0;
                                } else if (var22 > 4032) {
                                    var22 = 4032;
                                }
                            } else {
                                var22 = 0;
                                var16 = 0;
                            }
                            var2 = (var20 << 20) + var18;
                            var23 = (var22 - var20 >> 3 << 20) + (var16 - var18 >> 3);
                            var21 = (var7 += var8) >> 8;
                        } while (--var17 > 0);
                    }
                    if ((var17 = var6 - var5 & 7) > 0) {
                        do {
                            var3 = var1[(var2 & 0xFC0) + (var2 >>> 26)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var2 += var23;
                        } while (--var17 > 0);
                    }
                } else {
                    if (var17 > 0) {
                        do {
                            if ((var3 = var1[(var2 & 0xFC0) + (var2 >>> 26)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            if ((var3 = var1[((var2 += var23) & 0xFC0) + (var2 >>> 26)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            if ((var3 = var1[((var2 += var23) & 0xFC0) + (var2 >>> 26)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            if ((var3 = var1[((var2 += var23) & 0xFC0) + (var2 >>> 26)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            if ((var3 = var1[((var2 += var23) & 0xFC0) + (var2 >>> 26)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            if ((var3 = var1[((var2 += var23) & 0xFC0) + (var2 >>> 26)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            if ((var3 = var1[((var2 += var23) & 0xFC0) + (var2 >>> 26)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            if ((var3 = var1[((var2 += var23) & 0xFC0) + (var2 >>> 26)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            var20 = var22;
                            var18 = var16;
                            var9 += var12;
                            var10 += var13;
                            var19 = (var11 += var14) >> 12;
                            if (var19 != 0) {
                                var22 = var9 / var19;
                                var16 = var10 / var19;
                                if (var22 < 0) {
                                    var22 = 0;
                                } else if (var22 > 4032) {
                                    var22 = 4032;
                                }
                            } else {
                                var22 = 0;
                                var16 = 0;
                            }
                            var2 = (var20 << 20) + var18;
                            var23 = (var22 - var20 >> 3 << 20) + (var16 - var18 >> 3);
                            var21 = (var7 += var8) >> 8;
                        } while (--var17 > 0);
                    }
                    if ((var17 = var6 - var5 & 7) > 0) {
                        do {
                            if ((var3 = var1[(var2 & 0xFC0) + (var2 >>> 26)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            var2 += var23;
                        } while (--var17 > 0);
                    }
                }
            } else {
                int var16;
                int var22;
                int var18;
                int var20;
                int var15 = var5 - originViewX;
                var9 += (var12 >> 3) * var15;
                var10 += (var13 >> 3) * var15;
                int var19 = (var11 += (var14 >> 3) * var15) >> 14;
                if (var19 != 0) {
                    var20 = var9 / var19;
                    var18 = var10 / var19;
                    if (var20 < 0) {
                        var20 = 0;
                    } else if (var20 > 16256) {
                        var20 = 16256;
                    }
                } else {
                    var20 = 0;
                    var18 = 0;
                }
                var9 += var12;
                var10 += var13;
                var19 = (var11 += var14) >> 14;
                if (var19 != 0) {
                    var22 = var9 / var19;
                    var16 = var10 / var19;
                    if (var22 < 0) {
                        var22 = 0;
                    } else if (var22 > 16256) {
                        var22 = 16256;
                    }
                } else {
                    var22 = 0;
                    var16 = 0;
                }
                var2 = (var20 << 18) + var18;
                int var23 = (var22 - var20 >> 3 << 18) + (var16 - var18 >> 3);
                var17 >>= 3;
                var8 <<= 3;
                int var21 = var7 >> 8;
                if (isTransparent) {
                    if (var17 > 0) {
                        do {
                            var3 = var1[(var2 & 0x3F80) + (var2 >>> 25)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var3 = var1[((var2 += var23) & 0x3F80) + (var2 >>> 25)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var3 = var1[((var2 += var23) & 0x3F80) + (var2 >>> 25)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var3 = var1[((var2 += var23) & 0x3F80) + (var2 >>> 25)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var3 = var1[((var2 += var23) & 0x3F80) + (var2 >>> 25)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var3 = var1[((var2 += var23) & 0x3F80) + (var2 >>> 25)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var3 = var1[((var2 += var23) & 0x3F80) + (var2 >>> 25)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var3 = var1[((var2 += var23) & 0x3F80) + (var2 >>> 25)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var20 = var22;
                            var18 = var16;
                            var9 += var12;
                            var10 += var13;
                            var19 = (var11 += var14) >> 14;
                            if (var19 != 0) {
                                var22 = var9 / var19;
                                var16 = var10 / var19;
                                if (var22 < 0) {
                                    var22 = 0;
                                } else if (var22 > 16256) {
                                    var22 = 16256;
                                }
                            } else {
                                var22 = 0;
                                var16 = 0;
                            }
                            var2 = (var20 << 18) + var18;
                            var23 = (var22 - var20 >> 3 << 18) + (var16 - var18 >> 3);
                            var21 = (var7 += var8) >> 8;
                        } while (--var17 > 0);
                    }
                    if ((var17 = var6 - var5 & 7) > 0) {
                        do {
                            var3 = var1[(var2 & 0x3F80) + (var2 >>> 25)];
                            Rasterizer3D.drawAlpha(var0, var4++, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            var2 += var23;
                        } while (--var17 > 0);
                    }
                } else {
                    if (var17 > 0) {
                        do {
                            if ((var3 = var1[(var2 & 0x3F80) + (var2 >>> 25)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            if ((var3 = var1[((var2 += var23) & 0x3F80) + (var2 >>> 25)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            if ((var3 = var1[((var2 += var23) & 0x3F80) + (var2 >>> 25)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            if ((var3 = var1[((var2 += var23) & 0x3F80) + (var2 >>> 25)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            if ((var3 = var1[((var2 += var23) & 0x3F80) + (var2 >>> 25)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            if ((var3 = var1[((var2 += var23) & 0x3F80) + (var2 >>> 25)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            if ((var3 = var1[((var2 += var23) & 0x3F80) + (var2 >>> 25)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            if ((var3 = var1[((var2 += var23) & 0x3F80) + (var2 >>> 25)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            var20 = var22;
                            var18 = var16;
                            var9 += var12;
                            var10 += var13;
                            var19 = (var11 += var14) >> 14;
                            if (var19 != 0) {
                                var22 = var9 / var19;
                                var16 = var10 / var19;
                                if (var22 < 0) {
                                    var22 = 0;
                                } else if (var22 > 16256) {
                                    var22 = 16256;
                                }
                            } else {
                                var22 = 0;
                                var16 = 0;
                            }
                            var2 = (var20 << 18) + var18;
                            var23 = (var22 - var20 >> 3 << 18) + (var16 - var18 >> 3);
                            var21 = (var7 += var8) >> 8;
                        } while (--var17 > 0);
                    }
                    if ((var17 = var6 - var5 & 7) > 0) {
                        do {
                            if ((var3 = var1[(var2 & 0x3F80) + (var2 >>> 25)]) != 0) {
                                Rasterizer3D.drawAlpha(var0, var4, ((var3 & 0xFF00FF) * var21 & 0xFF00FF00) + ((var3 & 0xFF00) * var21 & 0xFF0000) >> 8, 255);
                            }
                            ++var4;
                            var2 += var23;
                        } while (--var17 > 0);
                    }
                }
            }
        }
    }

    public static final int method4025(int var0, int var1, int var2, int var3) {
        return var0 * var2 - var3 * var1 >> 16;
    }

    public static final int method4044(int var0, int var1, int var2, int var3) {
        return var3 * var0 + var2 * var1 >> 16;
    }

    public static final int method4045(int var0, int var1, int var2, int var3) {
        return var0 * var2 + var3 * var1 >> 16;
    }

    public static final int method4046(int var0, int var1, int var2, int var3) {
        return var2 * var1 - var3 * var0 >> 16;
    }

    static {
        lowMem = false;
        aBoolean1464 = true;
        hslToRgb = new int[65536];
        anIntArray1468 = new int[512];
        anIntArray1469 = new int[2048];
        SINE = new int[2048];
        COSINE = new int[2048];
        for (int i = 1; i < 512; ++i) {
            Rasterizer3D.anIntArray1468[i] = 32768 / i;
        }
        for (int j = 1; j < 2048; ++j) {
            Rasterizer3D.anIntArray1469[j] = 65536 / j;
        }
        for (int k = 0; k < 2048; ++k) {
            Rasterizer3D.SINE[k] = (int)(65536.0 * Math.sin((double)k * 0.0030679615));
            Rasterizer3D.COSINE[k] = (int)(65536.0 * Math.cos((double)k * 0.0030679615));
        }
    }
}

