/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Buffer;
import com.client.osrs.CacheWrapper;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class Script {
    public static Script[] scripts;
    public String field1008;
    private int id;
    private int[] instructions;
    private int[] intOperands;
    private String[] stringOperands;
    private int intStackCount;
    private int stringStackCount;
    private int localIntCount;
    private int localStringCount;
    private Map<Integer, Integer>[] switches;

    public static void loadScripts(CacheWrapper cacheWrapper) {
        scripts = new Script[cacheWrapper.getIndex(12).archives().length];
        for (int i = 0; i < scripts.length; ++i) {
            Script.scripts[i] = Script.decode(i, cacheWrapper.getCache().data(12, i));
            if (Script.scripts[i].field1008 == null || Script.scripts[i].field1008.isEmpty()) continue;
            System.out.println("Loaded script [" + Script.scripts[i].field1008 + "]");
        }
        System.out.println("Loaded [" + scripts.length + "] CS2 Scripts");
    }

    public static Script decode(int id, byte[] bytes) {
        Script def = new Script();
        def.setId(id);
        if (bytes == null || bytes.length < 1) {
            return def;
        }
        try {
            Buffer in = new Buffer(bytes);
            in.setOffset(in.getLength() - 2);
            int switchLength = in.readUnsignedShort();
            int endIdx = in.getLength() - 2 - switchLength - 12;
            in.setOffset(endIdx);
            int numOpcodes = in.readInt();
            int localIntCount = in.readUnsignedShort();
            int localStringCount = in.readUnsignedShort();
            int intStackCount = in.readUnsignedShort();
            int stringStackCount = in.readUnsignedShort();
            int numSwitches = in.readUnsignedByte();
            if (numSwitches > 0) {
                Map[] switches = new Map[numSwitches];
                def.setSwitches(switches);
                for (int i = 0; i < numSwitches; ++i) {
                    switches[i] = new LinkedHashMap();
                    int count2 = in.readUnsignedShort();
                    while (count2-- > 0) {
                        int key = in.readInt();
                        int pcOffset = in.readInt();
                        switches[i].put(key, pcOffset);
                    }
                }
            }
            def.setLocalIntCount(localIntCount);
            def.setLocalStringCount(localStringCount);
            def.setIntStackCount(intStackCount);
            def.setStringStackCount(stringStackCount);
            in.setOffset(0);
            def.field1008 = in.readNullTerminatedString();
            int[] instructions = new int[numOpcodes];
            int[] intOperands = new int[numOpcodes];
            String[] stringOperands = new String[numOpcodes];
            def.setInstructions(instructions);
            def.setIntOperands(intOperands);
            def.setStringOperands(stringOperands);
            int i = 0;
            while (in.currentPosition < endIdx) {
                int opcode = in.readUnsignedShort();
                if (opcode == 3) {
                    stringOperands[i] = in.readNullTerminatedString();
                } else {
                    intOperands[i] = opcode < 100 && opcode != 21 && opcode != 38 && opcode != 39 ? in.readInt() : in.readUnsignedByte();
                }
                instructions[i++] = opcode;
            }
        }
        catch (Exception e) {
            return def;
        }
        return def;
    }

    public String getField1008() {
        return this.field1008;
    }

    public int getId() {
        return this.id;
    }

    public int[] getInstructions() {
        return this.instructions;
    }

    public int[] getIntOperands() {
        return this.intOperands;
    }

    public String[] getStringOperands() {
        return this.stringOperands;
    }

    public int getIntStackCount() {
        return this.intStackCount;
    }

    public int getStringStackCount() {
        return this.stringStackCount;
    }

    public int getLocalIntCount() {
        return this.localIntCount;
    }

    public int getLocalStringCount() {
        return this.localStringCount;
    }

    public Map<Integer, Integer>[] getSwitches() {
        return this.switches;
    }

    public void setField1008(String field1008) {
        this.field1008 = field1008;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setInstructions(int[] instructions) {
        this.instructions = instructions;
    }

    public void setIntOperands(int[] intOperands) {
        this.intOperands = intOperands;
    }

    public void setStringOperands(String[] stringOperands) {
        this.stringOperands = stringOperands;
    }

    public void setIntStackCount(int intStackCount) {
        this.intStackCount = intStackCount;
    }

    public void setStringStackCount(int stringStackCount) {
        this.stringStackCount = stringStackCount;
    }

    public void setLocalIntCount(int localIntCount) {
        this.localIntCount = localIntCount;
    }

    public void setLocalStringCount(int localStringCount) {
        this.localStringCount = localStringCount;
    }

    public void setSwitches(Map<Integer, Integer>[] switches) {
        this.switches = switches;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Script)) {
            return false;
        }
        Script other = (Script)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getIntStackCount() != other.getIntStackCount()) {
            return false;
        }
        if (this.getStringStackCount() != other.getStringStackCount()) {
            return false;
        }
        if (this.getLocalIntCount() != other.getLocalIntCount()) {
            return false;
        }
        if (this.getLocalStringCount() != other.getLocalStringCount()) {
            return false;
        }
        String this$field1008 = this.getField1008();
        String other$field1008 = other.getField1008();
        if (this$field1008 == null ? other$field1008 != null : !this$field1008.equals(other$field1008)) {
            return false;
        }
        if (!Arrays.equals(this.getInstructions(), other.getInstructions())) {
            return false;
        }
        if (!Arrays.equals(this.getIntOperands(), other.getIntOperands())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getStringOperands(), other.getStringOperands())) {
            return false;
        }
        return Arrays.deepEquals(this.getSwitches(), other.getSwitches());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Script;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + this.getId();
        result2 = result2 * 59 + this.getIntStackCount();
        result2 = result2 * 59 + this.getStringStackCount();
        result2 = result2 * 59 + this.getLocalIntCount();
        result2 = result2 * 59 + this.getLocalStringCount();
        String $field1008 = this.getField1008();
        result2 = result2 * 59 + ($field1008 == null ? 43 : $field1008.hashCode());
        result2 = result2 * 59 + Arrays.hashCode(this.getInstructions());
        result2 = result2 * 59 + Arrays.hashCode(this.getIntOperands());
        result2 = result2 * 59 + Arrays.deepHashCode(this.getStringOperands());
        result2 = result2 * 59 + Arrays.deepHashCode(this.getSwitches());
        return result2;
    }

    public String toString() {
        return "Script(field1008=" + this.getField1008() + ", id=" + this.getId() + ", instructions=" + Arrays.toString(this.getInstructions()) + ", intOperands=" + Arrays.toString(this.getIntOperands()) + ", stringOperands=" + Arrays.deepToString(this.getStringOperands()) + ", intStackCount=" + this.getIntStackCount() + ", stringStackCount=" + this.getStringStackCount() + ", localIntCount=" + this.getLocalIntCount() + ", localStringCount=" + this.getLocalStringCount() + ", switches=" + Arrays.deepToString(this.getSwitches()) + ")";
    }
}

