/*
 * Decompiled with CFR 0.152.
 */
package com.client.definitions;

import com.client.osrs.OSRSCacheLoader;
import java.util.Arrays;
import java.util.Map;
import net.runelite.api.Animation;
import net.runelite.api.Skeleton;

public class SeqDefinition
implements Animation {
    public int id;
    public int frameCount = 0;
    public int[] frameIDs;
    public int[] secondaryFrameIds;
    public int[] delays;
    public int frameStep = Defaults.DEFAULT_LOOP_DELAY;
    public int[] masks;
    public boolean[] booleanMasks;
    public boolean stretches = Defaults.DEFAULT_ONE_SQUARE_ANIMATION;
    public boolean isEmpty = false;
    public int forcedPriority = Defaults.DEFAULT_FORCED_PRIORITY;
    public int leftHandItem = Defaults.DEFAULT_LEFT_HAND_ITEM;
    public int rightHandItem = Defaults.DEFAULT_RIGHT_HAND_ITEM;
    public int loopCount = Defaults.DEFAULT_FRAME_STEP;
    public int moveStyle = Defaults.DEFAULT_RESET_WHEN_WALK;
    public int idleStyle = Defaults.DEFAULT_PRIORITY;
    public int replyMode = Defaults.DEFAULT_DELAY_TYPE;
    public int[] chatFrameIds;
    public int[] soundEffects;
    public int skeletalId = Defaults.DEFAULT_SKELETAL_ID;
    public int rangeBegin = Defaults.DEFAULT_RANGE_BEGIN;
    public int rangeEnd = Defaults.DEFAULT_RANGE_END;
    public int maxLoops = 99;
    private Map<Integer, Integer> soundRelated;

    public int getSkeletalLength() {
        return this.rangeEnd - this.rangeBegin;
    }

    public boolean isSkeletalAnimation() {
        return this.skeletalId >= 0;
    }

    public static SeqDefinition get(int id) {
        return OSRSCacheLoader.getSeqDef(id);
    }

    public static int length() {
        return OSRSCacheLoader.getSeqDefs().getDefinitions().length;
    }

    public int getDuration(int i) {
        int j;
        int n = j = this.isSkeletalAnimation() ? 1 : this.delays[i];
        if (j == 0) {
            j = 1;
        }
        return j;
    }

    public void postDecode() {
        if (this.frameCount == 0) {
            this.frameCount = 1;
            this.frameIDs = new int[1];
            this.frameIDs[0] = -1;
            this.secondaryFrameIds = new int[1];
            this.secondaryFrameIds[0] = -1;
            this.delays = new int[1];
            this.delays[0] = -1;
            this.isEmpty = true;
        }
        if (this.moveStyle == -1) {
            int n = this.moveStyle = this.masks == null ? 0 : 2;
        }
        if (this.idleStyle == -1) {
            this.idleStyle = this.masks == null ? 0 : 2;
            return;
        }
        this.idleStyle = 0;
    }

    @Override
    public Skeleton getSkeleton() {
        return null;
    }

    @Override
    public int getTransformCount() {
        return 0;
    }

    @Override
    public int[] getTransformTypes() {
        return new int[0];
    }

    @Override
    public int[] getTranslatorX() {
        return new int[0];
    }

    @Override
    public int[] getTranslatorY() {
        return new int[0];
    }

    @Override
    public int[] getTranslatorZ() {
        return new int[0];
    }

    @Override
    public boolean isShowing() {
        return false;
    }

    public int getId() {
        return this.id;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int[] getFrameIDs() {
        return this.frameIDs;
    }

    public int[] getSecondaryFrameIds() {
        return this.secondaryFrameIds;
    }

    public int[] getDelays() {
        return this.delays;
    }

    public int getFrameStep() {
        return this.frameStep;
    }

    public int[] getMasks() {
        return this.masks;
    }

    public boolean[] getBooleanMasks() {
        return this.booleanMasks;
    }

    public boolean isStretches() {
        return this.stretches;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public int getForcedPriority() {
        return this.forcedPriority;
    }

    public int getLeftHandItem() {
        return this.leftHandItem;
    }

    public int getRightHandItem() {
        return this.rightHandItem;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public int getMoveStyle() {
        return this.moveStyle;
    }

    public int getIdleStyle() {
        return this.idleStyle;
    }

    public int getReplyMode() {
        return this.replyMode;
    }

    public int[] getChatFrameIds() {
        return this.chatFrameIds;
    }

    public int[] getSoundEffects() {
        return this.soundEffects;
    }

    public int getSkeletalId() {
        return this.skeletalId;
    }

    public int getRangeBegin() {
        return this.rangeBegin;
    }

    public int getRangeEnd() {
        return this.rangeEnd;
    }

    public int getMaxLoops() {
        return this.maxLoops;
    }

    public Map<Integer, Integer> getSoundRelated() {
        return this.soundRelated;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setFrameCount(int frameCount) {
        this.frameCount = frameCount;
    }

    public void setFrameIDs(int[] frameIDs) {
        this.frameIDs = frameIDs;
    }

    public void setSecondaryFrameIds(int[] secondaryFrameIds) {
        this.secondaryFrameIds = secondaryFrameIds;
    }

    public void setDelays(int[] delays) {
        this.delays = delays;
    }

    public void setFrameStep(int frameStep) {
        this.frameStep = frameStep;
    }

    public void setMasks(int[] masks) {
        this.masks = masks;
    }

    public void setBooleanMasks(boolean[] booleanMasks) {
        this.booleanMasks = booleanMasks;
    }

    public void setStretches(boolean stretches) {
        this.stretches = stretches;
    }

    public void setEmpty(boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    public void setForcedPriority(int forcedPriority) {
        this.forcedPriority = forcedPriority;
    }

    public void setLeftHandItem(int leftHandItem) {
        this.leftHandItem = leftHandItem;
    }

    public void setRightHandItem(int rightHandItem) {
        this.rightHandItem = rightHandItem;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }

    public void setMoveStyle(int moveStyle) {
        this.moveStyle = moveStyle;
    }

    public void setIdleStyle(int idleStyle) {
        this.idleStyle = idleStyle;
    }

    public void setReplyMode(int replyMode) {
        this.replyMode = replyMode;
    }

    public void setChatFrameIds(int[] chatFrameIds) {
        this.chatFrameIds = chatFrameIds;
    }

    public void setSoundEffects(int[] soundEffects) {
        this.soundEffects = soundEffects;
    }

    public void setSkeletalId(int skeletalId) {
        this.skeletalId = skeletalId;
    }

    public void setRangeBegin(int rangeBegin) {
        this.rangeBegin = rangeBegin;
    }

    public void setRangeEnd(int rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    public void setMaxLoops(int maxLoops) {
        this.maxLoops = maxLoops;
    }

    public void setSoundRelated(Map<Integer, Integer> soundRelated) {
        this.soundRelated = soundRelated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeqDefinition)) {
            return false;
        }
        SeqDefinition other = (SeqDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getFrameCount() != other.getFrameCount()) {
            return false;
        }
        if (this.getFrameStep() != other.getFrameStep()) {
            return false;
        }
        if (this.isStretches() != other.isStretches()) {
            return false;
        }
        if (this.isEmpty() != other.isEmpty()) {
            return false;
        }
        if (this.getForcedPriority() != other.getForcedPriority()) {
            return false;
        }
        if (this.getLeftHandItem() != other.getLeftHandItem()) {
            return false;
        }
        if (this.getRightHandItem() != other.getRightHandItem()) {
            return false;
        }
        if (this.getLoopCount() != other.getLoopCount()) {
            return false;
        }
        if (this.getMoveStyle() != other.getMoveStyle()) {
            return false;
        }
        if (this.getIdleStyle() != other.getIdleStyle()) {
            return false;
        }
        if (this.getReplyMode() != other.getReplyMode()) {
            return false;
        }
        if (this.getSkeletalId() != other.getSkeletalId()) {
            return false;
        }
        if (this.getRangeBegin() != other.getRangeBegin()) {
            return false;
        }
        if (this.getRangeEnd() != other.getRangeEnd()) {
            return false;
        }
        if (this.getMaxLoops() != other.getMaxLoops()) {
            return false;
        }
        if (!Arrays.equals(this.getFrameIDs(), other.getFrameIDs())) {
            return false;
        }
        if (!Arrays.equals(this.getSecondaryFrameIds(), other.getSecondaryFrameIds())) {
            return false;
        }
        if (!Arrays.equals(this.getDelays(), other.getDelays())) {
            return false;
        }
        if (!Arrays.equals(this.getMasks(), other.getMasks())) {
            return false;
        }
        if (!Arrays.equals(this.getBooleanMasks(), other.getBooleanMasks())) {
            return false;
        }
        if (!Arrays.equals(this.getChatFrameIds(), other.getChatFrameIds())) {
            return false;
        }
        if (!Arrays.equals(this.getSoundEffects(), other.getSoundEffects())) {
            return false;
        }
        Map<Integer, Integer> this$soundRelated = this.getSoundRelated();
        Map<Integer, Integer> other$soundRelated = other.getSoundRelated();
        return !(this$soundRelated == null ? other$soundRelated != null : !((Object)this$soundRelated).equals(other$soundRelated));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SeqDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + this.getId();
        result2 = result2 * 59 + this.getFrameCount();
        result2 = result2 * 59 + this.getFrameStep();
        result2 = result2 * 59 + (this.isStretches() ? 79 : 97);
        result2 = result2 * 59 + (this.isEmpty() ? 79 : 97);
        result2 = result2 * 59 + this.getForcedPriority();
        result2 = result2 * 59 + this.getLeftHandItem();
        result2 = result2 * 59 + this.getRightHandItem();
        result2 = result2 * 59 + this.getLoopCount();
        result2 = result2 * 59 + this.getMoveStyle();
        result2 = result2 * 59 + this.getIdleStyle();
        result2 = result2 * 59 + this.getReplyMode();
        result2 = result2 * 59 + this.getSkeletalId();
        result2 = result2 * 59 + this.getRangeBegin();
        result2 = result2 * 59 + this.getRangeEnd();
        result2 = result2 * 59 + this.getMaxLoops();
        result2 = result2 * 59 + Arrays.hashCode(this.getFrameIDs());
        result2 = result2 * 59 + Arrays.hashCode(this.getSecondaryFrameIds());
        result2 = result2 * 59 + Arrays.hashCode(this.getDelays());
        result2 = result2 * 59 + Arrays.hashCode(this.getMasks());
        result2 = result2 * 59 + Arrays.hashCode(this.getBooleanMasks());
        result2 = result2 * 59 + Arrays.hashCode(this.getChatFrameIds());
        result2 = result2 * 59 + Arrays.hashCode(this.getSoundEffects());
        Map<Integer, Integer> $soundRelated = this.getSoundRelated();
        result2 = result2 * 59 + ($soundRelated == null ? 43 : ((Object)$soundRelated).hashCode());
        return result2;
    }

    public String toString() {
        return "SeqDefinition(id=" + this.getId() + ", frameCount=" + this.getFrameCount() + ", frameIDs=" + Arrays.toString(this.getFrameIDs()) + ", secondaryFrameIds=" + Arrays.toString(this.getSecondaryFrameIds()) + ", delays=" + Arrays.toString(this.getDelays()) + ", frameStep=" + this.getFrameStep() + ", masks=" + Arrays.toString(this.getMasks()) + ", booleanMasks=" + Arrays.toString(this.getBooleanMasks()) + ", stretches=" + this.isStretches() + ", isEmpty=" + this.isEmpty() + ", forcedPriority=" + this.getForcedPriority() + ", leftHandItem=" + this.getLeftHandItem() + ", rightHandItem=" + this.getRightHandItem() + ", loopCount=" + this.getLoopCount() + ", moveStyle=" + this.getMoveStyle() + ", idleStyle=" + this.getIdleStyle() + ", replyMode=" + this.getReplyMode() + ", chatFrameIds=" + Arrays.toString(this.getChatFrameIds()) + ", soundEffects=" + Arrays.toString(this.getSoundEffects()) + ", skeletalId=" + this.getSkeletalId() + ", rangeBegin=" + this.getRangeBegin() + ", rangeEnd=" + this.getRangeEnd() + ", maxLoops=" + this.getMaxLoops() + ", soundRelated=" + String.valueOf(this.getSoundRelated()) + ")";
    }

    public static class Defaults {
        public static final int DEFAULT_FRAME_COUNT = 0;
        public static int DEFAULT_LOOP_DELAY = -1;
        public static boolean DEFAULT_ONE_SQUARE_ANIMATION;
        public static int DEFAULT_FORCED_PRIORITY;
        public static int DEFAULT_LEFT_HAND_ITEM;
        public static int DEFAULT_RIGHT_HAND_ITEM;
        public static int DEFAULT_FRAME_STEP;
        public static int DEFAULT_RESET_WHEN_WALK;
        public static int DEFAULT_PRIORITY;
        public static int DEFAULT_DELAY_TYPE;
        public static int DEFAULT_SKELETAL_ID;
        public static int DEFAULT_RANGE_BEGIN;
        public static int DEFAULT_RANGE_END;

        static {
            DEFAULT_FORCED_PRIORITY = 5;
            DEFAULT_LEFT_HAND_ITEM = -1;
            DEFAULT_RIGHT_HAND_ITEM = -1;
            DEFAULT_FRAME_STEP = 99;
            DEFAULT_RESET_WHEN_WALK = -1;
            DEFAULT_PRIORITY = -1;
            DEFAULT_DELAY_TYPE = 2;
            DEFAULT_SKELETAL_ID = -1;
            DEFAULT_RANGE_BEGIN = 0;
            DEFAULT_RANGE_END = 0;
        }
    }
}

