/*
 * Decompiled with CFR 0.152.
 */
package com.client.definitions.anims.defs;

import com.client.InputBuffer;
import com.client.definitions.SeqBase;
import com.client.definitions.anims.decoder.impl.SeqBaseDecoderOSRS;
import com.client.osrs.CacheWrapper;
import com.displee.cache.index.Index;
import com.displee.cache.index.archive.ArchiveSector;
import com.displee.compress.CompressionExtKt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SeqBaseDefs {
    private final List<SeqBase> definitions;
    private final CacheWrapper cacheWrapper;
    private static Index baseIndex;

    public SeqBase get(int id) {
        if (this.definitions.get(id) == null) {
            this.loadId(id);
        }
        return this.definitions.get(id);
    }

    private void loadId(int id) {
        ArchiveSector archiveSector = baseIndex.readArchiveSector(id);
        if (archiveSector != null) {
            byte[] baseData = CompressionExtKt.decompress(archiveSector, null);
            InputBuffer buffer = new InputBuffer(baseData);
            SeqBaseDecoderOSRS decoder = new SeqBaseDecoderOSRS();
            SeqBase base = new SeqBase();
            base.setGroupId(id);
            decoder.decode(buffer, base);
            this.definitions.set(id, base);
        }
    }

    public static SeqBaseDefs load(CacheWrapper cacheWrapper) {
        baseIndex = cacheWrapper.getIndex(1);
        int length = baseIndex.archives().length;
        ArrayList<Object> definitions = new ArrayList<Object>(Collections.nCopies(length, null));
        SeqBaseDefs seqBaseDefs = new SeqBaseDefs(definitions, cacheWrapper);
        return seqBaseDefs;
    }

    public List<SeqBase> getDefinitions() {
        return this.definitions;
    }

    public CacheWrapper getCacheWrapper() {
        return this.cacheWrapper;
    }

    public SeqBaseDefs(List<SeqBase> definitions, CacheWrapper cacheWrapper) {
        this.definitions = definitions;
        this.cacheWrapper = cacheWrapper;
    }

    public static Index getBaseIndex() {
        return baseIndex;
    }
}

