/*
 * Decompiled with CFR 0.152.
 */
package com.client.engine.impl;

import com.client.Client;
import com.client.engine.impl.MouseHandler;
import com.client.graphics.interfaces.RSInterface;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import net.runelite.rs.api.RSMouseWheelHandler;

public class MouseWheelHandler
implements MouseWheelListener,
RSMouseWheelHandler {
    static int rotation;
    public static boolean mouseWheelDown;
    public static int mouseWheelX;
    public static int mouseWheelY;
    public boolean canZoom = true;

    public static synchronized int useRotation() {
        int rotation = MouseWheelHandler.rotation;
        MouseWheelHandler.rotation = 0;
        return rotation;
    }

    public void addTo(Component component) {
        component.addMouseWheelListener(this);
    }

    public void removeFrom(Component component) {
        component.removeMouseWheelListener(this);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int rotation;
        e = Client.instance.getCallbacks().mouseWheelMoved(e);
        if (e.isConsumed()) {
            return;
        }
        MouseWheelHandler.rotation = rotation = e.getWheelRotation();
        Client.rotation = rotation;
        if (Client.instance.isMenuOpen()) {
            boolean submenuContainsMouse;
            Client client = Client.instance;
            int var2 = client.getMouseX();
            int var3 = client.getMouseY();
            boolean regmenuContainsMouse = var2 >= client.getMenuX() - 10 && var2 <= client.getMenuX() + client.getMenuWidth() + 10 && var3 >= client.getMenuY() - 10 && var3 <= client.getMenuY() + client.getMenuHeight() + 10;
            boolean bl = submenuContainsMouse = var2 >= client.getSubmenuX() - 10 && var2 <= client.getSubmenuX() + client.getSubmenuWidth() + 10 && var3 >= client.getSubmenuY() - 10 && var3 <= client.getSubmenuY() + client.getSubmenuHeight() + 10;
            if (regmenuContainsMouse || submenuContainsMouse) {
                return;
            }
        }
        if (!this.handleInterfaceScrolling(e)) {
            if (MouseHandler.mouseX > 0 && MouseHandler.mouseX < 512 && MouseHandler.mouseY > Client.canvasHeight - 165 && MouseHandler.mouseY < Client.canvasHeight - 25) {
                int scrollPos = Client.anInt1089;
                if ((scrollPos -= rotation * 30) < 0) {
                    scrollPos = 0;
                }
                if (Client.anInt1089 != scrollPos) {
                    Client.anInt1089 = scrollPos;
                }
            } else if (Client.loggedIn) {
                boolean zoom;
                boolean bl = !Client.instance.isResized() ? MouseHandler.mouseX < 512 : (zoom = MouseHandler.mouseX < Client.canvasWidth - 200);
                if (zoom && Client.openInterfaceID == -1) {
                    int zoom_out;
                    int zoom_in = !Client.instance.isResized() ? 195 : 240;
                    int n = zoom_out = !Client.instance.isResized() ? 1105 : 1220;
                    if (rotation != -1) {
                        if (Client.cameraZoom > zoom_in) {
                            Client.cameraZoom -= 45;
                        }
                    } else if (Client.cameraZoom < zoom_out) {
                        Client.cameraZoom += 45;
                    }
                }
                Client.inputTaken = true;
                if (Client.openInterfaceID == -1 && zoom) {
                    RSInterface.interfaceCache[44151].active = true;
                    RSInterface.interfaceCache[42525].slider.setValue(Client.cameraZoom);
                }
            }
        }
    }

    public Boolean inMap(int mouseX, int mouseY, boolean resized, int width) {
        int i = mouseX - 25 - 547;
        int j = mouseY - 5 - 3;
        if (resized) {
            i = mouseX - (width - 182 + 24);
            j = mouseY - 8;
        }
        return this.inCircle(0, 0, i, j, 76);
    }

    public boolean inCircle(int circleX, int circleY, int clickX, int clickY, int radius) {
        return Math.pow(circleX + radius - clickX, 2.0) + Math.pow(circleY + radius - clickY, 2.0) < Math.pow(radius, 2.0);
    }

    public boolean handleInterfaceScrolling(MouseWheelEvent event) {
        int offsetY;
        int offsetX;
        int rotation = event.getWheelRotation();
        int tabInterfaceID = Client.tabInterfaceIDs[Client.tabID];
        if (tabInterfaceID != -1) {
            int n = offsetX = !Client.instance.isResized() ? 547 : Client.canvasWidth - 197;
            int n2 = !Client.instance.isResized() ? 205 : (offsetY = Client.canvasHeight - (Client.canvasWidth >= 960 ? 37 : 74) - 267);
            if (RSInterface.get(tabInterfaceID) == null) {
                return false;
            }
            this.handleTabInterfaceScrolling(RSInterface.get(tabInterfaceID), rotation, offsetX, offsetY);
        }
        if (Client.openInterfaceID != -1) {
            offsetX = !Client.instance.isResized() ? 4 : Client.canvasWidth / 2 - 356;
            offsetY = !Client.instance.isResized() ? 4 : Client.canvasHeight / 2 - 230;
            return this.handleMainInterfaceScrolling(Client.openInterfaceID, offsetX, offsetY, rotation);
        }
        return false;
    }

    private void handleTabInterfaceScrolling(RSInterface tab, int rotation, int offsetX, int offsetY) {
        int positionX = 0;
        int positionY = 0;
        int width = 0;
        int height = 0;
        int childID = 0;
        if (tab.children != null) {
            for (int index = 0; index < tab.children.length; ++index) {
                RSInterface child = RSInterface.interfaceCache[tab.children[index]];
                this.handleTabInterfaceScrolling(child, rotation, offsetX + tab.childX[index], offsetY + tab.childY[index]);
                if (child.scrollMax <= 0) continue;
                childID = index;
                positionX = tab.childX[index];
                positionY = tab.childY[index];
                width = child.width + 16;
                height = child.height;
                break;
            }
        }
        if (MouseHandler.mouseX > offsetX + positionX && MouseHandler.mouseY > offsetY + positionY && MouseHandler.mouseX < offsetX + positionX + width && MouseHandler.mouseY < offsetY + positionY + height) {
            RSInterface rsInterface = RSInterface.interfaceCache[tab.children[childID]];
            int newScrollPosition = rsInterface.scrollPosition + rotation * 30;
            rsInterface.scrollPosition = newScrollPosition < 0 ? 0 : (newScrollPosition > rsInterface.scrollMax - rsInterface.height ? rsInterface.scrollMax - rsInterface.height : (rsInterface.scrollPosition += rotation * 30));
            Client.tabAreaAltered = true;
            Client.needDrawTabArea = true;
            return;
        }
    }

    private boolean handleMainInterfaceScrolling(int interfaceId, int offsetX, int offsetY, int rotation) {
        RSInterface rsi = RSInterface.interfaceCache[interfaceId];
        if (rsi.children != null) {
            for (int index = 0; index < rsi.children.length; ++index) {
                this.handleMainInterfaceScrolling(rsi.children[index], offsetX + rsi.childX[index], offsetY + rsi.childY[index], rotation);
                if (RSInterface.interfaceCache[rsi.children[index]].scrollMax <= 0 || MouseHandler.mouseX <= offsetX + rsi.childX[index] || MouseHandler.mouseY <= offsetY + rsi.childY[index] || MouseHandler.mouseX >= offsetX + rsi.childX[index] + RSInterface.interfaceCache[rsi.children[index]].width + 16 || MouseHandler.mouseY >= offsetY + rsi.childY[index] + RSInterface.interfaceCache[rsi.children[index]].height) continue;
                RSInterface rsInterface = RSInterface.interfaceCache[rsi.children[index]];
                int newScrollPosition = rsInterface.scrollPosition + rotation * 30;
                rsInterface.scrollPosition += rotation * 30;
                rsInterface.scrollPosition = newScrollPosition < 0 ? 0 : (newScrollPosition > rsInterface.scrollMax - rsInterface.height ? rsInterface.scrollMax - rsInterface.height : (rsInterface.scrollPosition += rotation * 30));
                return true;
            }
        }
        return false;
    }
}

