/*
 * Decompiled with CFR 0.152.
 */
package com.client.features.gametimers;

import com.client.Sprite;
import com.client.definitions.ItemDefinition;
import com.client.features.gametimers.GameTimerHandler;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;

public final class GameTimer
extends StopWatch {
    private final Sprite sprite;
    private final long duration;
    private final int id;

    public GameTimer(int id, TimeUnit unitOfTime, int duration) {
        this.id = id;
        this.sprite = GameTimerHandler.TIMER_IMAGES[id];
        this.duration = TimeUnit.MILLISECONDS.convert(duration, unitOfTime);
        this.start();
    }

    public GameTimer(int id, ItemDefinition itemDefinition, TimeUnit unitOfTime, int duration) {
        Objects.requireNonNull(itemDefinition, "ItemDefinition is null");
        Preconditions.checkState(id > 100, "Must use an id over 1000 for item timers.");
        this.id = id;
        this.sprite = ItemDefinition.getSprite(itemDefinition.id, 1, 0);
        this.duration = TimeUnit.MILLISECONDS.convert(duration, unitOfTime);
        this.start();
    }

    public final boolean isCompleted() {
        return this.getTime() >= this.duration && !this.isStopped();
    }

    public final int getSecondsRemaining() {
        long elapsed = this.getTime();
        if (elapsed > this.duration) {
            return 0;
        }
        return (int)TimeUnit.MILLISECONDS.toSeconds(this.duration - elapsed);
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public final int getTimerId() {
        return this.id;
    }
}

