/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.Client;
import com.client.Sprite;
import com.client.definitions.ItemDefinition;
import java.util.concurrent.ThreadLocalRandom;

public class CryptPlunder {
    private final int width;
    private final int height;
    private final int strokeWidth;
    private final int color;
    private final int alpha;
    private final int closure;
    private final boolean fill;
    private final Sprite icon;
    private double angleVel = 0.0;
    private double angle = 0.0;
    private int index = -1;
    private int currentIndex = -1;
    private long startTime;
    private long endTime;
    private final double INITIAL_DRAG = 0.993;
    private final double LATER_DRAG = 0.988;
    private int[] items = new int[]{6970, 6970, 6970, 6970, 6970, 6970, 6970, 6970, 6970, 6970};
    private boolean active;
    private int[] pyramidSequence = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private int stepsTaken;
    private int totalSteps;
    private final Sprite hoverSprite;

    public CryptPlunder(int width, int height, int strokeWidth, int color, int alpha, int closure, boolean fill, int segments, Sprite icon, Sprite hoverSprite) {
        this.width = width;
        this.height = height;
        this.strokeWidth = strokeWidth;
        this.color = color;
        this.alpha = alpha;
        this.closure = closure;
        this.fill = fill;
        this.icon = icon;
        this.hoverSprite = hoverSprite;
    }

    public void render(int x, int y) {
        int[] rowCounts = new int[]{1, 2, 3, 4};
        int totalRows = rowCounts.length;
        int maxBoxesInRow = rowCounts[totalRows - 1];
        int slotWidth = this.width / maxBoxesInRow;
        int slotHeight = this.height / totalRows;
        int idx = 0;
        this.update();
        for (int row = 0; row < totalRows; ++row) {
            int boxesInRow = rowCounts[row];
            int rowWidth = boxesInRow * slotWidth;
            int rowXStart = x + (this.width - rowWidth) / 2;
            int rowY = y + row * slotHeight;
            for (int col = 0; col < boxesInRow; ++col) {
                int slotX = rowXStart + col * slotWidth;
                if (idx < this.items.length) {
                    Sprite itemSprite = ItemDefinition.getSprite(this.items[idx], 1, 0);
                    if (ItemDefinition.lookup((int)this.items[idx]).customSpriteLocation != null) {
                        itemSprite = new Sprite(ItemDefinition.lookup((int)this.items[idx]).customSpriteLocation);
                    }
                    if (itemSprite != null) {
                        int itemX = slotX + (slotWidth - itemSprite.myWidth) / 2;
                        int itemY = rowY + (slotHeight - itemSprite.myHeight) / 2;
                        itemSprite.drawSprite(itemX, itemY);
                    }
                }
                ++idx;
            }
        }
        if (this.currentIndex >= 0) {
            int selectedRow = 0;
            int selectedCol = 0;
            int cumulativeIndex = 0;
            for (int row = 0; row < totalRows; ++row) {
                if (this.currentIndex < cumulativeIndex + rowCounts[row]) {
                    selectedRow = row;
                    selectedCol = this.currentIndex - cumulativeIndex;
                    break;
                }
                cumulativeIndex += rowCounts[row];
            }
            int hoverRowWidth = rowCounts[selectedRow] * slotWidth;
            int hoverRowXStart = x + (this.width - hoverRowWidth) / 2;
            int hoverX = hoverRowXStart + selectedCol * slotWidth;
            int hoverY = y + selectedRow * slotHeight;
            this.hoverSprite.drawAdvancedSprite(hoverX + (slotWidth - this.hoverSprite.myWidth) / 2, hoverY + (slotHeight - this.hoverSprite.myHeight) / 2);
        }
        this.icon.drawAdvancedSprite(x + this.width / 2 - this.icon.myWidth / 2, y - this.height / 12);
    }

    public void init() {
        this.angle = 0.0;
        this.angleVel = 0.05;
        this.totalSteps = ThreadLocalRandom.current().nextInt(300, 600);
        this.startTime = System.currentTimeMillis();
        this.endTime = this.startTime + (long)(this.totalSteps * 5);
        this.active = true;
    }

    public void update() {
        if (!this.active) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.startTime;
        if (currentTime >= this.endTime) {
            this.active = false;
            this.currentIndex = this.index;
            this.notifyServer();
            return;
        }
        double progress = (double)elapsedTime / (double)(this.endTime - this.startTime);
        double drag = Math.max(0.1, 0.993 - progress * 0.1);
        this.angleVel *= drag;
        ++this.stepsTaken;
        this.currentIndex = this.pyramidSequence[this.stepsTaken % this.pyramidSequence.length];
        this.angle += this.angleVel;
        if (this.angle >= 360.0) {
            this.angle -= 360.0;
        }
    }

    public void setItems(int[] items) {
        this.items = items;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    private void notifyServer() {
        Client.stream.createFrame(124);
        Client.stream.writeDWord(73331);
        Client.stream.writeDWord(this.index);
        Client.stream.writeDWord(this.items[this.index]);
        Client.stream.writeDWord(this.index);
    }
}

