/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.Sprite;
import com.client.definitions.ItemDefinition;
import com.client.graphics.interfaces.RSInterface;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class SpawnContainer
extends RSInterface {
    private static final SpawnContainer INSTANCE = new SpawnContainer();
    public static final int INTERFACE_ID = 43214;
    private static final Sprite BG = new Sprite("spawner/bg");
    private int containerInterfaceId;

    public static SpawnContainer get() {
        return INSTANCE;
    }

    private SpawnContainer() {
    }

    public void load() {
        int interfaceId = 43214;
        int childId = 0;
        RSInterface inter = SpawnContainer.addInterface(interfaceId++);
        inter.totalChildren(5);
        SpawnContainer.addSprite(interfaceId, BG);
        inter.child(childId++, interfaceId++, 12, 18);
        SpawnContainer.addInputField(interfaceId, 50, 15108608, "Search", 132, 23, false, true);
        SpawnContainer.get((int)interfaceId).inputFieldSendPacket = false;
        inter.child(childId++, interfaceId++, 17, 24);
        RSInterface scrollable = SpawnContainer.addInterface(interfaceId++);
        scrollable.scrollMax = 6000;
        scrollable.width = 470;
        scrollable.height = 260;
        scrollable.invAutoScrollHeightOffset = 0;
        scrollable.totalChildren(1);
        this.containerInterfaceId = interfaceId;
        SpawnContainer.addItemContainerAutoScrollable(interfaceId, 14, 400, 1, 0, true, scrollable.id, "Spawn", "Spawn 5,000", "Spawn X");
        SpawnContainer.get((int)this.containerInterfaceId).hideInvStackSizes = true;
        scrollable.child(0, interfaceId++, 4, 4);
        inter.child(childId++, scrollable.id, 20, 58);
        inter.child(childId++, 37302, 484, 28);
        inter.child(childId++, 37303, 484, 28);
        this.update("");
    }

    public void update(String message) {
        int index;
        int maxSlots;
        RSInterface container = SpawnContainer.get(this.containerInterfaceId);
        if (container == null) {
            return;
        }
        int n = maxSlots = container.inventoryItemId != null ? container.inventoryItemId.length : 0;
        if (maxSlots == 0) {
            return;
        }
        String needle = message == null ? "" : message.trim().toLowerCase();
        ArrayList<Integer> matches = Lists.newArrayList();
        for (int i = 0; i < 100000 && matches.size() < maxSlots; ++i) {
            ItemDefinition def = ItemDefinition.lookup(i);
            if (def == null || def.name == null || def.name.isEmpty() || def.name.contains("Dwarf remains") || !needle.isEmpty() && !def.name.toLowerCase().contains(needle)) continue;
            matches.add(i);
        }
        int fill = Math.min(matches.size(), maxSlots);
        for (index = 0; index < fill; ++index) {
            int itemId = (Integer)matches.get(index);
            container.inventoryItemId[index] = itemId + 1;
            container.inventoryAmounts[index] = 1;
        }
        for (index = maxSlots - 1; index >= fill; --index) {
            container.inventoryItemId[index] = 0;
            container.inventoryAmounts[index] = 0;
        }
    }

    public int getContainerInterfaceId() {
        return this.containerInterfaceId;
    }
}

