/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.settings;

import com.client.TextDrawingArea;
import com.client.graphics.interfaces.RSInterface;
import com.client.graphics.interfaces.dropdown.AntiAliasingMenu;
import com.client.graphics.interfaces.dropdown.BountyHunterMenu;
import com.client.graphics.interfaces.dropdown.ChatEffectMenu;
import com.client.graphics.interfaces.dropdown.DrawDistanceMenu;
import com.client.graphics.interfaces.dropdown.EntityTargetOverlayMenu;
import com.client.graphics.interfaces.dropdown.FogMenu;
import com.client.graphics.interfaces.dropdown.GameTimersMenu;
import com.client.graphics.interfaces.dropdown.GroundItemOverlayMenu;
import com.client.graphics.interfaces.dropdown.InventoryHoverMenu;
import com.client.graphics.interfaces.dropdown.OldGameframeMenu;
import com.client.graphics.interfaces.dropdown.PmNotificationMenu;
import com.client.graphics.interfaces.dropdown.SmoothShadingMenu;
import com.client.graphics.interfaces.dropdown.StretchedModeMenu;
import com.client.graphics.interfaces.dropdown.TileBlendingMenu;
import com.client.graphics.interfaces.impl.Interfaces;
import com.client.graphics.interfaces.settings.Setting;
import java.util.Arrays;

public class SettingsInterface
extends RSInterface {
    public static final Setting OLD_GAMEFRAME = new Setting("Gameframe", 1, new OldGameframeMenu(), "2006", "OSRS");
    public static final Setting GAME_TIMERS = new Setting("Game Timers", 0, new GameTimersMenu(), "On", "Off");
    public static final Setting ANTI_ALIASING = new Setting("Anti-aliasing", 1, new AntiAliasingMenu(), "On", "Off");
    public static final Setting GROUND_ITEM_NAMES = new Setting("Ground Item Names", 1, new GroundItemOverlayMenu(), "On", "Off");
    public static final Setting FOG = new Setting("Fog", 0, new FogMenu(), "On", "Off");
    public static final Setting SMOOTH_SHADING = new Setting("Smooth Shading", 0, new SmoothShadingMenu(), "On", "Off");
    public static final Setting TILE_BLENDING = new Setting("Tile blending", 1, new TileBlendingMenu(), "On", "Off");
    public static final Setting STRETCHED_MODE = new Setting("Stretched Mode", 1, new StretchedModeMenu(), "On", "Off");
    public static final Setting INVENTORY_MENU = new Setting("Inventory Menu", 1, new InventoryHoverMenu(), "Off", "On (Magenta)", "On (Lime green)", "On (Cyan)", "On (Red)");
    public static final Setting BOUNTY_HUNTER = new Setting("Bounty Hunter", 0, new BountyHunterMenu(), "On", "Off");
    public static final Setting ENTITY_TARGET = new Setting("Entity Target", 0, new EntityTargetOverlayMenu(), "On", "Off");
    public static final Setting CHAT_EFFECT = new Setting("Chat Effect", 0, new ChatEffectMenu(), "Yellow (default)", "Red", "Green", "Cyan", "Purple", "White", "Flash 1", "Flash 2", "Flash 3", "Glow 1", "Glow 2", "Glow 3");
    public static final Setting DRAW_DISTANCE = new Setting("Draw distance", 0, new DrawDistanceMenu(), "30 (default)", "40", "50", "60", "70");
    public static final Setting PM_NOTIFICATION = new Setting("Private message notification", 1, new PmNotificationMenu(), "On", "Off");
    private int childInterfaceId;
    private int childIndex;
    private int yOffset = 0;
    private RSInterface scroll;

    public void load(TextDrawingArea[] tda) {
        RSInterface tab = SettingsInterface.addInterface(39000);
        SettingsInterface.addSprite(39001, 0, "/Interfaces/settings/IMAGE");
        SettingsInterface.addText(39002, "Advanced Settings", tda, 2, 16753920, true, true);
        String dir = "/Interfaces/Prestige/SPRITE";
        SettingsInterface.addHoverButton(39021, dir, 1, 16, 16, "Close", -1, 39022, 3);
        SettingsInterface.addHoveredButton(39022, dir, 2, 16, 16, 39023);
        SettingsInterface.setChildren(5, tab);
        int index = 0;
        SettingsInterface.setBounds(39001, 16, 16, index++, tab);
        SettingsInterface.setBounds(39002, 253, 24, index++, tab);
        SettingsInterface.setBounds(39003, 30, 60, index++, tab);
        SettingsInterface.setBounds(39021, 478, 24, index++, tab);
        SettingsInterface.setBounds(39022, 478, 24, index++, tab);
        this.scroll = SettingsInterface.addInterface(39003);
        this.scroll.width = 448;
        this.scroll.height = 246;
        this.childInterfaceId = 39023;
        this.childIndex = 0;
        SettingsWidgetSection[] sections = new SettingsWidgetSection[]{new SettingsWidgetSection("Interface Options", OLD_GAMEFRAME, INVENTORY_MENU, BOUNTY_HUNTER, ENTITY_TARGET, GAME_TIMERS, CHAT_EFFECT, GROUND_ITEM_NAMES, PM_NOTIFICATION), new SettingsWidgetSection("Graphics Options", STRETCHED_MODE, DRAW_DISTANCE, ANTI_ALIASING, FOG, SMOOTH_SHADING, TILE_BLENDING)};
        Arrays.stream(sections).forEach(section -> {
            SettingsInterface.expandChildren(1, this.scroll);
            this.header((SettingsWidgetSection)section);
            Arrays.stream(section.settings).forEach(setting -> {
                SettingsInterface.expandChildren(2, this.scroll);
                this.build((Setting)setting);
            });
        });
        this.scroll.reverseChildren();
        this.scroll.scrollMax = this.yOffset + 32;
    }

    public void header(SettingsWidgetSection section) {
        SettingsInterface.addText(this.childInterfaceId, section.sectionName, Interfaces.defaultTextDrawingAreas, 2, 16753920, false, true);
        SettingsInterface.setBounds(this.childInterfaceId, 24, this.yOffset, this.childIndex, this.scroll);
        this.yOffset += 20;
        ++this.childInterfaceId;
        ++this.childIndex;
    }

    public void build(Setting setting) {
        setting.setInterfaceId(this.childInterfaceId + 1);
        SettingsInterface.addText(this.childInterfaceId, setting.getSettingName(), Interfaces.defaultTextDrawingAreas, 1, 16753920, false, true);
        SettingsInterface.dropdownMenu(setting.getInterfaceId(), 166, setting.getDefaultOption(), setting.getOptions(), setting.getMenuItem(), Interfaces.defaultTextDrawingAreas, 1);
        SettingsInterface.setBounds(this.childInterfaceId, 32, this.yOffset, this.childIndex, this.scroll);
        SettingsInterface.setBounds(this.childInterfaceId + 1, 260, this.yOffset, this.childIndex + 1, this.scroll);
        this.childInterfaceId += 2;
        this.childIndex += 2;
        this.yOffset += 25;
    }

    private static class SettingsWidgetSection {
        private final String sectionName;
        private final Setting[] settings;

        public SettingsWidgetSection(String sectionName, Setting ... settings) {
            this.sectionName = sectionName;
            this.settings = settings;
        }
    }
}

