/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.loaders;

import com.client.Buffer;
import com.client.Sprite;
import com.client.graphics.loaders.AnimatedSprite;
import com.client.sign.Signlink;
import com.client.utilities.FileOperations;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class SpriteLoader {
    public static Map<String, AnimatedSprite> animatedSpriteMap = new HashMap<String, AnimatedSprite>();
    public static SpriteLoader[] cache474;
    public static Sprite[] sprites474;
    public static SpriteLoader[] cache;
    public static Sprite[] sprites;
    public static int totalSprites;
    public String name = "name";
    public int id = -1;
    public int drawOffsetX = 0;
    public int drawOffsetY = 0;
    public byte[] spriteData = null;

    public static void loadSprites() {
        try {
            Buffer index = new Buffer(FileOperations.readFile(Signlink.getCacheDirectory() + "sprites.idx"));
            Buffer data2 = new Buffer(FileOperations.readFile(Signlink.getCacheDirectory() + "sprites.dat"));
            DataInputStream indexFile = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(index.payload)));
            DataInputStream dataFile = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(data2.payload)));
            int totalSprites = indexFile.readInt();
            if (cache == null) {
                cache = new SpriteLoader[totalSprites];
                sprites = new Sprite[totalSprites];
            }
            for (int i = 0; i < totalSprites; ++i) {
                int id = indexFile.readInt();
                if (cache[id] == null) {
                    SpriteLoader.cache[id] = new SpriteLoader();
                }
                cache[id].readValues(indexFile, dataFile);
                SpriteLoader.createSprite(cache[id]);
            }
            indexFile.close();
            dataFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readValues(DataInputStream index, DataInputStream data2) throws IOException {
        byte opCode;
        while ((opCode = data2.readByte()) != 0) {
            if (opCode == 1) {
                this.id = data2.readShort();
                continue;
            }
            if (opCode == 2) {
                this.name = data2.readUTF();
                continue;
            }
            if (opCode == 3) {
                this.drawOffsetX = data2.readShort();
                continue;
            }
            if (opCode == 4) {
                this.drawOffsetY = data2.readShort();
                continue;
            }
            if (opCode != 5) continue;
            int indexLength = index.readInt();
            byte[] dataread = new byte[indexLength];
            data2.readFully(dataread);
            this.spriteData = dataread;
        }
    }

    public static void resetAnimatedSprite(String location) {
        if (animatedSpriteMap.containsKey(location)) {
            animatedSpriteMap.remove(location);
        }
    }

    public static AnimatedSprite fetchAnimatedSprite(String location) {
        AnimatedSprite tempSprite;
        if (!animatedSpriteMap.containsKey(location) && (tempSprite = new AnimatedSprite(location)) != null) {
            animatedSpriteMap.put(location, tempSprite);
        }
        return animatedSpriteMap.get(location);
    }

    public static void createSprite(SpriteLoader sprite) {
        SpriteLoader.sprites[sprite.id] = new Sprite(sprite.spriteData);
        SpriteLoader.sprites[sprite.id].drawOffsetX = sprite.drawOffsetX;
        SpriteLoader.sprites[sprite.id].drawOffsetY = sprite.drawOffsetY;
    }

    public static String getName(int index) {
        if (SpriteLoader.cache[index].name != null) {
            return SpriteLoader.cache[index].name;
        }
        return "null";
    }

    public static int getOffsetX(int index) {
        return SpriteLoader.cache[index].drawOffsetX;
    }

    public static int getOffsetY(int index) {
        return SpriteLoader.cache[index].drawOffsetY;
    }

    public static void load474Sprites() {
        try {
            Buffer index = new Buffer(FileOperations.readFile(Signlink.getCacheDirectory() + "474 sprites.idx"));
            Buffer data2 = new Buffer(FileOperations.readFile(Signlink.getCacheDirectory() + "474 sprites.dat"));
            DataInputStream indexFile = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(index.payload)));
            DataInputStream dataFile = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(data2.payload)));
            int totalSprites = indexFile.readInt();
            if (cache474 == null) {
                cache474 = new SpriteLoader[totalSprites];
                sprites474 = new Sprite[totalSprites];
            }
            for (int i = 0; i < totalSprites; ++i) {
                int id = indexFile.readInt();
                if (cache474[id] == null) {
                    SpriteLoader.cache474[id] = new SpriteLoader();
                }
                cache474[id].readValues(indexFile, dataFile);
                SpriteLoader.createSprite474(cache474[id]);
            }
            indexFile.close();
            dataFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createSprite474(SpriteLoader sprite) {
        SpriteLoader.sprites474[sprite.id] = new Sprite(sprite.spriteData);
        SpriteLoader.sprites474[sprite.id].drawOffsetX = sprite.drawOffsetX;
        SpriteLoader.sprites474[sprite.id].drawOffsetY = sprite.drawOffsetY;
    }

    static {
        sprites474 = null;
        sprites = null;
    }
}

