/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.loaders;

import com.client.Buffer;
import com.client.Sprite;
import com.client.sign.Signlink;
import com.client.utilities.FileOperations;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public class SpriteLoader1 {
    public static SpriteLoader1[] cache;
    public static Sprite[] sprites;
    public static int totalSprites;
    public String name = "name";
    public int id = -1;
    public int drawOffsetX = 0;
    public int drawOffsetY = 0;
    public byte[] spriteData = null;

    public static void loadSprites() {
        try {
            Buffer index = new Buffer(FileOperations.readFile(Signlink.getCacheDirectory() + "media_archives/media_archive1.idx"));
            Buffer data2 = new Buffer(FileOperations.readFile(Signlink.getCacheDirectory() + "media_archives/media_archive1.dat"));
            DataInputStream indexFile = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(index.payload)));
            DataInputStream dataFile = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(data2.payload)));
            int totalSprites = indexFile.readInt();
            if (cache == null) {
                cache = new SpriteLoader1[totalSprites];
                sprites = new Sprite[totalSprites];
            }
            for (int i = 0; i < totalSprites; ++i) {
                int id = indexFile.readInt();
                if (cache[id] == null) {
                    SpriteLoader1.cache[id] = new SpriteLoader1();
                }
                cache[id].readValues(indexFile, dataFile);
                SpriteLoader1.createSprite(cache[id]);
            }
            indexFile.close();
            dataFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readValues(DataInputStream index, DataInputStream data2) throws IOException {
        byte opCode;
        while ((opCode = data2.readByte()) != 0) {
            if (opCode == 1) {
                this.id = data2.readShort();
                continue;
            }
            if (opCode == 2) {
                this.name = data2.readUTF();
                continue;
            }
            if (opCode == 3) {
                this.drawOffsetX = data2.readShort();
                continue;
            }
            if (opCode == 4) {
                this.drawOffsetY = data2.readShort();
                continue;
            }
            if (opCode != 5) continue;
            int indexLength = index.readInt();
            byte[] dataread = new byte[indexLength];
            data2.readFully(dataread);
            this.spriteData = dataread;
        }
    }

    public static void createSprite(SpriteLoader1 sprite) {
        SpriteLoader1.sprites[sprite.id] = new Sprite(sprite.spriteData);
        SpriteLoader1.sprites[sprite.id].drawOffsetX = sprite.drawOffsetX;
        SpriteLoader1.sprites[sprite.id].drawOffsetY = sprite.drawOffsetY;
    }

    public static String getName(int index) {
        if (SpriteLoader1.cache[index].name != null) {
            return SpriteLoader1.cache[index].name;
        }
        return "null";
    }

    public static int getOffsetX(int index) {
        return SpriteLoader1.cache[index].drawOffsetX;
    }

    public static int getOffsetY(int index) {
        return SpriteLoader1.cache[index].drawOffsetY;
    }

    static {
        sprites = null;
    }
}

