/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.textures;

import com.client.Buffer1;
import com.client.Deque;
import com.client.FileArchive;
import com.client.graphics.textures.Texture;
import com.client.graphics.textures.TextureLoader;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.runelite.rs.api.RSTexture;
import net.runelite.rs.api.RSTextureProvider;

public class TextureProvider
implements RSTextureProvider,
TextureLoader {
    private final Texture[] textures;
    private Deque deque = new Deque();
    private int capacity;
    private int remaining;
    private double brightness;
    private int textureSize;
    private final FileArchive archive;

    public TextureProvider(FileArchive textureArchive, FileArchive configArchive, int capacity, int textureSize) {
        this.archive = textureArchive;
        this.remaining = this.capacity = capacity;
        this.textureSize = textureSize;
        Buffer1 stream = new Buffer1(configArchive.readFile("textures.dat"));
        int textureCount = stream.readUShort();
        System.out.println("Loaded " + textureCount + " textures from textures.dat");
        int newTextureCount = 0;
        this.textures = new Texture[200];
        for (int var9 = 0; var9 < 200; ++var9) {
            Texture text;
            if (stream.currentPosition >= stream.payload.length) {
                newTextureCount = var9;
                System.out.println("Ran out of payload on texture [" + var9 + "]");
                break;
            }
            this.textures[text.id] = text = new Texture(stream);
        }
        for (int i = newTextureCount; i < 162; ++i) {
            Texture text;
            Texture originalTexture = this.textures[40];
            if (originalTexture == null) continue;
            this.textures[text.id] = text = new Texture(originalTexture, i);
        }
        this.setMaxSize(128);
        this.setSize(128);
    }

    @Override
    public double getBrightness() {
        return this.brightness;
    }

    @Override
    public void setBrightness(double brightness) {
        this.brightness = brightness;
        this.clear();
    }

    public void setTextureSize(int textureSize) {
        this.textureSize = textureSize;
        this.clear();
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.capacity = maxSize;
    }

    @Override
    public void setSize(int size) {
        this.remaining = size;
    }

    @Override
    public RSTexture[] getTextures() {
        return this.textures;
    }

    @Override
    public int[] load(int textureId) {
        return this.getTexturePixels(textureId);
    }

    @Override
    public int[] getTexturePixels(int textureID) {
        Texture texture = this.textures[textureID];
        if (texture != null) {
            if (texture.pixels != null) {
                this.deque.insertTail(texture);
                texture.isLoaded = true;
                return texture.pixels;
            }
            boolean hasLoaded = texture.load(this.brightness, this.textureSize, this.archive);
            if (hasLoaded) {
                if (this.remaining == 0) {
                    Texture currentTexture = (Texture)this.deque.popHead();
                    currentTexture.reset();
                } else {
                    --this.remaining;
                }
                this.deque.insertTail(texture);
                texture.isLoaded = true;
                return texture.pixels;
            }
        }
        return null;
    }

    @Override
    public int getAverageTextureRGB(int textureID) {
        return this.textures[textureID] != null ? this.textures[textureID].averageRGB : 0;
    }

    @Override
    public boolean isTransparent(int textureID) {
        return this.textures[textureID].isTransparent;
    }

    @Override
    public boolean isLowDetail(int textureID) {
        return this.textureSize == 64;
    }

    public void clear() {
        for (Texture texture : this.textures) {
            if (texture == null) continue;
            texture.reset();
        }
        this.deque = new Deque();
        this.remaining = this.capacity;
    }

    public void animate(int textureID) {
        for (Texture texture : this.textures) {
            if (texture == null || texture.animationDirection == 0 || !texture.isLoaded) continue;
            texture.animate(textureID);
            texture.isLoaded = false;
        }
    }

    private int[] loadTextureFromImage(File file) {
        try {
            BufferedImage img = ImageIO.read(file);
            int width = img.getWidth();
            int height = img.getHeight();
            int[] pixels = new int[width * height];
            img.getRGB(0, 0, width, height, pixels, 0, width);
            return pixels;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int adjustBrightness(int color, double factor) {
        int r = Math.min(255, (int)((double)(color >> 16 & 0xFF) * factor));
        int g2 = Math.min(255, (int)((double)(color >> 8 & 0xFF) * factor));
        int b = Math.min(255, (int)((double)(color & 0xFF) * factor));
        return r << 16 | g2 << 8 | b;
    }

    public int applyLighting(int color, double lightAngle, double surfaceNormal) {
        double lighting = Math.max(0.0, Math.cos(lightAngle - surfaceNormal));
        int r = (int)((double)(color >> 16 & 0xFF) * lighting);
        int g2 = (int)((double)(color >> 8 & 0xFF) * lighting);
        int b = (int)((double)(color & 0xFF) * lighting);
        return r << 16 | g2 << 8 | b;
    }

    public int[] generateMipMap(int[] pixels, int level) {
        int width = (int)Math.sqrt(pixels.length);
        int newSize = width >> level;
        int[] mipMap = new int[newSize * newSize];
        for (int y = 0; y < newSize; ++y) {
            for (int x = 0; x < newSize; ++x) {
                mipMap[y * newSize + x] = pixels[y * 2 * width + x * 2];
            }
        }
        return mipMap;
    }

    public int[] getMipmappedTexture(int textureID, int level) {
        Texture texture = this.textures[textureID];
        if (texture != null && texture.isLoaded) {
            return this.generateMipMap(texture.pixels, level);
        }
        return null;
    }
}

