/*
 * Decompiled with CFR 0.152.
 */
package com.client.util;

import com.client.Sprite;
import java.util.Map;

public class EnchantUtil {
    public static Sprite drawEnchantOverlay(Sprite baseSprite, Map<Integer, Integer> effects) {
        if (baseSprite == null || effects == null || effects.isEmpty()) {
            return baseSprite;
        }
        Sprite combined = new Sprite(baseSprite.myWidth, baseSprite.myHeight);
        System.arraycopy(baseSprite.myPixels, 0, combined.myPixels, 0, baseSprite.myPixels.length);
        int overlayX = 0;
        int overlayY = combined.myHeight - 9;
        for (Map.Entry<Integer, Integer> entry : effects.entrySet()) {
            int effectId = entry.getKey();
            Sprite overlay = EnchantUtil.getEnchantOverlaySprite(effectId);
            if (overlay == null) continue;
            for (int y = 0; y < overlay.myHeight; ++y) {
                for (int x = 0; x < overlay.myWidth; ++x) {
                    int newPixel;
                    int overlayPixel = overlay.myPixels[x + y * overlay.myWidth];
                    if (overlayPixel == 0) continue;
                    int combinedIndex = overlayX + x + (overlayY + y) * combined.myWidth;
                    int oldPixel = combined.myPixels[combinedIndex];
                    combined.myPixels[combinedIndex] = newPixel = EnchantUtil.blendPixels(oldPixel, overlayPixel);
                }
            }
            overlayX += overlay.myWidth + 2;
        }
        return combined;
    }

    public static Sprite outlineSprite(Sprite baseSprite, int outlineColor) {
        if (baseSprite == null) {
            return null;
        }
        int width = baseSprite.myWidth;
        int height = baseSprite.myHeight;
        int[] basePixels = baseSprite.myPixels;
        int[] outlinedPixels = new int[basePixels.length];
        System.arraycopy(basePixels, 0, outlinedPixels, 0, basePixels.length);
        int[] dx = new int[]{-1, 0, 1, -1, 1, -1, 0, 1};
        int[] dy = new int[]{-1, -1, -1, 0, 0, 1, 1, 1};
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int idx = x + y * width;
                if (EnchantUtil.isTransparent(basePixels[idx])) continue;
                for (int dir = 0; dir < 8; ++dir) {
                    int nIdx;
                    int nx = x + dx[dir];
                    int ny = y + dy[dir];
                    if (nx < 0 || nx >= width || ny < 0 || ny >= height || !EnchantUtil.isTransparent(basePixels[nIdx = nx + ny * width])) continue;
                    outlinedPixels[nIdx] = outlineColor | 0xFF000000;
                }
            }
        }
        return new Sprite(outlinedPixels, width, height);
    }

    public static Sprite drawEnchantOverlayWithOutline(Sprite baseSprite, Map<Integer, Integer> effects, int outlineColor) {
        Sprite outlined = new Sprite((int[])baseSprite.myPixels.clone(), baseSprite.myWidth, baseSprite.myHeight);
        outlined.outline(outlineColor);
        return EnchantUtil.drawEnchantOverlay(outlined, effects);
    }

    private static boolean isTransparent(int pixel) {
        return pixel >>> 24 == 0;
    }

    private static int blendPixels(int basePixel, int overlayPixel) {
        int overlayAlpha = overlayPixel >> 24 & 0xFF;
        if (overlayAlpha == 255) {
            return overlayPixel;
        }
        if (overlayAlpha == 0) {
            return basePixel;
        }
        int invAlpha = 255 - overlayAlpha;
        int baseR = basePixel >> 16 & 0xFF;
        int baseG = basePixel >> 8 & 0xFF;
        int baseB = basePixel & 0xFF;
        int overlayR = overlayPixel >> 16 & 0xFF;
        int overlayG = overlayPixel >> 8 & 0xFF;
        int overlayB = overlayPixel & 0xFF;
        int r = (overlayR * overlayAlpha + baseR * invAlpha) / 255;
        int g2 = (overlayG * overlayAlpha + baseG * invAlpha) / 255;
        int b = (overlayB * overlayAlpha + baseB * invAlpha) / 255;
        return 0xFF000000 | r << 16 | g2 << 8 | b;
    }

    public static Sprite getEnchantOverlaySprite(int effectId) {
        switch (effectId) {
            case 12: {
                return new Sprite("enchantsprites/freeze");
            }
            case 13: {
                return new Sprite("enchantsprites/burn");
            }
            case 14: {
                return new Sprite("enchantsprites/poison");
            }
            case 15: {
                return new Sprite("enchantsprites/stun");
            }
            case 16: {
                return new Sprite("enchantsprites/hpcore");
            }
            case 17: {
                return new Sprite("enchantsprites/cluecore");
            }
            case 18: {
                return new Sprite("enchantsprites/resourcecore");
            }
            case 19: {
                return new Sprite("enchantsprites/dropratecore");
            }
            case 20: {
                return new Sprite("enchantsprites/passcore");
            }
        }
        return null;
    }
}

