/*
 * Decompiled with CFR 0.152.
 */
package com.client.utilities;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class GetNetworkAddress {
    public static String GetAddress(String addressType) {
        String address;
        block7: {
            address = "";
            InetAddress lanIp = null;
            try {
                Enumeration<NetworkInterface> net = NetworkInterface.getNetworkInterfaces();
                while (net.hasMoreElements()) {
                    NetworkInterface element = net.nextElement();
                    Enumeration<InetAddress> addresses = element.getInetAddresses();
                    while (addresses.hasMoreElements() && element.getHardwareAddress() != null && element.getHardwareAddress().length > 0 && !GetNetworkAddress.isVMMac(element.getHardwareAddress())) {
                        InetAddress ip = addresses.nextElement();
                        if (!(ip instanceof Inet4Address) || !ip.isSiteLocalAddress()) continue;
                        String ipAddress = ip.getHostAddress();
                        lanIp = InetAddress.getByName(ipAddress);
                    }
                }
                if (lanIp == null) {
                    return null;
                }
                if (addressType.equals("ip")) {
                    address = lanIp.toString().replaceAll("^/+", "");
                    break block7;
                }
                if (addressType.equals("mac")) {
                    address = GetNetworkAddress.getMacAddress(lanIp);
                    break block7;
                }
                throw new Exception("Specify \"ip\" or \"mac\"");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return address;
    }

    private static String getMacAddress(InetAddress ip) {
        String address = null;
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            address = sb.toString();
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        return address;
    }

    private static boolean isVMMac(byte[] mac) {
        byte[][] invalidMacs;
        if (null == mac) {
            return false;
        }
        for (byte[] invalid : invalidMacs = new byte[][]{{0, 5, 105}, {0, 28, 20}, {0, 12, 41}, {0, 80, 86}, {8, 0, 39}, {10, 0, 39}, {0, 3, -1}, {0, 21, 93}}) {
            if (invalid[0] != mac[0] || invalid[1] != mac[1] || invalid[2] != mac[2]) continue;
            return true;
        }
        return false;
    }
}

