/*
 * Decompiled with CFR 0.152.
 */
package com.displee.compress;

import com.displee.cache.compress.type.BZIP2Compressor;
import com.displee.cache.index.archive.ArchiveSector;
import com.displee.compress.CompressionExtKt$WhenMappings;
import com.displee.compress.CompressionType;
import com.displee.compress.type.GZIPCompressor;
import com.displee.compress.type.LZMACompressor;
import com.displee.io.Buffer;
import com.displee.io.impl.InputBuffer;
import com.displee.io.impl.OutputBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\u0001*\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u000b"}, d2={"compress", "", "compressionType", "Lcom/displee/compress/CompressionType;", "xteas", "", "revision", "", "decompress", "Lcom/displee/cache/index/archive/ArchiveSector;", "keys", "rs-cache-library"})
public final class CompressionExtKt {
    @NotNull
    public static final byte[] compress(@NotNull byte[] $this$compress, @NotNull CompressionType compressionType, @Nullable int[] xteas, int revision) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull($this$compress, "$this$compress");
        Intrinsics.checkParameterIsNotNull((Object)compressionType, "compressionType");
        switch (CompressionExtKt$WhenMappings.$EnumSwitchMapping$0[compressionType.ordinal()]) {
            case 1: {
                byArray = $this$compress;
                break;
            }
            case 2: {
                byte[] byArray2 = BZIP2Compressor.compress($this$compress);
                byArray = byArray2;
                Intrinsics.checkExpressionValueIsNotNull(byArray2, "BZIP2Compressor.compress(this)");
                break;
            }
            case 3: {
                byArray = GZIPCompressor.INSTANCE.deflate($this$compress);
                break;
            }
            case 4: {
                byArray = LZMACompressor.INSTANCE.compress($this$compress);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        byte[] compressed = byArray;
        OutputBuffer buffer = new OutputBuffer(9 + compressed.length + (revision == -1 ? 0 : 2));
        buffer.writeByte(compressionType.ordinal()).writeInt(compressed.length);
        if (compressionType != CompressionType.NONE) {
            buffer.writeInt($this$compress.length);
        }
        buffer.writeBytes(compressed);
        if (xteas != null && (xteas[0] != 0 || xteas[1] != 0 || xteas[2] != 0 || xteas[3] != 0)) {
            boolean bl = compressionType != CompressionType.BZIP2;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = "BZIP2 compression doesn't work with xtea encryption.";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            buffer.encryptXTEA(xteas, 5, buffer.getOffset());
        }
        if (revision != -1) {
            buffer.writeShort(revision);
        }
        return Buffer.array$default(buffer, 0, 0, 3, null);
    }

    public static /* synthetic */ byte[] compress$default(byte[] byArray, CompressionType compressionType, int[] nArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            nArray = null;
        }
        if ((n2 & 4) != 0) {
            n = -1;
        }
        return CompressionExtKt.compress(byArray, compressionType, nArray, n);
    }

    @NotNull
    public static final byte[] decompress(@NotNull ArchiveSector $this$decompress, @Nullable int[] keys2) {
        Intrinsics.checkParameterIsNotNull($this$decompress, "$this$decompress");
        byte[] compressedData = $this$decompress.getData();
        InputBuffer buffer = new InputBuffer(compressedData);
        if (keys2 != null && (keys2[0] != 0 || keys2[1] != 0 || keys2[2] != 0 || keys2[3] != 0)) {
            buffer.decryptXTEA(keys2, 5, compressedData.length);
        }
        int type2 = buffer.readUnsignedByte();
        CompressionType compressionType = CompressionType.Companion.getCompressionTypes()[type2];
        boolean bl = false;
        boolean bl2 = false;
        CompressionType it = compressionType;
        boolean bl3 = false;
        $this$decompress.setCompressionType(it);
        CompressionType compressionType2 = compressionType;
        int compressedSize = buffer.readInt() & 0xFFFFFF;
        int decompressedSize = 0;
        if (compressionType2 != CompressionType.NONE) {
            decompressedSize = buffer.readInt() & 0xFFFFFF;
        }
        byte[] decompressed = new byte[decompressedSize];
        switch (CompressionExtKt$WhenMappings.$EnumSwitchMapping$1[compressionType2.ordinal()]) {
            case 1: {
                decompressed = buffer.readBytes(compressedSize);
                break;
            }
            case 2: {
                BZIP2Compressor.decompress(decompressed, decompressed.length, compressedData, compressedSize, 9);
                break;
            }
            case 3: {
                if (GZIPCompressor.INSTANCE.inflate(buffer, decompressed)) break;
                return new byte[0];
            }
            case 4: {
                decompressed = LZMACompressor.INSTANCE.decompress(buffer, decompressedSize);
            }
        }
        return decompressed;
    }

    public static /* synthetic */ byte[] decompress$default(ArchiveSector archiveSector, int[] nArray, int n, Object object) {
        if ((n & 1) != 0) {
            nArray = null;
        }
        return CompressionExtKt.decompress(archiveSector, nArray);
    }
}

