/*
 * Decompiled with CFR 0.152.
 */
package com.displee.compress.type;

import com.displee.io.impl.InputBuffer;
import com.displee.io.impl.OutputBuffer;
import com.displee.util.OtherExtKt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import lzma.sdk.lzma.Decoder;
import lzma.sdk.lzma.Encoder;
import lzma.streams.LzmaEncoderWrapper;
import lzma.streams.LzmaOutputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/displee/compress/type/LZMACompressor;", "", "()V", "DECODER", "Llzma/sdk/lzma/Decoder;", "ENCODER", "Llzma/sdk/lzma/Encoder;", "ENCODER_WRAPPER", "Llzma/streams/LzmaEncoderWrapper;", "compress", "", "decompressed", "decompress", "buffer", "Lcom/displee/io/impl/InputBuffer;", "decompressedLength", "", "input", "Ljava/io/ByteArrayInputStream;", "compressed", "rs-cache-library"})
public final class LZMACompressor {
    private static final Decoder DECODER;
    private static final Encoder ENCODER;
    private static final LzmaEncoderWrapper ENCODER_WRAPPER;
    public static final LZMACompressor INSTANCE;

    @NotNull
    public final byte[] compress(@NotNull byte[] decompressed) {
        Intrinsics.checkParameterIsNotNull(decompressed, "decompressed");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(decompressed);
            LzmaOutputStream lzma = new LzmaOutputStream((OutputStream)baos, ENCODER_WRAPPER);
            OtherExtKt.writeTo(bais, lzma);
            baos.close();
            lzma.close();
            bais.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "baos.toByteArray()");
        return byArray;
    }

    @NotNull
    public final byte[] decompress(@NotNull InputBuffer buffer, int decompressedLength) {
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        OutputBuffer output = new OutputBuffer(buffer.remaining());
        output.writeBytes(buffer.raw(), buffer.getOffset(), buffer.remaining());
        return this.decompress(output.raw(), decompressedLength);
    }

    @NotNull
    public final byte[] decompress(@NotNull byte[] compressed, int decompressedLength) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull(compressed, "compressed");
        try {
            byArray = this.decompress(new ByteArrayInputStream(compressed), decompressedLength);
        }
        catch (IOException e) {
            e.printStackTrace();
            byArray = new byte[]{};
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] decompress(@NotNull ByteArrayInputStream input, int decompressedLength) throws IOException {
        Intrinsics.checkParameterIsNotNull(input, "input");
        byte[] properties2 = new byte[5];
        if (input.read(properties2) != 5) {
            throw (Throwable)new IOException("LZMA: Bad input.");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream(decompressedLength);
        Decoder decoder = DECODER;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (decoder) {
            boolean bl3 = false;
            if (!DECODER.setDecoderProperties(properties2)) {
                throw (Throwable)new IOException("LZMA: Bad properties.");
            }
            bl2 = DECODER.code(input, output, decompressedLength);
        }
        output.flush();
        byte[] byArray = output.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "output.toByteArray()");
        return byArray;
    }

    private LZMACompressor() {
    }

    static {
        LZMACompressor lZMACompressor;
        INSTANCE = lZMACompressor = new LZMACompressor();
        DECODER = new Decoder();
        ENCODER = new Encoder();
        ENCODER_WRAPPER = new LzmaEncoderWrapper(lZMACompressor, ENCODER){
            final /* synthetic */ LZMACompressor this$0;

            public void code(@NotNull InputStream inputStream2, @NotNull OutputStream outputStream2) throws IOException {
                Intrinsics.checkParameterIsNotNull(inputStream2, "inputStream");
                Intrinsics.checkParameterIsNotNull(outputStream2, "outputStream");
                LZMACompressor.access$getENCODER$p(LZMACompressor.INSTANCE).writeCoderProperties(outputStream2);
                LZMACompressor.access$getENCODER$p(LZMACompressor.INSTANCE).code(inputStream2, outputStream2, -1L, -1L, null);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        ENCODER.setDictionarySize(0x800000);
        ENCODER.setNumFastBytes(110);
        ENCODER.setMatchFinder(0);
        ENCODER.setLcLpPb(3, 0, 2);
        ENCODER.setEndMarkerMode(false);
    }

    public static final /* synthetic */ Encoder access$getENCODER$p(LZMACompressor $this) {
        LZMACompressor lZMACompressor = $this;
        return ENCODER;
    }
}

