/*
 * Decompiled with CFR 0.152.
 */
package com.displee.io;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\n\b&\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0014\u001a\u00020\u00062\b\b\u0002\u0010\u0015\u001a\u00020\u00032\b\b\u0002\u0010\u0016\u001a\u00020\u0003H\u0007J\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003J,\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u00032\b\b\u0002\u0010\u0016\u001a\u00020\u0003H\u0007J\u0006\u0010\u001d\u001a\u00020\u001eJ\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0003J\u0016\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010!\u001a\u00020\u0010J\u0006\u0010\"\u001a\u00020\u0010J\u0006\u0010#\u001a\u00020\u0010J\u0006\u0010$\u001a\u00020\u0010J\u0006\u0010%\u001a\u00020\u001eJ\u0006\u0010\u000f\u001a\u00020\u001eJ\u0006\u0010&\u001a\u00020\u0006J\u0006\u0010'\u001a\u00020\u0003J\u0006\u0010(\u001a\u00020\u001eR\u001a\u0010\b\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0007R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\n\"\u0004\b\u0013\u0010\u0004\u00a8\u0006*"}, d2={"Lcom/displee/io/Buffer;", "", "capacity", "", "(I)V", "data", "", "([B)V", "bitPosition", "getBitPosition", "()I", "setBitPosition", "getData", "()[B", "setData", "msb", "", "offset", "getOffset", "setOffset", "array", "start", "length", "i", "cryptRSA", "exponent", "Ljava/math/BigInteger;", "modulus", "startOffset", "finishBitAccess", "", "get", "", "hasBitAccess", "hasRemaining", "isLsb", "isMsb", "lsb", "raw", "remaining", "startBitAccess", "Companion", "disio"})
public abstract class Buffer {
    @NotNull
    private byte[] data;
    private int offset;
    private boolean msb;
    private int bitPosition;
    public static final int BYTE_SIZE = 8;
    @NotNull
    private static final int[] BIT_MASK;
    public static final Companion Companion;

    @NotNull
    protected final byte[] getData() {
        return this.data;
    }

    protected final void setData(@NotNull byte[] byArray) {
        Intrinsics.checkParameterIsNotNull(byArray, "<set-?>");
        this.data = byArray;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    protected final int getBitPosition() {
        return this.bitPosition;
    }

    protected final void setBitPosition(int n) {
        this.bitPosition = n;
    }

    public final byte get(int offset) {
        return this.data[offset];
    }

    public final void get(@NotNull byte[] data2, int offset, int length) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        System.arraycopy(this.data, offset, data2, offset, length + offset);
    }

    @NotNull
    public final byte[] get(int offset, int length) {
        byte[] data2 = new byte[length];
        this.get(data2, offset, data2.length);
        return data2;
    }

    public final void msb() {
        this.msb = true;
    }

    public final void lsb() {
        this.msb = false;
    }

    public final void startBitAccess() {
        boolean bl = this.offset > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Offset has to be at least 1! ";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.bitPosition = this.offset * 8;
    }

    public final int bitPosition(int i) {
        return 8 * i - this.bitPosition;
    }

    public final void finishBitAccess() {
        this.offset = (this.bitPosition + 7) / 8;
        this.bitPosition = 0;
    }

    @JvmOverloads
    @NotNull
    public final byte[] cryptRSA(@NotNull BigInteger exponent, @NotNull BigInteger modulus, int startOffset, int length) {
        Intrinsics.checkParameterIsNotNull(exponent, "exponent");
        Intrinsics.checkParameterIsNotNull(modulus, "modulus");
        return Companion.cryptRSA(this.get(startOffset, length + startOffset), exponent, modulus);
    }

    public static /* synthetic */ byte[] cryptRSA$default(Buffer buffer, BigInteger bigInteger, BigInteger bigInteger2, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: cryptRSA");
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = buffer.offset;
        }
        return buffer.cryptRSA(bigInteger, bigInteger2, n, n2);
    }

    @JvmOverloads
    @NotNull
    public final byte[] cryptRSA(@NotNull BigInteger exponent, @NotNull BigInteger modulus, int startOffset) {
        return Buffer.cryptRSA$default(this, exponent, modulus, startOffset, 0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] cryptRSA(@NotNull BigInteger exponent, @NotNull BigInteger modulus) {
        return Buffer.cryptRSA$default(this, exponent, modulus, 0, 0, 12, null);
    }

    public final boolean hasBitAccess() {
        return this.bitPosition != 0;
    }

    public final boolean isMsb() {
        return this.msb;
    }

    public final boolean isLsb() {
        return !this.msb;
    }

    public final boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public final int remaining() {
        return this.data.length - this.offset;
    }

    @JvmOverloads
    @NotNull
    public final byte[] array(int start, int length) {
        byte[] array = new byte[length];
        this.get(array, start, length);
        return array;
    }

    public static /* synthetic */ byte[] array$default(Buffer buffer, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: array");
        }
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = buffer.offset;
        }
        return buffer.array(n, n2);
    }

    @JvmOverloads
    @NotNull
    public final byte[] array(int start) {
        return Buffer.array$default(this, start, 0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] array() {
        return Buffer.array$default(this, 0, 0, 3, null);
    }

    @NotNull
    public final byte[] raw() {
        return this.data;
    }

    public Buffer(int capacity) {
        this.msb = true;
        this.data = new byte[capacity];
    }

    public Buffer(@NotNull byte[] data2) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        this.msb = true;
        this.data = data2;
    }

    /*
     * WARNING - void declaration
     */
    static {
        Companion = new Companion(null);
        int n = 32;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            void i;
            int n3;
            int n4 = n2;
            int n5 = n2++;
            int[] nArray2 = nArray;
            boolean bl = false;
            nArray2[n5] = n3 = (1 << i) - 1;
        }
        BIT_MASK = nArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] cryptRSA(@NotNull byte[] data2, @NotNull BigInteger exponent, @NotNull BigInteger modulus) {
        return Companion.cryptRSA(data2, exponent, modulus);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/displee/io/Buffer$Companion;", "", "()V", "BIT_MASK", "", "getBIT_MASK", "()[I", "BYTE_SIZE", "", "cryptRSA", "", "data", "exponent", "Ljava/math/BigInteger;", "modulus", "disio"})
    public static final class Companion {
        @NotNull
        public final int[] getBIT_MASK() {
            return BIT_MASK;
        }

        @JvmStatic
        @NotNull
        public final byte[] cryptRSA(@NotNull byte[] data2, @NotNull BigInteger exponent, @NotNull BigInteger modulus) {
            Intrinsics.checkParameterIsNotNull(data2, "data");
            Intrinsics.checkParameterIsNotNull(exponent, "exponent");
            Intrinsics.checkParameterIsNotNull(modulus, "modulus");
            byte[] byArray = new BigInteger(data2).modPow(exponent, modulus).toByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray, "BigInteger(data).modPow(\u2026t, modulus).toByteArray()");
            return byArray;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

