/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.internal.BytecodeGen;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.internal.InternalContext;
import com.google.inject.internal.InternalFlags;
import com.google.inject.internal.InternalProvisionException;
import com.google.inject.internal.SingleMemberInjector;
import com.google.inject.internal.SingleParameterInjector;
import com.google.inject.spi.InjectionPoint;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BiFunction;

final class SingleMethodInjector
implements SingleMemberInjector {
    private final InjectorImpl.MethodInvoker methodInvoker;
    private final SingleParameterInjector<?>[] parameterInjectors;
    private final InjectionPoint injectionPoint;

    SingleMethodInjector(InjectorImpl injector, InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        this.injectionPoint = injectionPoint;
        Method method = (Method)injectionPoint.getMember();
        this.methodInvoker = this.createMethodInvoker(method);
        this.parameterInjectors = injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
    }

    private InjectorImpl.MethodInvoker createMethodInvoker(final Method method) {
        int modifiers;
        if (InternalFlags.isBytecodeGenEnabled()) {
            try {
                final BiFunction<Object, Object[], Object> fastMethod = BytecodeGen.fastMethod(method);
                if (fastMethod != null) {
                    return new InjectorImpl.MethodInvoker(this){

                        @Override
                        public Object invoke(Object target, Object ... parameters2) throws InvocationTargetException {
                            try {
                                return fastMethod.apply(target, parameters2);
                            }
                            catch (Throwable e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    };
                }
            }
            catch (Exception | LinkageError fastMethod) {
                // empty catch block
            }
        }
        if (!Modifier.isPublic(modifiers = method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
        return new InjectorImpl.MethodInvoker(this){

            @Override
            public Object invoke(Object target, Object ... parameters2) throws IllegalAccessException, InvocationTargetException {
                return method.invoke(target, parameters2);
            }
        };
    }

    @Override
    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public void inject(InternalContext context, Object o) throws InternalProvisionException {
        Object[] parameters2 = SingleParameterInjector.getAll(context, this.parameterInjectors);
        try {
            this.methodInvoker.invoke(o, parameters2);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException userException) {
            Throwable cause = userException.getCause() != null ? userException.getCause() : userException;
            throw InternalProvisionException.errorInjectingMethod(cause).addSource(this.injectionPoint);
        }
    }
}

