/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.os.DynamicLinker;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.cache.TempJarCache;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jogamp.common.os.BionicDynamicLinker32bitImpl;
import jogamp.common.os.BionicDynamicLinker64BitImpl;
import jogamp.common.os.DynamicLinkerImpl;
import jogamp.common.os.MacOSXDynamicLinkerImpl;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.common.os.PosixDynamicLinkerImpl;
import jogamp.common.os.WindowsDynamicLinkerImpl;

public final class NativeLibrary
implements DynamicLookupHelper {
    private static final String[] prefixes;
    private static final String[] suffixes;
    private static final boolean isOSX;
    private final DynamicLinker dynLink;
    private long libraryHandle;
    private final String libraryPath;
    private final boolean global;
    private static boolean initializedFindLibraryMethod;
    private static Method findLibraryMethod;

    private NativeLibrary(DynamicLinker dynamicLinker, long l, String string2, boolean bl) {
        this.dynLink = dynamicLinker;
        this.libraryHandle = l;
        this.libraryPath = string2;
        this.global = bl;
        if (DEBUG) {
            System.err.println("NativeLibrary.open(): Successfully loaded: " + this);
        }
    }

    public final String toString() {
        return "NativeLibrary[" + this.dynLink.getClass().getSimpleName() + ", " + this.libraryPath + ", 0x" + Long.toHexString(this.libraryHandle) + ", global " + this.global + "]";
    }

    public static final NativeLibrary open(String string2, boolean bl, boolean bl2, ClassLoader classLoader, boolean bl3) throws SecurityException {
        return NativeLibrary.open(string2, string2, string2, bl, bl2, classLoader, bl3);
    }

    public static final NativeLibrary open(String string2, String string3, String string4, boolean bl, boolean bl2, ClassLoader classLoader, boolean bl3) throws SecurityException {
        List<String> list = NativeLibrary.enumerateLibraryPaths(string2, string3, string4, bl, bl2, classLoader);
        Platform.initSingleton();
        DynamicLinker dynamicLinker = NativeLibrary.getDynamicLinker();
        for (String string5 : list) {
            String string6;
            long l;
            if (DEBUG) {
                System.err.println("NativeLibrary.open(global " + bl3 + "): Trying to load " + string5);
            }
            Throwable throwable = null;
            try {
                l = bl3 ? dynamicLinker.openLibraryGlobal(string5, DEBUG) : dynamicLinker.openLibraryLocal(string5, DEBUG);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                l = 0L;
            }
            if (0L != l) {
                return new NativeLibrary(dynamicLinker, l, string5, bl3);
            }
            if (!DEBUG) continue;
            if (null != throwable) {
                System.err.println("NativeLibrary.open: Caught " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
            }
            try {
                string6 = dynamicLinker.getLastError();
            }
            catch (Throwable throwable3) {
                string6 = null;
            }
            System.err.println("NativeLibrary.open: Last error " + string6);
            if (null == throwable) continue;
            throwable.printStackTrace();
        }
        if (DEBUG) {
            System.err.println("NativeLibrary.open(global " + bl3 + "): Did not succeed in loading (" + string2 + ", " + string3 + ", " + string4 + ")");
        }
        return null;
    }

    @Override
    public final void claimAllLinkPermission() throws SecurityException {
        this.dynLink.claimAllLinkPermission();
    }

    @Override
    public final void releaseAllLinkPermission() throws SecurityException {
        this.dynLink.releaseAllLinkPermission();
    }

    @Override
    public final long dynamicLookupFunction(String string2) throws SecurityException {
        if (0L == this.libraryHandle) {
            throw new RuntimeException("Library is not open");
        }
        return this.dynLink.lookupSymbol(this.libraryHandle, string2);
    }

    @Override
    public final boolean isFunctionAvailable(String string2) throws SecurityException {
        if (0L == this.libraryHandle) {
            throw new RuntimeException("Library is not open");
        }
        return 0L != this.dynLink.lookupSymbol(this.libraryHandle, string2);
    }

    public final long dynamicLookupFunctionGlobal(String string2) throws SecurityException {
        return this.dynLink.lookupSymbolGlobal(string2);
    }

    final DynamicLinker dynamicLinker() {
        return this.dynLink;
    }

    static DynamicLinker getDynamicLinker() {
        DynamicLinkerImpl dynamicLinkerImpl;
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                dynamicLinkerImpl = new WindowsDynamicLinkerImpl();
                break;
            }
            case MACOS: 
            case IOS: {
                dynamicLinkerImpl = new MacOSXDynamicLinkerImpl();
                break;
            }
            case ANDROID: {
                if (PlatformPropsImpl.CPU_ARCH.is32Bit) {
                    dynamicLinkerImpl = new BionicDynamicLinker32bitImpl();
                    break;
                }
                dynamicLinkerImpl = new BionicDynamicLinker64BitImpl();
                break;
            }
            default: {
                dynamicLinkerImpl = new PosixDynamicLinkerImpl();
            }
        }
        return dynamicLinkerImpl;
    }

    public final long getLibraryHandle() {
        return this.libraryHandle;
    }

    public final String getLibraryPath() {
        return this.libraryPath;
    }

    public final void close() throws SecurityException {
        if (DEBUG) {
            System.err.println("NativeLibrary.close(): closing " + this);
        }
        if (0L == this.libraryHandle) {
            throw new RuntimeException("Library already closed");
        }
        long l = this.libraryHandle;
        this.libraryHandle = 0L;
        this.dynLink.closeLibrary(l, DEBUG);
        if (DEBUG) {
            System.err.println("NativeLibrary.close(): Successfully closed " + this);
            ExceptionUtils.dumpStack(System.err);
        }
    }

    public static final String isValidNativeLibraryName(String string2, boolean bl) {
        int n;
        String string3;
        try {
            string3 = IOUtil.getBasename(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        String string4 = bl ? string3 : string3.toLowerCase();
        int n2 = -1;
        for (n = 0; n < prefixes.length && 0 > n2; ++n) {
            if (!string4.startsWith(prefixes[n])) continue;
            n2 = n;
        }
        if (0 <= n2) {
            for (n = 0; n < suffixes.length; ++n) {
                if (!string4.endsWith(suffixes[n])) continue;
                int n3 = prefixes[n2].length();
                int n4 = suffixes[n].length();
                return string3.substring(n3, string3.length() - n4);
            }
        }
        return null;
    }

    public static final List<String> enumerateLibraryPaths(String string2, String string3, String string4, ClassLoader classLoader) {
        return NativeLibrary.enumerateLibraryPaths(string2, string3, string4, false, false, classLoader);
    }

    public static final List<String> enumerateLibraryPaths(String string2, String string3, String string4, boolean bl, ClassLoader classLoader) {
        return NativeLibrary.enumerateLibraryPaths(string2, string3, string4, true, bl, classLoader);
    }

    private static final List<String> enumerateLibraryPaths(String string2, String string3, String string4, final boolean bl, final boolean bl2, ClassLoader classLoader) {
        String[] stringArray;
        String string5;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string6 = NativeLibrary.selectName(string2, string3, string4);
        if (string6 == null) {
            return arrayList;
        }
        File file = new File(string6);
        if (file.isAbsolute()) {
            arrayList.add(string6);
            return arrayList;
        }
        String[] stringArray2 = NativeLibrary.buildNames(string6);
        if (bl && bl2) {
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList.add(stringArray2[i]);
            }
            if (isOSX) {
                NativeLibrary.addPaths("/Library/Frameworks/" + string6 + ".framework", stringArray2, arrayList);
                NativeLibrary.addPaths("/System/Library/Frameworks/" + string6 + ".framework", stringArray2, arrayList);
            }
        }
        if ((string5 = NativeLibrary.findLibrary(string6, classLoader)) != null) {
            arrayList.add(string5);
        }
        if (null != (stringArray = AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                String string2;
                int n = 0;
                String string3 = System.getProperty("java.library.path");
                if (null != string3) {
                    ++n;
                }
                if (bl) {
                    string2 = System.getProperty("sun.boot.library.path");
                    if (null != string2) {
                        ++n;
                    }
                } else {
                    string2 = null;
                }
                String[] stringArray = new String[n];
                int n2 = 0;
                if (null != string2 && bl2) {
                    stringArray[n2++] = string2;
                }
                if (null != string3) {
                    stringArray[n2++] = string3;
                }
                if (null != string2 && !bl2) {
                    stringArray[n2++] = string2;
                }
                return stringArray;
            }
        }))) {
            for (int i = 0; i < stringArray.length; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    NativeLibrary.addPaths(stringTokenizer.nextToken(), stringArray2, arrayList);
                }
            }
        }
        String string7 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.dir");
            }
        });
        NativeLibrary.addPaths(string7, stringArray2, arrayList);
        NativeLibrary.addPaths(string7 + File.separator + "natives" + File.separator + PlatformPropsImpl.os_and_arch + File.separator, stringArray2, arrayList);
        if (bl && !bl2) {
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList.add(stringArray2[i]);
            }
            if (isOSX) {
                NativeLibrary.addPaths("/Library/Frameworks/" + string6 + ".Framework", stringArray2, arrayList);
                NativeLibrary.addPaths("/System/Library/Frameworks/" + string6 + ".Framework", stringArray2, arrayList);
            }
        }
        return arrayList;
    }

    private static final String selectName(String string2, String string3, String string4) {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                return string2;
            }
            case MACOS: 
            case IOS: {
                return string4;
            }
        }
        return string3;
    }

    private static final String[] buildNames(String string2) {
        int n;
        int n2;
        int n3;
        int n4;
        String string3;
        try {
            string3 = IOUtil.getBasename(string2).toLowerCase();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        int n5 = -1;
        for (n4 = 0; n4 < prefixes.length && 0 > n5; ++n4) {
            if (!string3.startsWith(prefixes[n4])) continue;
            n5 = n4;
        }
        if (0 <= n5) {
            for (n4 = 0; n4 < suffixes.length; ++n4) {
                if (!string3.endsWith(suffixes[n4])) continue;
                return new String[]{string2};
            }
            n4 = -1;
            for (n3 = 0; n3 < suffixes.length && 0 > n4; ++n3) {
                n4 = string3.indexOf(suffixes[n3]);
            }
            n3 = 1;
            if (n4 >= 0) {
                for (n2 = n4 + suffixes[0].length(); n2 < string2.length(); ++n2) {
                    n = string2.charAt(n2);
                    if (n == 46 || n >= 48 && n <= 57) continue;
                    n3 = 0;
                    break;
                }
                if (n3 != 0) {
                    return new String[]{string2};
                }
            }
        }
        String[] stringArray = new String[prefixes.length * suffixes.length + (isOSX ? 1 : 0)];
        n3 = 0;
        for (n2 = 0; n2 < prefixes.length; ++n2) {
            for (n = 0; n < suffixes.length; ++n) {
                stringArray[n3++] = prefixes[n2] + string2 + suffixes[n];
            }
        }
        if (isOSX) {
            stringArray[n3++] = string2;
        }
        return stringArray;
    }

    private static final void addPaths(String string2, String[] stringArray, List<String> list) {
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(string2 + File.separator + stringArray[i]);
        }
    }

    private static final String findLibraryImpl(final String string2, final ClassLoader classLoader) {
        block6: {
            if (PlatformPropsImpl.JAVA_9) {
                return null;
            }
            if (classLoader == null) {
                return null;
            }
            if (!initializedFindLibraryMethod) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            findLibraryMethod = ClassLoader.class.getDeclaredMethod("findLibrary", String.class);
                            findLibraryMethod.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        initializedFindLibraryMethod = true;
                        return null;
                    }
                });
            }
            if (findLibraryMethod != null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            try {
                                return (String)findLibraryMethod.invoke((Object)classLoader, string2);
                            }
                            catch (Exception exception) {
                                throw new RuntimeException(exception);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    if (!DEBUG) break block6;
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    public static final String findLibrary(String string2, ClassLoader classLoader) {
        String string3 = null;
        if (TempJarCache.isInitialized(true)) {
            string3 = TempJarCache.findLibrary(string2);
            if (DEBUG) {
                System.err.println("NativeLibrary.findLibrary(<" + string2 + ">) (TempJarCache): " + string3);
            }
        }
        if (null == string3) {
            string3 = NativeLibrary.findLibraryImpl(string2, classLoader);
            if (DEBUG) {
                System.err.println("NativeLibrary.findLibrary(<" + string2 + ">, " + classLoader + ") (CL): " + string3);
            }
        }
        return string3;
    }

    static {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                prefixes = new String[]{""};
                suffixes = new String[]{".dll"};
                isOSX = false;
                break;
            }
            case MACOS: 
            case IOS: {
                prefixes = new String[]{"lib"};
                suffixes = new String[]{".dylib"};
                isOSX = true;
                break;
            }
            default: {
                prefixes = new String[]{"lib"};
                suffixes = new String[]{".so"};
                isOSX = false;
            }
        }
        initializedFindLibraryMethod = false;
        findLibraryMethod = null;
    }
}

