/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.cache.TempJarCache;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import jogamp.common.Debug;

public class SHASum {
    private static final boolean DEBUG = Debug.debug("SHASum");
    final MessageDigest digest;
    final List<String> origins;
    final List<Pattern> excludes;
    final List<Pattern> includes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long updateDigest(MessageDigest messageDigest, List<String> list) throws IOException {
        long l = 0L;
        byte[] byArray = new byte[4096];
        block3: for (int i = 0; i < list.size(); ++i) {
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(list.get(i)));){
                while (true) {
                    int n;
                    if ((n = ((InputStream)bufferedInputStream).read(byArray)) == -1) {
                        continue block3;
                    }
                    messageDigest.update(byArray, 0, n);
                    l += (long)n;
                }
            }
        }
        return l;
    }

    public static StringBuilder toHexString(byte[] byArray, StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(String.format((Locale)null, "%02x", byArray[i]));
        }
        return stringBuilder;
    }

    public static List<String> sort(ArrayList<String> arrayList) {
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(stringArray, 0, stringArray.length, null);
        return Arrays.asList(stringArray);
    }

    public SHASum(MessageDigest messageDigest, List<String> list, List<Pattern> list2, List<Pattern> list3) {
        this.digest = messageDigest;
        this.origins = list;
        this.excludes = list2;
        this.includes = list3;
    }

    public final byte[] compute(boolean bl) throws IOException {
        List<String> list = SHASum.sort(IOUtil.filesOf(this.origins, this.excludes, this.includes));
        if (bl) {
            for (int i = 0; i < list.size(); ++i) {
                System.err.println(list.get(i));
            }
        }
        long l = SHASum.updateDigest(this.digest, list);
        byte[] byArray = this.digest.digest();
        if (bl) {
            System.err.println("Digested " + l + " bytes, shasum size " + byArray.length + " bytes");
            System.err.println("Digested result: " + SHASum.toHexString(byArray, null).toString());
        }
        return byArray;
    }

    public final List<String> getOrigins() {
        return this.origins;
    }

    public final List<Pattern> getExcludes() {
        return this.excludes;
    }

    public final List<Pattern> getIncludes() {
        return this.includes;
    }

    public static void main(String[] stringArray) throws IOException {
        MessageDigest messageDigest;
        int n;
        boolean bl = false;
        int n2 = 256;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Pattern> arrayList2 = new ArrayList<Pattern>();
        ArrayList<Pattern> arrayList3 = new ArrayList<Pattern>();
        for (n = 0; n < stringArray.length; ++n) {
            if (null == stringArray[n]) continue;
            if (stringArray[n].startsWith("--")) {
                if (stringArray[n].equals("--algorithm")) {
                    n2 = Integer.parseInt(stringArray[++n]);
                    continue;
                }
                if (stringArray[n].equals("--exclude")) {
                    arrayList2.add(Pattern.compile(stringArray[++n]));
                    if (!DEBUG) continue;
                    System.err.println("adding exclude: <" + stringArray[n] + "> -> <" + arrayList2.get(arrayList2.size() - 1) + ">");
                    continue;
                }
                if (stringArray[n].equals("--include")) {
                    arrayList3.add(Pattern.compile(stringArray[++n]));
                    if (!DEBUG) continue;
                    System.err.println("adding include: <" + stringArray[n] + "> -> <" + arrayList3.get(arrayList3.size() - 1) + ">");
                    continue;
                }
                if (stringArray[n].equals("--listfilesonly")) {
                    bl = true;
                    continue;
                }
                System.err.println("Abort, unknown argument: " + stringArray[n]);
                return;
            }
            arrayList.add(stringArray[n]);
            if (!DEBUG) continue;
            System.err.println("adding path: <" + stringArray[n] + ">");
        }
        if (bl) {
            List<String> list = SHASum.sort(IOUtil.filesOf(arrayList, arrayList2, arrayList3));
            for (n = 0; n < list.size(); ++n) {
                System.out.println(list.get(n));
            }
            return;
        }
        String string2 = "SHA-" + n2;
        try {
            messageDigest = MessageDigest.getInstance(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Abort, implementation for " + string2 + " not available: " + noSuchAlgorithmException.getMessage());
            return;
        }
        SHASum sHASum = new SHASum(messageDigest, arrayList, arrayList2, arrayList3);
        System.out.println(SHASum.toHexString(sHASum.compute(DEBUG), null).toString());
    }

    public static class TempJarSHASum
    extends SHASum {
        public TempJarSHASum(MessageDigest messageDigest, Class<?> clazz, List<Pattern> list, List<Pattern> list2) throws SecurityException, IllegalArgumentException, IOException, URISyntaxException {
            super(messageDigest, Arrays.asList(IOUtil.slashify(TempJarCache.getTempFileCache().getTempDir().getAbsolutePath(), false, false)), list, list2);
            TempJarCache.addAll(clazz, JarUtil.getJarFileUri(clazz.getName(), clazz.getClassLoader()));
        }

        public final String getOrigin() {
            return (String)this.origins.get(0);
        }
    }
}

