/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.runtime.opengl;

public class GLNameResolver {
    private static final String[] extensionsARB = new String[]{"ARB", "GL2", "OES", "KHR", "OML"};
    private static final String[] extensionsVEN = new String[]{"3DFX", "AMD", "ANDROID", "ANGLE", "ARM", "APPLE", "ATI", "EXT", "FJ", "HI", "HP", "IBM", "IMG", "INGR", "INTEL", "MESA", "MESAX", "NV", "PGI", "QCOM", "SGI", "SGIS", "SGIX", "SUN", "VIV", "WIN"};

    public static final boolean isGLFunction(String string2) {
        return string2.startsWith("gl") || string2.startsWith("egl") || string2.startsWith("wgl") || string2.startsWith("agl") || string2.startsWith("cgl");
    }

    public static final boolean isGLEnumeration(String string2) {
        return string2.startsWith("GL_") || string2.startsWith("GLU_") || string2.startsWith("GLX_") || string2.startsWith("EGL_") || string2.startsWith("WGL_") || string2.startsWith("AGL_") || string2.startsWith("CGL_");
    }

    public static final int getExtensionIdx(String[] stringArray, String string2, boolean bl) {
        if (bl) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (!string2.endsWith(stringArray[i])) continue;
                return i;
            }
        } else {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (!string2.endsWith("_" + stringArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static final boolean isExtension(String[] stringArray, String string2, boolean bl) {
        return GLNameResolver.getExtensionIdx(stringArray, string2, bl) >= 0;
    }

    public static final String getExtensionSuffix(String string2, boolean bl) {
        int n = GLNameResolver.getExtensionIdx(extensionsARB, string2, bl);
        if (n >= 0) {
            return extensionsARB[n];
        }
        n = GLNameResolver.getExtensionIdx(extensionsVEN, string2, bl);
        if (n >= 0) {
            return extensionsVEN[n];
        }
        return null;
    }

    public static final String normalize(String[] stringArray, String string2, boolean bl) {
        boolean bl2 = false;
        for (int i = stringArray.length - 1; !bl2 && i >= 0; --i) {
            if (bl) {
                if (!string2.endsWith(stringArray[i])) continue;
                string2 = string2.substring(0, string2.length() - stringArray[i].length());
                bl2 = true;
                continue;
            }
            if (!string2.endsWith("_" + stringArray[i])) continue;
            string2 = string2.substring(0, string2.length() - 1 - stringArray[i].length());
            bl2 = true;
        }
        return string2;
    }

    public static final String normalizeARB(String string2, boolean bl) {
        return GLNameResolver.normalize(extensionsARB, string2, bl);
    }

    public static final boolean isExtensionARB(String string2, boolean bl) {
        return GLNameResolver.isExtension(extensionsARB, string2, bl);
    }

    public static final String normalizeVEN(String string2, boolean bl) {
        return GLNameResolver.normalize(extensionsVEN, string2, bl);
    }

    public static final boolean isExtensionVEN(String string2, boolean bl) {
        return GLNameResolver.isExtension(extensionsVEN, string2, bl);
    }

    public static final String normalize(String string2, boolean bl) {
        if (GLNameResolver.isExtensionARB(string2, bl)) {
            return GLNameResolver.normalizeARB(string2, bl);
        }
        if (GLNameResolver.isExtensionVEN(string2, bl)) {
            return GLNameResolver.normalizeVEN(string2, bl);
        }
        return string2;
    }

    public static final boolean isExtension(String string2, boolean bl) {
        return GLNameResolver.isExtension(extensionsARB, string2, bl) || GLNameResolver.isExtension(extensionsVEN, string2, bl);
    }

    public static final int getFuncNamePermutationNumber(String string2) {
        if (GLNameResolver.isExtensionARB(string2, true) || GLNameResolver.isExtensionVEN(string2, true)) {
            return 1;
        }
        return 1 + extensionsARB.length + extensionsVEN.length;
    }

    public static final String getFuncNamePermutation(String string2, int n) {
        if (n == 0) {
            return string2;
        }
        if (0 > n || n >= 1 + extensionsARB.length + extensionsVEN.length) {
            throw new RuntimeException("Index out of range [0.." + (1 + extensionsARB.length + extensionsVEN.length - 1) + "]: " + n);
        }
        if (--n < extensionsARB.length) {
            return string2 + extensionsARB[n];
        }
        return string2 + extensionsVEN[n -= extensionsARB.length];
    }
}

