/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.OptionalInt;

public class OptionalIntConverter
extends IntConverter
implements Converter {
    @Override
    public boolean canConvert(Class type2) {
        return type2 != null && type2 == OptionalInt.class;
    }

    @Override
    public void marshal(Object source2, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.setValue(this.toString(source2));
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String data2 = reader.getValue();
        if (!reader.hasMoreChildren()) {
            return this.fromString(data2);
        }
        reader.moveDown();
        boolean isPresent = (Boolean)context.convertAnother(context, Boolean.class);
        reader.moveUp();
        reader.moveDown();
        int value = (Integer)context.convertAnother(context, Integer.class);
        reader.moveUp();
        return isPresent ? OptionalInt.of(value) : OptionalInt.empty();
    }

    @Override
    public String toString(Object obj2) {
        OptionalInt optional = (OptionalInt)obj2;
        return optional.isPresent() ? super.toString(optional.getAsInt()) : "";
    }

    @Override
    public Object fromString(String str) {
        return str == null || str.length() == 0 ? OptionalInt.empty() : OptionalInt.of((Integer)super.fromString(str));
    }
}

