/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class ThrowableConverter
implements Converter {
    private Converter defaultConverter;
    private final ConverterLookup lookup;

    public ThrowableConverter(Converter defaultConverter) {
        this.defaultConverter = defaultConverter;
        this.lookup = null;
    }

    public ThrowableConverter(ConverterLookup lookup) {
        this.lookup = lookup;
    }

    public boolean canConvert(Class type2) {
        return type2 != null && Throwable.class.isAssignableFrom(type2);
    }

    public void marshal(Object source2, HierarchicalStreamWriter writer, MarshallingContext context) {
        Throwable throwable = (Throwable)source2;
        if (throwable.getCause() == null) {
            try {
                throwable.initCause(null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        throwable.getStackTrace();
        this.getConverter().marshal(throwable, writer, context);
    }

    private Converter getConverter() {
        return this.defaultConverter != null ? this.defaultConverter : this.lookup.lookupConverterForType(Object.class);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return this.getConverter().unmarshal(reader, context);
    }
}

